<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ASN_Line_Lot_Information_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Lot Information for Item on Advance Ship Notice Line
 * @subpackage Structs
 */
class ASN_Line_Lot_Information_Data_InboundType extends AbstractStructBase
{
    /**
     * The Lot_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for Item Lot Identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lot_Identifier;
    /**
     * The Manufacture_Date
     * Meta information extracted from the WSDL
     * - documentation: Manufacturer Date for the Item Lot
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacture_Date;
    /**
     * The Expiration_Date
     * Meta information extracted from the WSDL
     * - documentation: Expiration Date for the Item Lot
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expiration_Date;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Serial_Identifiers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ASN_Item_Serial_Data_InboundType[]
     */
    public $Serial_Identifiers;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Free form text for Item Lot Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for ASN_Line_Lot_Information_Data_InboundType
     * @uses ASN_Line_Lot_Information_Data_InboundType::setLot_Identifier()
     * @uses ASN_Line_Lot_Information_Data_InboundType::setManufacture_Date()
     * @uses ASN_Line_Lot_Information_Data_InboundType::setExpiration_Date()
     * @uses ASN_Line_Lot_Information_Data_InboundType::setQuantity()
     * @uses ASN_Line_Lot_Information_Data_InboundType::setSerial_Identifiers()
     * @uses ASN_Line_Lot_Information_Data_InboundType::setMemo()
     * @param string $lot_Identifier
     * @param string $manufacture_Date
     * @param string $expiration_Date
     * @param float $quantity
     * @param \StructType\ASN_Item_Serial_Data_InboundType[] $serial_Identifiers
     * @param string $memo
     */
    public function __construct($lot_Identifier = null, $manufacture_Date = null, $expiration_Date = null, $quantity = null, array $serial_Identifiers = array(), $memo = null)
    {
        $this
            ->setLot_Identifier($lot_Identifier)
            ->setManufacture_Date($manufacture_Date)
            ->setExpiration_Date($expiration_Date)
            ->setQuantity($quantity)
            ->setSerial_Identifiers($serial_Identifiers)
            ->setMemo($memo);
    }
    /**
     * Get Lot_Identifier value
     * @return string|null
     */
    public function getLot_Identifier()
    {
        return $this->Lot_Identifier;
    }
    /**
     * Set Lot_Identifier value
     * @param string $lot_Identifier
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function setLot_Identifier($lot_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($lot_Identifier) && !is_string($lot_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lot_Identifier, true), gettype($lot_Identifier)), __LINE__);
        }
        $this->Lot_Identifier = $lot_Identifier;
        return $this;
    }
    /**
     * Get Manufacture_Date value
     * @return string|null
     */
    public function getManufacture_Date()
    {
        return $this->Manufacture_Date;
    }
    /**
     * Set Manufacture_Date value
     * @param string $manufacture_Date
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function setManufacture_Date($manufacture_Date = null)
    {
        // validation for constraint: string
        if (!is_null($manufacture_Date) && !is_string($manufacture_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacture_Date, true), gettype($manufacture_Date)), __LINE__);
        }
        $this->Manufacture_Date = $manufacture_Date;
        return $this;
    }
    /**
     * Get Expiration_Date value
     * @return string|null
     */
    public function getExpiration_Date()
    {
        return $this->Expiration_Date;
    }
    /**
     * Set Expiration_Date value
     * @param string $expiration_Date
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function setExpiration_Date($expiration_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expiration_Date) && !is_string($expiration_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration_Date, true), gettype($expiration_Date)), __LINE__);
        }
        $this->Expiration_Date = $expiration_Date;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Serial_Identifiers value
     * @return \StructType\ASN_Item_Serial_Data_InboundType[]|null
     */
    public function getSerial_Identifiers()
    {
        return $this->Serial_Identifiers;
    }
    /**
     * This method is responsible for validating the values passed to the setSerial_Identifiers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerial_Identifiers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSerial_IdentifiersForArrayConstraintsFromSetSerial_Identifiers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aSN_Line_Lot_Information_Data_InboundTypeSerial_IdentifiersItem) {
            // validation for constraint: itemType
            if (!$aSN_Line_Lot_Information_Data_InboundTypeSerial_IdentifiersItem instanceof \StructType\ASN_Item_Serial_Data_InboundType) {
                $invalidValues[] = is_object($aSN_Line_Lot_Information_Data_InboundTypeSerial_IdentifiersItem) ? get_class($aSN_Line_Lot_Information_Data_InboundTypeSerial_IdentifiersItem) : sprintf('%s(%s)', gettype($aSN_Line_Lot_Information_Data_InboundTypeSerial_IdentifiersItem), var_export($aSN_Line_Lot_Information_Data_InboundTypeSerial_IdentifiersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Serial_Identifiers property can only contain items of type \StructType\ASN_Item_Serial_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Serial_Identifiers value
     * @throws \InvalidArgumentException
     * @param \StructType\ASN_Item_Serial_Data_InboundType[] $serial_Identifiers
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function setSerial_Identifiers(array $serial_Identifiers = array())
    {
        // validation for constraint: array
        if ('' !== ($serial_IdentifiersArrayErrorMessage = self::validateSerial_IdentifiersForArrayConstraintsFromSetSerial_Identifiers($serial_Identifiers))) {
            throw new \InvalidArgumentException($serial_IdentifiersArrayErrorMessage, __LINE__);
        }
        $this->Serial_Identifiers = $serial_Identifiers;
        return $this;
    }
    /**
     * Add item to Serial_Identifiers value
     * @throws \InvalidArgumentException
     * @param \StructType\ASN_Item_Serial_Data_InboundType $item
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function addToSerial_Identifiers(\StructType\ASN_Item_Serial_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ASN_Item_Serial_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Serial_Identifiers property can only contain items of type \StructType\ASN_Item_Serial_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Serial_Identifiers[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
