<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ASN_Item_Serial__Data_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents Serial Information for Item on Advance Ship Notice Line
 * @subpackage Structs
 */
class ASN_Item_Serial__Data_OutboundType extends AbstractStructBase
{
    /**
     * The Serial_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Item serial data for the line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Serial_Identifier;
    /**
     * Constructor method for ASN_Item_Serial__Data_OutboundType
     * @uses ASN_Item_Serial__Data_OutboundType::setSerial_Identifier()
     * @param string $serial_Identifier
     */
    public function __construct($serial_Identifier = null)
    {
        $this
            ->setSerial_Identifier($serial_Identifier);
    }
    /**
     * Get Serial_Identifier value
     * @return string|null
     */
    public function getSerial_Identifier()
    {
        return $this->Serial_Identifier;
    }
    /**
     * Set Serial_Identifier value
     * @param string $serial_Identifier
     * @return \StructType\ASN_Item_Serial__Data_OutboundType
     */
    public function setSerial_Identifier($serial_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($serial_Identifier) && !is_string($serial_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_Identifier, true), gettype($serial_Identifier)), __LINE__);
        }
        $this->Serial_Identifier = $serial_Identifier;
        return $this;
    }
}
