<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_Code_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing criteria used to retrieve Commodity Codes. Please note that this is mutually exclusive with the Request References element.
 * @subpackage Structs
 */
class Commodity_Code_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Parent_Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Commodity Codes. When these are specified on the inbound request, Workday will retrieve all subordinates associated with the specified Commodity Codes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType[]
     */
    public $Parent_Commodity_Code_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Spend Categories. When these are included on the inbound request, Workday will retrieve all Commodity Codes associated with the specified Spend Categories.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * Constructor method for Commodity_Code_Request_CriteriaType
     * @uses Commodity_Code_Request_CriteriaType::setParent_Commodity_Code_Reference()
     * @uses Commodity_Code_Request_CriteriaType::setSpend_Category_Reference()
     * @param \StructType\Commodity_CodeObjectType[] $parent_Commodity_Code_Reference
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     */
    public function __construct(array $parent_Commodity_Code_Reference = array(), array $spend_Category_Reference = array())
    {
        $this
            ->setParent_Commodity_Code_Reference($parent_Commodity_Code_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference);
    }
    /**
     * Get Parent_Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType[]|null
     */
    public function getParent_Commodity_Code_Reference()
    {
        return $this->Parent_Commodity_Code_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setParent_Commodity_Code_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParent_Commodity_Code_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParent_Commodity_Code_ReferenceForArrayConstraintsFromSetParent_Commodity_Code_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_Code_Request_CriteriaTypeParent_Commodity_Code_ReferenceItem) {
            // validation for constraint: itemType
            if (!$commodity_Code_Request_CriteriaTypeParent_Commodity_Code_ReferenceItem instanceof \StructType\Commodity_CodeObjectType) {
                $invalidValues[] = is_object($commodity_Code_Request_CriteriaTypeParent_Commodity_Code_ReferenceItem) ? get_class($commodity_Code_Request_CriteriaTypeParent_Commodity_Code_ReferenceItem) : sprintf('%s(%s)', gettype($commodity_Code_Request_CriteriaTypeParent_Commodity_Code_ReferenceItem), var_export($commodity_Code_Request_CriteriaTypeParent_Commodity_Code_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parent_Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parent_Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType[] $parent_Commodity_Code_Reference
     * @return \StructType\Commodity_Code_Request_CriteriaType
     */
    public function setParent_Commodity_Code_Reference(array $parent_Commodity_Code_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($parent_Commodity_Code_ReferenceArrayErrorMessage = self::validateParent_Commodity_Code_ReferenceForArrayConstraintsFromSetParent_Commodity_Code_Reference($parent_Commodity_Code_Reference))) {
            throw new \InvalidArgumentException($parent_Commodity_Code_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Parent_Commodity_Code_Reference = $parent_Commodity_Code_Reference;
        return $this;
    }
    /**
     * Add item to Parent_Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType $item
     * @return \StructType\Commodity_Code_Request_CriteriaType
     */
    public function addToParent_Commodity_Code_Reference(\StructType\Commodity_CodeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_CodeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Parent_Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parent_Commodity_Code_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_Code_Request_CriteriaTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$commodity_Code_Request_CriteriaTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($commodity_Code_Request_CriteriaTypeSpend_Category_ReferenceItem) ? get_class($commodity_Code_Request_CriteriaTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($commodity_Code_Request_CriteriaTypeSpend_Category_ReferenceItem), var_export($commodity_Code_Request_CriteriaTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Commodity_Code_Request_CriteriaType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Commodity_Code_Request_CriteriaType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
}
