<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_Code_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Commodity Code Data Element
 * @subpackage Structs
 */
class Commodity_Code_DataType extends AbstractStructBase
{
    /**
     * The Commodity_Code_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Commodity Code Type. If there is a single Commodity Code Type in the tenant, Workday will default it for you. If there are multiple Commodity Code Types in the tenant, you must identify a Commodity Code Type
     * to create or edit a Commodity Code. Please note that when editing an existing Commodity Code by using its Reference ID, Commodity Code Type is optional.
     * - minOccurs: 0
     * @var \StructType\Commodity_Code_TypeObjectType
     */
    public $Commodity_Code_Type_Reference;
    /**
     * The Commodity_Code
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code. This has to be unique within a Commodity Code Type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Commodity_Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description or Commodity Code Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Short_Description
     * Meta information extracted from the WSDL
     * - documentation: Abbreviated version of the Commodity Name. This is optional and will be defaulted from the Description, if not provided on the payload.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Short_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing active Spend Category that is linked to Commodity Code. If specified on the inbound request, Workday will replace Spend Categories that are linked to the Commodity Code. If this is missing on the inbound
     * request, Workday will retain the prior persisted Spend Categories on the Commodity Code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether a Commodity Code is inactive or not. Please note that this cannot be set when creating a new Commodity Code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Parent_Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Parent Commodity Code. Workday will not remove the parent Commodity Code reference if this is missing on the inbound request.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Parent_Commodity_Code_Reference;
    /**
     * Constructor method for Commodity_Code_DataType
     * @uses Commodity_Code_DataType::setCommodity_Code_Type_Reference()
     * @uses Commodity_Code_DataType::setCommodity_Code()
     * @uses Commodity_Code_DataType::setDescription()
     * @uses Commodity_Code_DataType::setShort_Description()
     * @uses Commodity_Code_DataType::setSpend_Category_Reference()
     * @uses Commodity_Code_DataType::setInactive()
     * @uses Commodity_Code_DataType::setParent_Commodity_Code_Reference()
     * @param \StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference
     * @param string $commodity_Code
     * @param string $description
     * @param string $short_Description
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @param bool $inactive
     * @param \StructType\Commodity_CodeObjectType $parent_Commodity_Code_Reference
     */
    public function __construct(\StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference = null, $commodity_Code = null, $description = null, $short_Description = null, array $spend_Category_Reference = array(), $inactive = null, \StructType\Commodity_CodeObjectType $parent_Commodity_Code_Reference = null)
    {
        $this
            ->setCommodity_Code_Type_Reference($commodity_Code_Type_Reference)
            ->setCommodity_Code($commodity_Code)
            ->setDescription($description)
            ->setShort_Description($short_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setInactive($inactive)
            ->setParent_Commodity_Code_Reference($parent_Commodity_Code_Reference);
    }
    /**
     * Get Commodity_Code_Type_Reference value
     * @return \StructType\Commodity_Code_TypeObjectType|null
     */
    public function getCommodity_Code_Type_Reference()
    {
        return $this->Commodity_Code_Type_Reference;
    }
    /**
     * Set Commodity_Code_Type_Reference value
     * @param \StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference
     * @return \StructType\Commodity_Code_DataType
     */
    public function setCommodity_Code_Type_Reference(\StructType\Commodity_Code_TypeObjectType $commodity_Code_Type_Reference = null)
    {
        $this->Commodity_Code_Type_Reference = $commodity_Code_Type_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code value
     * @return string|null
     */
    public function getCommodity_Code()
    {
        return $this->Commodity_Code;
    }
    /**
     * Set Commodity_Code value
     * @param string $commodity_Code
     * @return \StructType\Commodity_Code_DataType
     */
    public function setCommodity_Code($commodity_Code = null)
    {
        // validation for constraint: string
        if (!is_null($commodity_Code) && !is_string($commodity_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodity_Code, true), gettype($commodity_Code)), __LINE__);
        }
        $this->Commodity_Code = $commodity_Code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Commodity_Code_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Short_Description value
     * @return string|null
     */
    public function getShort_Description()
    {
        return $this->Short_Description;
    }
    /**
     * Set Short_Description value
     * @param string $short_Description
     * @return \StructType\Commodity_Code_DataType
     */
    public function setShort_Description($short_Description = null)
    {
        // validation for constraint: string
        if (!is_null($short_Description) && !is_string($short_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($short_Description, true), gettype($short_Description)), __LINE__);
        }
        $this->Short_Description = $short_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_Code_DataTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$commodity_Code_DataTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($commodity_Code_DataTypeSpend_Category_ReferenceItem) ? get_class($commodity_Code_DataTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($commodity_Code_DataTypeSpend_Category_ReferenceItem), var_export($commodity_Code_DataTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Commodity_Code_DataType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Commodity_Code_DataType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Commodity_Code_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Parent_Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getParent_Commodity_Code_Reference()
    {
        return $this->Parent_Commodity_Code_Reference;
    }
    /**
     * Set Parent_Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $parent_Commodity_Code_Reference
     * @return \StructType\Commodity_Code_DataType
     */
    public function setParent_Commodity_Code_Reference(\StructType\Commodity_CodeObjectType $parent_Commodity_Code_Reference = null)
    {
        $this->Parent_Commodity_Code_Reference = $parent_Commodity_Code_Reference;
        return $this;
    }
}
