<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cash_Advance_Repayment_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Cash Advance Repayment response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Cash_Advance_Repayment_Response_DataType extends AbstractStructBase
{
    /**
     * The Cash_Advance_Repayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Cash_Advance_RepaymentType[]
     */
    public $Cash_Advance_Repayment;
    /**
     * Constructor method for Cash_Advance_Repayment_Response_DataType
     * @uses Cash_Advance_Repayment_Response_DataType::setCash_Advance_Repayment()
     * @param \StructType\Cash_Advance_RepaymentType[] $cash_Advance_Repayment
     */
    public function __construct(array $cash_Advance_Repayment = array())
    {
        $this
            ->setCash_Advance_Repayment($cash_Advance_Repayment);
    }
    /**
     * Get Cash_Advance_Repayment value
     * @return \StructType\Cash_Advance_RepaymentType[]|null
     */
    public function getCash_Advance_Repayment()
    {
        return $this->Cash_Advance_Repayment;
    }
    /**
     * This method is responsible for validating the values passed to the setCash_Advance_Repayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCash_Advance_Repayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCash_Advance_RepaymentForArrayConstraintsFromSetCash_Advance_Repayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cash_Advance_Repayment_Response_DataTypeCash_Advance_RepaymentItem) {
            // validation for constraint: itemType
            if (!$cash_Advance_Repayment_Response_DataTypeCash_Advance_RepaymentItem instanceof \StructType\Cash_Advance_RepaymentType) {
                $invalidValues[] = is_object($cash_Advance_Repayment_Response_DataTypeCash_Advance_RepaymentItem) ? get_class($cash_Advance_Repayment_Response_DataTypeCash_Advance_RepaymentItem) : sprintf('%s(%s)', gettype($cash_Advance_Repayment_Response_DataTypeCash_Advance_RepaymentItem), var_export($cash_Advance_Repayment_Response_DataTypeCash_Advance_RepaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cash_Advance_Repayment property can only contain items of type \StructType\Cash_Advance_RepaymentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cash_Advance_Repayment value
     * @throws \InvalidArgumentException
     * @param \StructType\Cash_Advance_RepaymentType[] $cash_Advance_Repayment
     * @return \StructType\Cash_Advance_Repayment_Response_DataType
     */
    public function setCash_Advance_Repayment(array $cash_Advance_Repayment = array())
    {
        // validation for constraint: array
        if ('' !== ($cash_Advance_RepaymentArrayErrorMessage = self::validateCash_Advance_RepaymentForArrayConstraintsFromSetCash_Advance_Repayment($cash_Advance_Repayment))) {
            throw new \InvalidArgumentException($cash_Advance_RepaymentArrayErrorMessage, __LINE__);
        }
        $this->Cash_Advance_Repayment = $cash_Advance_Repayment;
        return $this;
    }
    /**
     * Add item to Cash_Advance_Repayment value
     * @throws \InvalidArgumentException
     * @param \StructType\Cash_Advance_RepaymentType $item
     * @return \StructType\Cash_Advance_Repayment_Response_DataType
     */
    public function addToCash_Advance_Repayment(\StructType\Cash_Advance_RepaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cash_Advance_RepaymentType) {
            throw new \InvalidArgumentException(sprintf('The Cash_Advance_Repayment property can only contain items of type \StructType\Cash_Advance_RepaymentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cash_Advance_Repayment[] = $item;
        return $this;
    }
}
