<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_AdjustmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Invoice Adjustment Instance and Data
 * @subpackage Structs
 */
class Supplier_Invoice_AdjustmentType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Adjustment
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_AdjustmentObjectType
     */
    public $Supplier_Invoice_Adjustment_Reference;
    /**
     * The Supplier_Invoice_Adjustment_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Adjustment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Adjustment_DataType[]
     */
    public $Supplier_Invoice_Adjustment_Data;
    /**
     * Constructor method for Supplier_Invoice_AdjustmentType
     * @uses Supplier_Invoice_AdjustmentType::setSupplier_Invoice_Adjustment_Reference()
     * @uses Supplier_Invoice_AdjustmentType::setSupplier_Invoice_Adjustment_Data()
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference
     * @param \StructType\Supplier_Invoice_Adjustment_DataType[] $supplier_Invoice_Adjustment_Data
     */
    public function __construct(\StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference = null, array $supplier_Invoice_Adjustment_Data = array())
    {
        $this
            ->setSupplier_Invoice_Adjustment_Reference($supplier_Invoice_Adjustment_Reference)
            ->setSupplier_Invoice_Adjustment_Data($supplier_Invoice_Adjustment_Data);
    }
    /**
     * Get Supplier_Invoice_Adjustment_Reference value
     * @return \StructType\Supplier_Invoice_AdjustmentObjectType|null
     */
    public function getSupplier_Invoice_Adjustment_Reference()
    {
        return $this->Supplier_Invoice_Adjustment_Reference;
    }
    /**
     * Set Supplier_Invoice_Adjustment_Reference value
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference
     * @return \StructType\Supplier_Invoice_AdjustmentType
     */
    public function setSupplier_Invoice_Adjustment_Reference(\StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference = null)
    {
        $this->Supplier_Invoice_Adjustment_Reference = $supplier_Invoice_Adjustment_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Adjustment_Data value
     * @return \StructType\Supplier_Invoice_Adjustment_DataType[]|null
     */
    public function getSupplier_Invoice_Adjustment_Data()
    {
        return $this->Supplier_Invoice_Adjustment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Adjustment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Adjustment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Adjustment_DataForArrayConstraintsFromSetSupplier_Invoice_Adjustment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_AdjustmentTypeSupplier_Invoice_Adjustment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_AdjustmentTypeSupplier_Invoice_Adjustment_DataItem instanceof \StructType\Supplier_Invoice_Adjustment_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_AdjustmentTypeSupplier_Invoice_Adjustment_DataItem) ? get_class($supplier_Invoice_AdjustmentTypeSupplier_Invoice_Adjustment_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_AdjustmentTypeSupplier_Invoice_Adjustment_DataItem), var_export($supplier_Invoice_AdjustmentTypeSupplier_Invoice_Adjustment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Adjustment_Data property can only contain items of type \StructType\Supplier_Invoice_Adjustment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Adjustment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Adjustment_DataType[] $supplier_Invoice_Adjustment_Data
     * @return \StructType\Supplier_Invoice_AdjustmentType
     */
    public function setSupplier_Invoice_Adjustment_Data(array $supplier_Invoice_Adjustment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Adjustment_DataArrayErrorMessage = self::validateSupplier_Invoice_Adjustment_DataForArrayConstraintsFromSetSupplier_Invoice_Adjustment_Data($supplier_Invoice_Adjustment_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Adjustment_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Adjustment_Data = $supplier_Invoice_Adjustment_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Adjustment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Adjustment_DataType $item
     * @return \StructType\Supplier_Invoice_AdjustmentType
     */
    public function addToSupplier_Invoice_Adjustment_Data(\StructType\Supplier_Invoice_Adjustment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Adjustment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Adjustment_Data property can only contain items of type \StructType\Supplier_Invoice_Adjustment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Adjustment_Data[] = $item;
        return $this;
    }
}
