<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Field_Replacement_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all supplier classification field data
 * @subpackage Structs
 */
class Supplier_Classification_Field_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing supplier classification field for update only purposes
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_Classification_FieldObjectType
     */
    public $Supplier_Classification_Field_Reference;
    /**
     * The Supplier_Classification_Field_ID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier for the Supplier Classification Field.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Classification_Field_ID;
    /**
     * The Field_Title
     * Meta information extracted from the WSDL
     * - documentation: The name of the supplier classification field
     * - maxOccurs: 1
     * @var string
     */
    public $Field_Title;
    /**
     * The Field_Required
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier classification field is required
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Field_Required;
    /**
     * The Supplier_Classification_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the field type
     * @var \StructType\Supplier_Classification_TypeObjectType
     */
    public $Supplier_Classification_Type_Reference;
    /**
     * The Field_External_Site
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier classification field is to be used in the supplier external site.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Field_External_Site;
    /**
     * The Supplier_Classification_Field_Choice_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification Field Choice Replacement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Classification_Field_Choice_Replacement_DataType[]
     */
    public $Supplier_Classification_Field_Choice_Replacement_Data;
    /**
     * Constructor method for Supplier_Classification_Field_Replacement_DataType
     * @uses Supplier_Classification_Field_Replacement_DataType::setSupplier_Classification_Field_Reference()
     * @uses Supplier_Classification_Field_Replacement_DataType::setSupplier_Classification_Field_ID()
     * @uses Supplier_Classification_Field_Replacement_DataType::setField_Title()
     * @uses Supplier_Classification_Field_Replacement_DataType::setField_Required()
     * @uses Supplier_Classification_Field_Replacement_DataType::setSupplier_Classification_Type_Reference()
     * @uses Supplier_Classification_Field_Replacement_DataType::setField_External_Site()
     * @uses Supplier_Classification_Field_Replacement_DataType::setSupplier_Classification_Field_Choice_Replacement_Data()
     * @param \StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference
     * @param string $supplier_Classification_Field_ID
     * @param string $field_Title
     * @param bool $field_Required
     * @param \StructType\Supplier_Classification_TypeObjectType $supplier_Classification_Type_Reference
     * @param bool $field_External_Site
     * @param \StructType\Supplier_Classification_Field_Choice_Replacement_DataType[] $supplier_Classification_Field_Choice_Replacement_Data
     */
    public function __construct(\StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference = null, $supplier_Classification_Field_ID = null, $field_Title = null, $field_Required = null, \StructType\Supplier_Classification_TypeObjectType $supplier_Classification_Type_Reference = null, $field_External_Site = null, array $supplier_Classification_Field_Choice_Replacement_Data = array())
    {
        $this
            ->setSupplier_Classification_Field_Reference($supplier_Classification_Field_Reference)
            ->setSupplier_Classification_Field_ID($supplier_Classification_Field_ID)
            ->setField_Title($field_Title)
            ->setField_Required($field_Required)
            ->setSupplier_Classification_Type_Reference($supplier_Classification_Type_Reference)
            ->setField_External_Site($field_External_Site)
            ->setSupplier_Classification_Field_Choice_Replacement_Data($supplier_Classification_Field_Choice_Replacement_Data);
    }
    /**
     * Get Supplier_Classification_Field_Reference value
     * @return \StructType\Custom_Supplier_Classification_FieldObjectType|null
     */
    public function getSupplier_Classification_Field_Reference()
    {
        return $this->Supplier_Classification_Field_Reference;
    }
    /**
     * Set Supplier_Classification_Field_Reference value
     * @param \StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setSupplier_Classification_Field_Reference(\StructType\Custom_Supplier_Classification_FieldObjectType $supplier_Classification_Field_Reference = null)
    {
        $this->Supplier_Classification_Field_Reference = $supplier_Classification_Field_Reference;
        return $this;
    }
    /**
     * Get Supplier_Classification_Field_ID value
     * @return string|null
     */
    public function getSupplier_Classification_Field_ID()
    {
        return $this->Supplier_Classification_Field_ID;
    }
    /**
     * Set Supplier_Classification_Field_ID value
     * @param string $supplier_Classification_Field_ID
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setSupplier_Classification_Field_ID($supplier_Classification_Field_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Classification_Field_ID) && !is_string($supplier_Classification_Field_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Classification_Field_ID, true), gettype($supplier_Classification_Field_ID)), __LINE__);
        }
        $this->Supplier_Classification_Field_ID = $supplier_Classification_Field_ID;
        return $this;
    }
    /**
     * Get Field_Title value
     * @return string|null
     */
    public function getField_Title()
    {
        return $this->Field_Title;
    }
    /**
     * Set Field_Title value
     * @param string $field_Title
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setField_Title($field_Title = null)
    {
        // validation for constraint: string
        if (!is_null($field_Title) && !is_string($field_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field_Title, true), gettype($field_Title)), __LINE__);
        }
        $this->Field_Title = $field_Title;
        return $this;
    }
    /**
     * Get Field_Required value
     * @return bool|null
     */
    public function getField_Required()
    {
        return $this->Field_Required;
    }
    /**
     * Set Field_Required value
     * @param bool $field_Required
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setField_Required($field_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($field_Required) && !is_bool($field_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($field_Required, true), gettype($field_Required)), __LINE__);
        }
        $this->Field_Required = $field_Required;
        return $this;
    }
    /**
     * Get Supplier_Classification_Type_Reference value
     * @return \StructType\Supplier_Classification_TypeObjectType|null
     */
    public function getSupplier_Classification_Type_Reference()
    {
        return $this->Supplier_Classification_Type_Reference;
    }
    /**
     * Set Supplier_Classification_Type_Reference value
     * @param \StructType\Supplier_Classification_TypeObjectType $supplier_Classification_Type_Reference
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setSupplier_Classification_Type_Reference(\StructType\Supplier_Classification_TypeObjectType $supplier_Classification_Type_Reference = null)
    {
        $this->Supplier_Classification_Type_Reference = $supplier_Classification_Type_Reference;
        return $this;
    }
    /**
     * Get Field_External_Site value
     * @return bool|null
     */
    public function getField_External_Site()
    {
        return $this->Field_External_Site;
    }
    /**
     * Set Field_External_Site value
     * @param bool $field_External_Site
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setField_External_Site($field_External_Site = null)
    {
        // validation for constraint: boolean
        if (!is_null($field_External_Site) && !is_bool($field_External_Site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($field_External_Site, true), gettype($field_External_Site)), __LINE__);
        }
        $this->Field_External_Site = $field_External_Site;
        return $this;
    }
    /**
     * Get Supplier_Classification_Field_Choice_Replacement_Data value
     * @return \StructType\Supplier_Classification_Field_Choice_Replacement_DataType[]|null
     */
    public function getSupplier_Classification_Field_Choice_Replacement_Data()
    {
        return $this->Supplier_Classification_Field_Choice_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification_Field_Choice_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification_Field_Choice_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Classification_Field_Choice_Replacement_DataForArrayConstraintsFromSetSupplier_Classification_Field_Choice_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Field_Replacement_DataTypeSupplier_Classification_Field_Choice_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Field_Replacement_DataTypeSupplier_Classification_Field_Choice_Replacement_DataItem instanceof \StructType\Supplier_Classification_Field_Choice_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Classification_Field_Replacement_DataTypeSupplier_Classification_Field_Choice_Replacement_DataItem) ? get_class($supplier_Classification_Field_Replacement_DataTypeSupplier_Classification_Field_Choice_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Classification_Field_Replacement_DataTypeSupplier_Classification_Field_Choice_Replacement_DataItem), var_export($supplier_Classification_Field_Replacement_DataTypeSupplier_Classification_Field_Choice_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification_Field_Choice_Replacement_Data property can only contain items of type \StructType\Supplier_Classification_Field_Choice_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification_Field_Choice_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Field_Choice_Replacement_DataType[] $supplier_Classification_Field_Choice_Replacement_Data
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function setSupplier_Classification_Field_Choice_Replacement_Data(array $supplier_Classification_Field_Choice_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Classification_Field_Choice_Replacement_DataArrayErrorMessage = self::validateSupplier_Classification_Field_Choice_Replacement_DataForArrayConstraintsFromSetSupplier_Classification_Field_Choice_Replacement_Data($supplier_Classification_Field_Choice_Replacement_Data))) {
            throw new \InvalidArgumentException($supplier_Classification_Field_Choice_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification_Field_Choice_Replacement_Data = $supplier_Classification_Field_Choice_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Classification_Field_Choice_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Field_Choice_Replacement_DataType $item
     * @return \StructType\Supplier_Classification_Field_Replacement_DataType
     */
    public function addToSupplier_Classification_Field_Choice_Replacement_Data(\StructType\Supplier_Classification_Field_Choice_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Classification_Field_Choice_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification_Field_Choice_Replacement_Data property can only contain items of type \StructType\Supplier_Classification_Field_Choice_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification_Field_Choice_Replacement_Data[] = $item;
        return $this;
    }
}
