<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_NoticeObjectType StructType
 * @subpackage Structs
 */
class Advanced_Ship_NoticeObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_NoticeObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta information extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Advanced_Ship_NoticeObjectType
     * @uses Advanced_Ship_NoticeObjectType::setID()
     * @uses Advanced_Ship_NoticeObjectType::setDescriptor()
     * @param \StructType\Advanced_Ship_NoticeObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Advanced_Ship_NoticeObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_NoticeObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_NoticeObjectTypeIDItem instanceof \StructType\Advanced_Ship_NoticeObjectIDType) {
                $invalidValues[] = is_object($advanced_Ship_NoticeObjectTypeIDItem) ? get_class($advanced_Ship_NoticeObjectTypeIDItem) : sprintf('%s(%s)', gettype($advanced_Ship_NoticeObjectTypeIDItem), var_export($advanced_Ship_NoticeObjectTypeIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type \StructType\Advanced_Ship_NoticeObjectIDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_NoticeObjectIDType[] $iD
     * @return \StructType\Advanced_Ship_NoticeObjectType
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_NoticeObjectIDType $item
     * @return \StructType\Advanced_Ship_NoticeObjectType
     */
    public function addToID(\StructType\Advanced_Ship_NoticeObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Advanced_Ship_NoticeObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type \StructType\Advanced_Ship_NoticeObjectIDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Advanced_Ship_NoticeObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptor, true), gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
}
