<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Spend Category data
 * @subpackage Structs
 */
class Spend_Category_DataType extends AbstractStructBase
{
    /**
     * The Resource_Category_ID
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Reference ID. This is the Spend Category unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Category_ID;
    /**
     * The Resource_Category_Name
     * Meta information extracted from the WSDL
     * - documentation: The Spend Category Name entered has already been used. | Free form text field for a meaningful Spend Category Name
     * - maxOccurs: 1
     * @var string
     */
    public $Resource_Category_Name;
    /**
     * The Spend_Category_Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category has a relationship to Spend Category Usage. The Spend Category usage can be Procurement, Expense or Ad Hoc Payment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Spend_Category_Usage_Reference;
    /**
     * The Procurement_Usage
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that if checked will allow business assets with this spend category to be requested in the procurement process
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Procurement_Usage;
    /**
     * The Expense_Usage
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that if checked will allow business assets with this spend category to be included in an expense report.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Expense_Usage;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax applicability.If this is blank and there invoice line has a sales item, Workday will default tax applicability from the sales item. If the invoice line has a tax code then tax applicability
     * is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Allocate_Freight
     * Meta information extracted from the WSDL
     * - documentation: Allocate Freight will allocate the Freight Charges to the lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allocate_Freight;
    /**
     * The Allocate_Other_Charges
     * Meta information extracted from the WSDL
     * - documentation: Allocate Other Charges will add Supplier Invoice Other Charges to the lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allocate_Other_Charges;
    /**
     * The Track_Items
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that if checked will enable custodial tracking of business assets with this spend category
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Track_Items;
    /**
     * The Stock_Items
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that if checked will enable Inventory tracking of purchase item with this spend category
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Stock_Items;
    /**
     * The Inventory_Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Assigns Inventory Accounting Treatment for the Spend Category with Stock Items Option checked.
     * - minOccurs: 0
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Inventory_Accounting_Treatment_Reference;
    /**
     * The Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Alternate Identifier Types used for this Spend Category.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Identifier_TypeObjectType[]
     */
    public $Item_Identifier_Type_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category should now be populated with a default of Expense (EXPENSE) in this web service. Business Asset Accounting Rules have replaced asset accounting functionality. This field is ignored in Workday 15 and beyond.
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Depreciation_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Asset accounting functionality has been replaced by Business Asset Accounting Rules. This field is ignored in Workday 15 and beyond.
     * - minOccurs: 0
     * @var \StructType\Depreciation_ProfileObjectType
     */
    public $Depreciation_Profile_Reference;
    /**
     * The UNSPSC_Code_Range
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code Range data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UNSPSC_Code_RangeType[]
     */
    public $UNSPSC_Code_Range;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configured in Maintain Asset Type by users, Asset Type allows for applying an additional layer for describing assets and also helpful for reporting trackable, depreciating assets. Field is not required.
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configured in Maintain Asset Class by users, Asset Class allows for applying an addtional reporting criteria. Very useful if you are reporting to tax authorities for trackable, depreciating assets. Field is not required.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Intangible_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Intangible flag. Intangible field cannot be updated if Spend Category is not Trackable and Spend Category is in Use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Intangible_Reference;
    /**
     * The Lease
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that if checked will enable lease tracking.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Lease;
    /**
     * The Commodity_Detail
     * Meta information extracted from the WSDL
     * - documentation: The commodity detail for the spend category. This field can be used as an alternative display name or code value to search for a spend category or spend category hierarchy in Workday.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Commodity_Detail;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description that is used in conjunction with the Commodity Code field.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Spend_Category_Display_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Determines how the Spend Category label is displayed.
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType
     */
    public $Spend_Category_Display_Option_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: True if the Spend Category is Inactive. False otherwise.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Requisition_Fulfillment_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition Fulfillment Source for the Spend Category
     * - minOccurs: 0
     * @var \StructType\Requisition_SourceObjectType
     */
    public $Requisition_Fulfillment_Source_Reference;
    /**
     * The Related_Worktags_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Related_Worktag_Widget_DataType
     */
    public $Related_Worktags_Data;
    /**
     * The Maps_to_Revenue_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Revenue Category being mapped.
     * - minOccurs: 0
     * @var \StructType\Revenue_CategoryObjectType
     */
    public $Maps_to_Revenue_Category_Reference;
    /**
     * Constructor method for Spend_Category_DataType
     * @uses Spend_Category_DataType::setResource_Category_ID()
     * @uses Spend_Category_DataType::setResource_Category_Name()
     * @uses Spend_Category_DataType::setSpend_Category_Usage_Reference()
     * @uses Spend_Category_DataType::setProcurement_Usage()
     * @uses Spend_Category_DataType::setExpense_Usage()
     * @uses Spend_Category_DataType::setTax_Applicability_Reference()
     * @uses Spend_Category_DataType::setAllocate_Freight()
     * @uses Spend_Category_DataType::setAllocate_Other_Charges()
     * @uses Spend_Category_DataType::setTrack_Items()
     * @uses Spend_Category_DataType::setStock_Items()
     * @uses Spend_Category_DataType::setInventory_Accounting_Treatment_Reference()
     * @uses Spend_Category_DataType::setItem_Identifier_Type_Reference()
     * @uses Spend_Category_DataType::setAccounting_Treatment_Reference()
     * @uses Spend_Category_DataType::setDepreciation_Profile_Reference()
     * @uses Spend_Category_DataType::setUNSPSC_Code_Range()
     * @uses Spend_Category_DataType::setAsset_Type_Reference()
     * @uses Spend_Category_DataType::setAsset_Class_Reference()
     * @uses Spend_Category_DataType::setIntangible_Reference()
     * @uses Spend_Category_DataType::setLease()
     * @uses Spend_Category_DataType::setCommodity_Detail()
     * @uses Spend_Category_DataType::setDescription()
     * @uses Spend_Category_DataType::setSpend_Category_Display_Option_Reference()
     * @uses Spend_Category_DataType::setInactive()
     * @uses Spend_Category_DataType::setRequisition_Fulfillment_Source_Reference()
     * @uses Spend_Category_DataType::setRelated_Worktags_Data()
     * @uses Spend_Category_DataType::setMaps_to_Revenue_Category_Reference()
     * @param string $resource_Category_ID
     * @param string $resource_Category_Name
     * @param \StructType\Unique_IdentifierObjectType[] $spend_Category_Usage_Reference
     * @param bool $procurement_Usage
     * @param bool $expense_Usage
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param bool $allocate_Freight
     * @param bool $allocate_Other_Charges
     * @param bool $track_Items
     * @param bool $stock_Items
     * @param \StructType\Accounting_TreatmentObjectType $inventory_Accounting_Treatment_Reference
     * @param \StructType\Item_Identifier_TypeObjectType[] $item_Identifier_Type_Reference
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @param \StructType\UNSPSC_Code_RangeType[] $uNSPSC_Code_Range
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param bool $intangible_Reference
     * @param bool $lease
     * @param string $commodity_Detail
     * @param string $description
     * @param \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Display_Option_Reference
     * @param bool $inactive
     * @param \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference
     * @param \StructType\Related_Worktag_Widget_DataType $related_Worktags_Data
     * @param \StructType\Revenue_CategoryObjectType $maps_to_Revenue_Category_Reference
     */
    public function __construct($resource_Category_ID = null, $resource_Category_Name = null, array $spend_Category_Usage_Reference = array(), $procurement_Usage = null, $expense_Usage = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, $allocate_Freight = null, $allocate_Other_Charges = null, $track_Items = null, $stock_Items = null, \StructType\Accounting_TreatmentObjectType $inventory_Accounting_Treatment_Reference = null, array $item_Identifier_Type_Reference = array(), \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null, array $uNSPSC_Code_Range = array(), \StructType\Asset_TypeObjectType $asset_Type_Reference = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, $intangible_Reference = null, $lease = null, $commodity_Detail = null, $description = null, \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Display_Option_Reference = null, $inactive = null, \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference = null, \StructType\Related_Worktag_Widget_DataType $related_Worktags_Data = null, \StructType\Revenue_CategoryObjectType $maps_to_Revenue_Category_Reference = null)
    {
        $this
            ->setResource_Category_ID($resource_Category_ID)
            ->setResource_Category_Name($resource_Category_Name)
            ->setSpend_Category_Usage_Reference($spend_Category_Usage_Reference)
            ->setProcurement_Usage($procurement_Usage)
            ->setExpense_Usage($expense_Usage)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setAllocate_Freight($allocate_Freight)
            ->setAllocate_Other_Charges($allocate_Other_Charges)
            ->setTrack_Items($track_Items)
            ->setStock_Items($stock_Items)
            ->setInventory_Accounting_Treatment_Reference($inventory_Accounting_Treatment_Reference)
            ->setItem_Identifier_Type_Reference($item_Identifier_Type_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setDepreciation_Profile_Reference($depreciation_Profile_Reference)
            ->setUNSPSC_Code_Range($uNSPSC_Code_Range)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setIntangible_Reference($intangible_Reference)
            ->setLease($lease)
            ->setCommodity_Detail($commodity_Detail)
            ->setDescription($description)
            ->setSpend_Category_Display_Option_Reference($spend_Category_Display_Option_Reference)
            ->setInactive($inactive)
            ->setRequisition_Fulfillment_Source_Reference($requisition_Fulfillment_Source_Reference)
            ->setRelated_Worktags_Data($related_Worktags_Data)
            ->setMaps_to_Revenue_Category_Reference($maps_to_Revenue_Category_Reference);
    }
    /**
     * Get Resource_Category_ID value
     * @return string|null
     */
    public function getResource_Category_ID()
    {
        return $this->Resource_Category_ID;
    }
    /**
     * Set Resource_Category_ID value
     * @param string $resource_Category_ID
     * @return \StructType\Spend_Category_DataType
     */
    public function setResource_Category_ID($resource_Category_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Category_ID) && !is_string($resource_Category_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Category_ID, true), gettype($resource_Category_ID)), __LINE__);
        }
        $this->Resource_Category_ID = $resource_Category_ID;
        return $this;
    }
    /**
     * Get Resource_Category_Name value
     * @return string|null
     */
    public function getResource_Category_Name()
    {
        return $this->Resource_Category_Name;
    }
    /**
     * Set Resource_Category_Name value
     * @param string $resource_Category_Name
     * @return \StructType\Spend_Category_DataType
     */
    public function setResource_Category_Name($resource_Category_Name = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Category_Name) && !is_string($resource_Category_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Category_Name, true), gettype($resource_Category_Name)), __LINE__);
        }
        $this->Resource_Category_Name = $resource_Category_Name;
        return $this;
    }
    /**
     * Get Spend_Category_Usage_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getSpend_Category_Usage_Reference()
    {
        return $this->Spend_Category_Usage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Usage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Usage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_Usage_ReferenceForArrayConstraintsFromSetSpend_Category_Usage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_DataTypeSpend_Category_Usage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Category_DataTypeSpend_Category_Usage_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($spend_Category_DataTypeSpend_Category_Usage_ReferenceItem) ? get_class($spend_Category_DataTypeSpend_Category_Usage_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Category_DataTypeSpend_Category_Usage_ReferenceItem), var_export($spend_Category_DataTypeSpend_Category_Usage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Usage_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $spend_Category_Usage_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setSpend_Category_Usage_Reference(array $spend_Category_Usage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_Usage_ReferenceArrayErrorMessage = self::validateSpend_Category_Usage_ReferenceForArrayConstraintsFromSetSpend_Category_Usage_Reference($spend_Category_Usage_Reference))) {
            throw new \InvalidArgumentException($spend_Category_Usage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Usage_Reference = $spend_Category_Usage_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Spend_Category_DataType
     */
    public function addToSpend_Category_Usage_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Usage_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Usage_Reference[] = $item;
        return $this;
    }
    /**
     * Get Procurement_Usage value
     * @return bool|null
     */
    public function getProcurement_Usage()
    {
        return $this->Procurement_Usage;
    }
    /**
     * Set Procurement_Usage value
     * @param bool $procurement_Usage
     * @return \StructType\Spend_Category_DataType
     */
    public function setProcurement_Usage($procurement_Usage = null)
    {
        // validation for constraint: boolean
        if (!is_null($procurement_Usage) && !is_bool($procurement_Usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($procurement_Usage, true), gettype($procurement_Usage)), __LINE__);
        }
        $this->Procurement_Usage = $procurement_Usage;
        return $this;
    }
    /**
     * Get Expense_Usage value
     * @return bool|null
     */
    public function getExpense_Usage()
    {
        return $this->Expense_Usage;
    }
    /**
     * Set Expense_Usage value
     * @param bool $expense_Usage
     * @return \StructType\Spend_Category_DataType
     */
    public function setExpense_Usage($expense_Usage = null)
    {
        // validation for constraint: boolean
        if (!is_null($expense_Usage) && !is_bool($expense_Usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expense_Usage, true), gettype($expense_Usage)), __LINE__);
        }
        $this->Expense_Usage = $expense_Usage;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Allocate_Freight value
     * @return bool|null
     */
    public function getAllocate_Freight()
    {
        return $this->Allocate_Freight;
    }
    /**
     * Set Allocate_Freight value
     * @param bool $allocate_Freight
     * @return \StructType\Spend_Category_DataType
     */
    public function setAllocate_Freight($allocate_Freight = null)
    {
        // validation for constraint: boolean
        if (!is_null($allocate_Freight) && !is_bool($allocate_Freight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allocate_Freight, true), gettype($allocate_Freight)), __LINE__);
        }
        $this->Allocate_Freight = $allocate_Freight;
        return $this;
    }
    /**
     * Get Allocate_Other_Charges value
     * @return bool|null
     */
    public function getAllocate_Other_Charges()
    {
        return $this->Allocate_Other_Charges;
    }
    /**
     * Set Allocate_Other_Charges value
     * @param bool $allocate_Other_Charges
     * @return \StructType\Spend_Category_DataType
     */
    public function setAllocate_Other_Charges($allocate_Other_Charges = null)
    {
        // validation for constraint: boolean
        if (!is_null($allocate_Other_Charges) && !is_bool($allocate_Other_Charges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allocate_Other_Charges, true), gettype($allocate_Other_Charges)), __LINE__);
        }
        $this->Allocate_Other_Charges = $allocate_Other_Charges;
        return $this;
    }
    /**
     * Get Track_Items value
     * @return bool|null
     */
    public function getTrack_Items()
    {
        return $this->Track_Items;
    }
    /**
     * Set Track_Items value
     * @param bool $track_Items
     * @return \StructType\Spend_Category_DataType
     */
    public function setTrack_Items($track_Items = null)
    {
        // validation for constraint: boolean
        if (!is_null($track_Items) && !is_bool($track_Items)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($track_Items, true), gettype($track_Items)), __LINE__);
        }
        $this->Track_Items = $track_Items;
        return $this;
    }
    /**
     * Get Stock_Items value
     * @return bool|null
     */
    public function getStock_Items()
    {
        return $this->Stock_Items;
    }
    /**
     * Set Stock_Items value
     * @param bool $stock_Items
     * @return \StructType\Spend_Category_DataType
     */
    public function setStock_Items($stock_Items = null)
    {
        // validation for constraint: boolean
        if (!is_null($stock_Items) && !is_bool($stock_Items)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stock_Items, true), gettype($stock_Items)), __LINE__);
        }
        $this->Stock_Items = $stock_Items;
        return $this;
    }
    /**
     * Get Inventory_Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getInventory_Accounting_Treatment_Reference()
    {
        return $this->Inventory_Accounting_Treatment_Reference;
    }
    /**
     * Set Inventory_Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $inventory_Accounting_Treatment_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setInventory_Accounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $inventory_Accounting_Treatment_Reference = null)
    {
        $this->Inventory_Accounting_Treatment_Reference = $inventory_Accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier_Type_Reference value
     * @return \StructType\Item_Identifier_TypeObjectType[]|null
     */
    public function getItem_Identifier_Type_Reference()
    {
        return $this->Item_Identifier_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Identifier_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Identifier_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Identifier_Type_ReferenceForArrayConstraintsFromSetItem_Identifier_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_DataTypeItem_Identifier_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Category_DataTypeItem_Identifier_Type_ReferenceItem instanceof \StructType\Item_Identifier_TypeObjectType) {
                $invalidValues[] = is_object($spend_Category_DataTypeItem_Identifier_Type_ReferenceItem) ? get_class($spend_Category_DataTypeItem_Identifier_Type_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Category_DataTypeItem_Identifier_Type_ReferenceItem), var_export($spend_Category_DataTypeItem_Identifier_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Identifier_Type_Reference property can only contain items of type \StructType\Item_Identifier_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Identifier_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_TypeObjectType[] $item_Identifier_Type_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setItem_Identifier_Type_Reference(array $item_Identifier_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Identifier_Type_ReferenceArrayErrorMessage = self::validateItem_Identifier_Type_ReferenceForArrayConstraintsFromSetItem_Identifier_Type_Reference($item_Identifier_Type_Reference))) {
            throw new \InvalidArgumentException($item_Identifier_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Identifier_Type_Reference = $item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Add item to Item_Identifier_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_TypeObjectType $item
     * @return \StructType\Spend_Category_DataType
     */
    public function addToItem_Identifier_Type_Reference(\StructType\Item_Identifier_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Identifier_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Identifier_Type_Reference property can only contain items of type \StructType\Item_Identifier_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Identifier_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Profile_Reference value
     * @return \StructType\Depreciation_ProfileObjectType|null
     */
    public function getDepreciation_Profile_Reference()
    {
        return $this->Depreciation_Profile_Reference;
    }
    /**
     * Set Depreciation_Profile_Reference value
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setDepreciation_Profile_Reference(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null)
    {
        $this->Depreciation_Profile_Reference = $depreciation_Profile_Reference;
        return $this;
    }
    /**
     * Get UNSPSC_Code_Range value
     * @return \StructType\UNSPSC_Code_RangeType[]|null
     */
    public function getUNSPSC_Code_Range()
    {
        return $this->UNSPSC_Code_Range;
    }
    /**
     * This method is responsible for validating the values passed to the setUNSPSC_Code_Range method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUNSPSC_Code_Range method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUNSPSC_Code_RangeForArrayConstraintsFromSetUNSPSC_Code_Range(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_DataTypeUNSPSC_Code_RangeItem) {
            // validation for constraint: itemType
            if (!$spend_Category_DataTypeUNSPSC_Code_RangeItem instanceof \StructType\UNSPSC_Code_RangeType) {
                $invalidValues[] = is_object($spend_Category_DataTypeUNSPSC_Code_RangeItem) ? get_class($spend_Category_DataTypeUNSPSC_Code_RangeItem) : sprintf('%s(%s)', gettype($spend_Category_DataTypeUNSPSC_Code_RangeItem), var_export($spend_Category_DataTypeUNSPSC_Code_RangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UNSPSC_Code_Range property can only contain items of type \StructType\UNSPSC_Code_RangeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UNSPSC_Code_Range value
     * @throws \InvalidArgumentException
     * @param \StructType\UNSPSC_Code_RangeType[] $uNSPSC_Code_Range
     * @return \StructType\Spend_Category_DataType
     */
    public function setUNSPSC_Code_Range(array $uNSPSC_Code_Range = array())
    {
        // validation for constraint: array
        if ('' !== ($uNSPSC_Code_RangeArrayErrorMessage = self::validateUNSPSC_Code_RangeForArrayConstraintsFromSetUNSPSC_Code_Range($uNSPSC_Code_Range))) {
            throw new \InvalidArgumentException($uNSPSC_Code_RangeArrayErrorMessage, __LINE__);
        }
        $this->UNSPSC_Code_Range = $uNSPSC_Code_Range;
        return $this;
    }
    /**
     * Add item to UNSPSC_Code_Range value
     * @throws \InvalidArgumentException
     * @param \StructType\UNSPSC_Code_RangeType $item
     * @return \StructType\Spend_Category_DataType
     */
    public function addToUNSPSC_Code_Range(\StructType\UNSPSC_Code_RangeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UNSPSC_Code_RangeType) {
            throw new \InvalidArgumentException(sprintf('The UNSPSC_Code_Range property can only contain items of type \StructType\UNSPSC_Code_RangeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UNSPSC_Code_Range[] = $item;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Intangible_Reference value
     * @return bool|null
     */
    public function getIntangible_Reference()
    {
        return $this->Intangible_Reference;
    }
    /**
     * Set Intangible_Reference value
     * @param bool $intangible_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setIntangible_Reference($intangible_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($intangible_Reference) && !is_bool($intangible_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($intangible_Reference, true), gettype($intangible_Reference)), __LINE__);
        }
        $this->Intangible_Reference = $intangible_Reference;
        return $this;
    }
    /**
     * Get Lease value
     * @return bool|null
     */
    public function getLease()
    {
        return $this->Lease;
    }
    /**
     * Set Lease value
     * @param bool $lease
     * @return \StructType\Spend_Category_DataType
     */
    public function setLease($lease = null)
    {
        // validation for constraint: boolean
        if (!is_null($lease) && !is_bool($lease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lease, true), gettype($lease)), __LINE__);
        }
        $this->Lease = $lease;
        return $this;
    }
    /**
     * Get Commodity_Detail value
     * @return string|null
     */
    public function getCommodity_Detail()
    {
        return $this->Commodity_Detail;
    }
    /**
     * Set Commodity_Detail value
     * @param string $commodity_Detail
     * @return \StructType\Spend_Category_DataType
     */
    public function setCommodity_Detail($commodity_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($commodity_Detail) && !is_string($commodity_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodity_Detail, true), gettype($commodity_Detail)), __LINE__);
        }
        $this->Commodity_Detail = $commodity_Detail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Spend_Category_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Spend_Category_Display_Option_Reference value
     * @return \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType|null
     */
    public function getSpend_Category_Display_Option_Reference()
    {
        return $this->Spend_Category_Display_Option_Reference;
    }
    /**
     * Set Spend_Category_Display_Option_Reference value
     * @param \StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Display_Option_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setSpend_Category_Display_Option_Reference(\StructType\Spend_Category_or_Hierarchy_Display_OptionObjectType $spend_Category_Display_Option_Reference = null)
    {
        $this->Spend_Category_Display_Option_Reference = $spend_Category_Display_Option_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Spend_Category_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Requisition_Fulfillment_Source_Reference value
     * @return \StructType\Requisition_SourceObjectType|null
     */
    public function getRequisition_Fulfillment_Source_Reference()
    {
        return $this->Requisition_Fulfillment_Source_Reference;
    }
    /**
     * Set Requisition_Fulfillment_Source_Reference value
     * @param \StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setRequisition_Fulfillment_Source_Reference(\StructType\Requisition_SourceObjectType $requisition_Fulfillment_Source_Reference = null)
    {
        $this->Requisition_Fulfillment_Source_Reference = $requisition_Fulfillment_Source_Reference;
        return $this;
    }
    /**
     * Get Related_Worktags_Data value
     * @return \StructType\Related_Worktag_Widget_DataType|null
     */
    public function getRelated_Worktags_Data()
    {
        return $this->Related_Worktags_Data;
    }
    /**
     * Set Related_Worktags_Data value
     * @param \StructType\Related_Worktag_Widget_DataType $related_Worktags_Data
     * @return \StructType\Spend_Category_DataType
     */
    public function setRelated_Worktags_Data(\StructType\Related_Worktag_Widget_DataType $related_Worktags_Data = null)
    {
        $this->Related_Worktags_Data = $related_Worktags_Data;
        return $this;
    }
    /**
     * Get Maps_to_Revenue_Category_Reference value
     * @return \StructType\Revenue_CategoryObjectType|null
     */
    public function getMaps_to_Revenue_Category_Reference()
    {
        return $this->Maps_to_Revenue_Category_Reference;
    }
    /**
     * Set Maps_to_Revenue_Category_Reference value
     * @param \StructType\Revenue_CategoryObjectType $maps_to_Revenue_Category_Reference
     * @return \StructType\Spend_Category_DataType
     */
    public function setMaps_to_Revenue_Category_Reference(\StructType\Revenue_CategoryObjectType $maps_to_Revenue_Category_Reference = null)
    {
        $this->Maps_to_Revenue_Category_Reference = $maps_to_Revenue_Category_Reference;
        return $this;
    }
}
