<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Type_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Invoice Type response data for requested references or criteria and for requested response group.
 * @subpackage Structs
 */
class Invoice_Type_Response_DataType extends AbstractStructBase
{
    /**
     * The Invoice_Type
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes Invoice Type instance and data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeType[]
     */
    public $Invoice_Type;
    /**
     * Constructor method for Invoice_Type_Response_DataType
     * @uses Invoice_Type_Response_DataType::setInvoice_Type()
     * @param \StructType\Invoice_TypeType[] $invoice_Type
     */
    public function __construct(array $invoice_Type = array())
    {
        $this
            ->setInvoice_Type($invoice_Type);
    }
    /**
     * Get Invoice_Type value
     * @return \StructType\Invoice_TypeType[]|null
     */
    public function getInvoice_Type()
    {
        return $this->Invoice_Type;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Type method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Type method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_TypeForArrayConstraintsFromSetInvoice_Type(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoice_Type_Response_DataTypeInvoice_TypeItem) {
            // validation for constraint: itemType
            if (!$invoice_Type_Response_DataTypeInvoice_TypeItem instanceof \StructType\Invoice_TypeType) {
                $invalidValues[] = is_object($invoice_Type_Response_DataTypeInvoice_TypeItem) ? get_class($invoice_Type_Response_DataTypeInvoice_TypeItem) : sprintf('%s(%s)', gettype($invoice_Type_Response_DataTypeInvoice_TypeItem), var_export($invoice_Type_Response_DataTypeInvoice_TypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Type property can only contain items of type \StructType\Invoice_TypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Type value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_TypeType[] $invoice_Type
     * @return \StructType\Invoice_Type_Response_DataType
     */
    public function setInvoice_Type(array $invoice_Type = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_TypeArrayErrorMessage = self::validateInvoice_TypeForArrayConstraintsFromSetInvoice_Type($invoice_Type))) {
            throw new \InvalidArgumentException($invoice_TypeArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Type = $invoice_Type;
        return $this;
    }
    /**
     * Add item to Invoice_Type value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_TypeType $item
     * @return \StructType\Invoice_Type_Response_DataType
     */
    public function addToInvoice_Type(\StructType\Invoice_TypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Invoice_TypeType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Type property can only contain items of type \StructType\Invoice_TypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Type[] = $item;
        return $this;
    }
}
