<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge_Control_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Charge Controls for supplier contracts.
 * @subpackage Structs
 */
class Charge_Control_DataType extends AbstractStructBase
{
    /**
     * The Minimum_Charge_Control_Amount
     * Meta information extracted from the WSDL
     * - documentation: Minimum Charge Control Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Minimum_Charge_Control_Amount;
    /**
     * The Maximum_Charge_Control_Amount
     * Meta information extracted from the WSDL
     * - documentation: Maximum Charge Control Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Maximum_Charge_Control_Amount;
    /**
     * Constructor method for Charge_Control_DataType
     * @uses Charge_Control_DataType::setMinimum_Charge_Control_Amount()
     * @uses Charge_Control_DataType::setMaximum_Charge_Control_Amount()
     * @param float $minimum_Charge_Control_Amount
     * @param float $maximum_Charge_Control_Amount
     */
    public function __construct($minimum_Charge_Control_Amount = null, $maximum_Charge_Control_Amount = null)
    {
        $this
            ->setMinimum_Charge_Control_Amount($minimum_Charge_Control_Amount)
            ->setMaximum_Charge_Control_Amount($maximum_Charge_Control_Amount);
    }
    /**
     * Get Minimum_Charge_Control_Amount value
     * @return float|null
     */
    public function getMinimum_Charge_Control_Amount()
    {
        return $this->Minimum_Charge_Control_Amount;
    }
    /**
     * Set Minimum_Charge_Control_Amount value
     * @param float $minimum_Charge_Control_Amount
     * @return \StructType\Charge_Control_DataType
     */
    public function setMinimum_Charge_Control_Amount($minimum_Charge_Control_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Charge_Control_Amount) && !(is_float($minimum_Charge_Control_Amount) || is_numeric($minimum_Charge_Control_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Charge_Control_Amount, true), gettype($minimum_Charge_Control_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($minimum_Charge_Control_Amount) && mb_strlen(mb_substr($minimum_Charge_Control_Amount, false !== mb_strpos($minimum_Charge_Control_Amount, '.') ? mb_strpos($minimum_Charge_Control_Amount, '.') + 1 : mb_strlen($minimum_Charge_Control_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($minimum_Charge_Control_Amount, true), mb_strlen(mb_substr($minimum_Charge_Control_Amount, mb_strpos($minimum_Charge_Control_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($minimum_Charge_Control_Amount) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Charge_Control_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($minimum_Charge_Control_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Charge_Control_Amount))), __LINE__);
        }
        $this->Minimum_Charge_Control_Amount = $minimum_Charge_Control_Amount;
        return $this;
    }
    /**
     * Get Maximum_Charge_Control_Amount value
     * @return float|null
     */
    public function getMaximum_Charge_Control_Amount()
    {
        return $this->Maximum_Charge_Control_Amount;
    }
    /**
     * Set Maximum_Charge_Control_Amount value
     * @param float $maximum_Charge_Control_Amount
     * @return \StructType\Charge_Control_DataType
     */
    public function setMaximum_Charge_Control_Amount($maximum_Charge_Control_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($maximum_Charge_Control_Amount) && !(is_float($maximum_Charge_Control_Amount) || is_numeric($maximum_Charge_Control_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum_Charge_Control_Amount, true), gettype($maximum_Charge_Control_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($maximum_Charge_Control_Amount) && mb_strlen(mb_substr($maximum_Charge_Control_Amount, false !== mb_strpos($maximum_Charge_Control_Amount, '.') ? mb_strpos($maximum_Charge_Control_Amount, '.') + 1 : mb_strlen($maximum_Charge_Control_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($maximum_Charge_Control_Amount, true), mb_strlen(mb_substr($maximum_Charge_Control_Amount, mb_strpos($maximum_Charge_Control_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($maximum_Charge_Control_Amount) && mb_strlen(preg_replace('/(\D)/', '', $maximum_Charge_Control_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($maximum_Charge_Control_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $maximum_Charge_Control_Amount))), __LINE__);
        }
        $this->Maximum_Charge_Control_Amount = $maximum_Charge_Control_Amount;
        return $this;
    }
}
