<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Alternate_Contract_Interest_Rate_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Alternate Contract(s) Reference for Interest Rate Modification
 * @subpackage Structs
 */
class Alternate_Contract_Interest_Rate_DataType extends AbstractStructBase
{
    /**
     * The Alternate_Supplier_Contract_ID
     * Meta information extracted from the WSDL
     * - documentation: Alternate Supplier Lease Contract Reference for Lease Contract Amendment
     * - maxOccurs: 1
     * @var string
     */
    public $Alternate_Supplier_Contract_ID;
    /**
     * The Interest_Rate
     * Meta information extracted from the WSDL
     * - documentation: Alternate Contract Interest Rate for Lease Contract Amendment | Interest Rate (%)
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Interest_Rate;
    /**
     * Constructor method for Alternate_Contract_Interest_Rate_DataType
     * @uses Alternate_Contract_Interest_Rate_DataType::setAlternate_Supplier_Contract_ID()
     * @uses Alternate_Contract_Interest_Rate_DataType::setInterest_Rate()
     * @param string $alternate_Supplier_Contract_ID
     * @param float $interest_Rate
     */
    public function __construct($alternate_Supplier_Contract_ID = null, $interest_Rate = null)
    {
        $this
            ->setAlternate_Supplier_Contract_ID($alternate_Supplier_Contract_ID)
            ->setInterest_Rate($interest_Rate);
    }
    /**
     * Get Alternate_Supplier_Contract_ID value
     * @return string|null
     */
    public function getAlternate_Supplier_Contract_ID()
    {
        return $this->Alternate_Supplier_Contract_ID;
    }
    /**
     * Set Alternate_Supplier_Contract_ID value
     * @param string $alternate_Supplier_Contract_ID
     * @return \StructType\Alternate_Contract_Interest_Rate_DataType
     */
    public function setAlternate_Supplier_Contract_ID($alternate_Supplier_Contract_ID = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Supplier_Contract_ID) && !is_string($alternate_Supplier_Contract_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Supplier_Contract_ID, true), gettype($alternate_Supplier_Contract_ID)), __LINE__);
        }
        $this->Alternate_Supplier_Contract_ID = $alternate_Supplier_Contract_ID;
        return $this;
    }
    /**
     * Get Interest_Rate value
     * @return float|null
     */
    public function getInterest_Rate()
    {
        return $this->Interest_Rate;
    }
    /**
     * Set Interest_Rate value
     * @param float $interest_Rate
     * @return \StructType\Alternate_Contract_Interest_Rate_DataType
     */
    public function setInterest_Rate($interest_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($interest_Rate) && !(is_float($interest_Rate) || is_numeric($interest_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($interest_Rate, true), gettype($interest_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($interest_Rate) && mb_strlen(mb_substr($interest_Rate, false !== mb_strpos($interest_Rate, '.') ? mb_strpos($interest_Rate, '.') + 1 : mb_strlen($interest_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($interest_Rate, true), mb_strlen(mb_substr($interest_Rate, mb_strpos($interest_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($interest_Rate) && $interest_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($interest_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($interest_Rate) && mb_strlen(preg_replace('/(\D)/', '', $interest_Rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($interest_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $interest_Rate))), __LINE__);
        }
        $this->Interest_Rate = $interest_Rate;
        return $this;
    }
}
