<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service_Order_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Submit approved Requisition Line that is not fully sourced and business process events that are not in progress. | The Requisition Line referenced is from a Requisition that is Closed or Pending Close. | Please specify an Item or a
 * Spend Category. | Please specify an Item or an Item Description. | Item is from a Supplier Contract that does not accept Manual Purchase Orders. | Element containing Simple Service Purchase Order Line data. A Purchase Order may have multiple simple
 * service purchase order lines.
 * @subpackage Structs
 */
class Service_Order_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing purchase item. Specifying the purchase item will default values for the Item Description, Spend Category, Tax Applicability, Unit of Measure, and Unit Cost if these options are defined on the purchase item
     * itself.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Service_Order_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Service_Order_Line_ID;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company of the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text description of the purchase item. The description will default from the item if the description is left blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: An optional reference to an existing Supplier Contract Line in the Workday system. This is used to link the Item Order Line with a Supplier Contract Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType
     */
    public $Payment_Status_Reference;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Status_Reference;
    /**
     * The Receiving_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receiving Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Receiving_Status_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend Category for the Purchase Item.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Applicability Reference is required is Tax Code is specified. | Reference to the Tax Applicability for the Purchase Item. If the item has Tax Code defined, then the Tax Applicability is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Code for the Purchase Item. The Tax Code is defaulted from the Purchase Order Data element if one is specified.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Options_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Options_Data;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Due_Date
     * Meta information extracted from the WSDL
     * - documentation: The anticipated date by which the Purchase Order Line should be fulfilled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Prepaid flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Retention
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a purchase order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Purchase Order Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: The address where the line item will be shipped to.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ship-to contact worker associated to the line item.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Requisition_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Requisition Line linked to the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\Requisition_LineObjectType
     */
    public $Requisition_Line_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: This field is only enabled for Companies and Tenants which are Opted-In to Consolidate Requisition Lines by Supplier regardless of Supplier Contract.Use this field to assign a specific Supplier Contract to this Spend Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Storage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing location for the item.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Storage_Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worktags provided are not valid for this transaction | Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for
     * each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Service_Purchase_Order_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Service_Purchase_Order_Line_Split_Data;
    /**
     * The Close_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status of a closed purchase order line. This field is read-only and ignored when you submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Close_Status_Reference;
    /**
     * The Close_Status_Information
     * Meta information extracted from the WSDL
     * - documentation: Additional information on the status of the closed purchase order (PO) line. Includes information such as the date the PO line was closed, who closed the line, and the reason it was closed. This field is read-only and ignored when
     * you submit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Close_Status_InformationType[]
     */
    public $Close_Status_Information;
    /**
     * Constructor method for Service_Order_Line_Replacement_DataType
     * @uses Service_Order_Line_Replacement_DataType::setItem_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setService_Order_Line_ID()
     * @uses Service_Order_Line_Replacement_DataType::setLine_Number()
     * @uses Service_Order_Line_Replacement_DataType::setLine_Company_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setDescription()
     * @uses Service_Order_Line_Replacement_DataType::setSupplier_Contract_Line_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setCommodity_Code_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setPayment_Status_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setInvoice_Status_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setReceiving_Status_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setResource_Category_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setTax_Applicability_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setTax_Code_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setTax_Rate_Options_Data()
     * @uses Service_Order_Line_Replacement_DataType::setExtended_Amount()
     * @uses Service_Order_Line_Replacement_DataType::setDue_Date()
     * @uses Service_Order_Line_Replacement_DataType::setStart_Date()
     * @uses Service_Order_Line_Replacement_DataType::setEnd_Date()
     * @uses Service_Order_Line_Replacement_DataType::setPrepaid()
     * @uses Service_Order_Line_Replacement_DataType::setRetention()
     * @uses Service_Order_Line_Replacement_DataType::setBudget_Date()
     * @uses Service_Order_Line_Replacement_DataType::setMemo()
     * @uses Service_Order_Line_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setShip_To_Contact_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setDeliver_To_Location_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setRequisition_Line_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setSupplier_Contract_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setStorage_Location_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setWorktags_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setService_Purchase_Order_Line_Split_Data()
     * @uses Service_Order_Line_Replacement_DataType::setClose_Status_Reference()
     * @uses Service_Order_Line_Replacement_DataType::setClose_Status_Information()
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $service_Order_Line_ID
     * @param float $line_Number
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param string $description
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @param float $extended_Amount
     * @param string $due_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param bool $prepaid
     * @param bool $retention
     * @param string $budget_Date
     * @param string $memo
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Requisition_LineObjectType $requisition_Line_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $service_Purchase_Order_Line_Split_Data
     * @param \StructType\Document_StatusObjectType $close_Status_Reference
     * @param \StructType\Close_Status_InformationType[] $close_Status_Information
     */
    public function __construct(\StructType\Procurement_ItemObjectType $item_Reference = null, $service_Order_Line_ID = null, $line_Number = null, \StructType\CompanyObjectType $line_Company_Reference = null, $description = null, \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, \StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null, \StructType\Document_StatusObjectType $invoice_Status_Reference = null, \StructType\Document_StatusObjectType $receiving_Status_Reference = null, \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null, $extended_Amount = null, $due_Date = null, $start_Date = null, $end_Date = null, $prepaid = null, $retention = null, $budget_Date = null, $memo = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, \StructType\Requisition_LineObjectType $requisition_Line_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\LocationObjectType $storage_Location_Reference = null, array $worktags_Reference = array(), array $service_Purchase_Order_Line_Split_Data = array(), \StructType\Document_StatusObjectType $close_Status_Reference = null, array $close_Status_Information = array())
    {
        $this
            ->setItem_Reference($item_Reference)
            ->setService_Order_Line_ID($service_Order_Line_ID)
            ->setLine_Number($line_Number)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setDescription($description)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setPayment_Status_Reference($payment_Status_Reference)
            ->setInvoice_Status_Reference($invoice_Status_Reference)
            ->setReceiving_Status_Reference($receiving_Status_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Options_Data($tax_Rate_Options_Data)
            ->setExtended_Amount($extended_Amount)
            ->setDue_Date($due_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setPrepaid($prepaid)
            ->setRetention($retention)
            ->setBudget_Date($budget_Date)
            ->setMemo($memo)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setRequisition_Line_Reference($requisition_Line_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setStorage_Location_Reference($storage_Location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setService_Purchase_Order_Line_Split_Data($service_Purchase_Order_Line_Split_Data)
            ->setClose_Status_Reference($close_Status_Reference)
            ->setClose_Status_Information($close_Status_Information);
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Service_Order_Line_ID value
     * @return string|null
     */
    public function getService_Order_Line_ID()
    {
        return $this->Service_Order_Line_ID;
    }
    /**
     * Set Service_Order_Line_ID value
     * @param string $service_Order_Line_ID
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setService_Order_Line_ID($service_Order_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($service_Order_Line_ID) && !is_string($service_Order_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service_Order_Line_ID, true), gettype($service_Order_Line_ID)), __LINE__);
        }
        $this->Service_Order_Line_ID = $service_Order_Line_ID;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType|null
     */
    public function getPayment_Status_Reference()
    {
        return $this->Payment_Status_Reference;
    }
    /**
     * Set Payment_Status_Reference value
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setPayment_Status_Reference(\StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null)
    {
        $this->Payment_Status_Reference = $payment_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * Set Invoice_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setInvoice_Status_Reference(\StructType\Document_StatusObjectType $invoice_Status_Reference = null)
    {
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Get Receiving_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getReceiving_Status_Reference()
    {
        return $this->Receiving_Status_Reference;
    }
    /**
     * Set Receiving_Status_Reference value
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setReceiving_Status_Reference(\StructType\Document_StatusObjectType $receiving_Status_Reference = null)
    {
        $this->Receiving_Status_Reference = $receiving_Status_Reference;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Options_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Options_Data()
    {
        return $this->Tax_Rate_Options_Data;
    }
    /**
     * Set Tax_Rate_Options_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setTax_Rate_Options_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null)
    {
        $this->Tax_Rate_Options_Data = $tax_Rate_Options_Data;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Due_Date value
     * @return string|null
     */
    public function getDue_Date()
    {
        return $this->Due_Date;
    }
    /**
     * Set Due_Date value
     * @param string $due_Date
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setDue_Date($due_Date = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date) && !is_string($due_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date, true), gettype($due_Date)), __LINE__);
        }
        $this->Due_Date = $due_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Retention value
     * @return bool|null
     */
    public function getRetention()
    {
        return $this->Retention;
    }
    /**
     * Set Retention value
     * @param bool $retention
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setRetention($retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention) && !is_bool($retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention, true), gettype($retention)), __LINE__);
        }
        $this->Retention = $retention;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Requisition_Line_Reference value
     * @return \StructType\Requisition_LineObjectType|null
     */
    public function getRequisition_Line_Reference()
    {
        return $this->Requisition_Line_Reference;
    }
    /**
     * Set Requisition_Line_Reference value
     * @param \StructType\Requisition_LineObjectType $requisition_Line_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setRequisition_Line_Reference(\StructType\Requisition_LineObjectType $requisition_Line_Reference = null)
    {
        $this->Requisition_Line_Reference = $requisition_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Storage_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getStorage_Location_Reference()
    {
        return $this->Storage_Location_Reference;
    }
    /**
     * Set Storage_Location_Reference value
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setStorage_Location_Reference(\StructType\LocationObjectType $storage_Location_Reference = null)
    {
        $this->Storage_Location_Reference = $storage_Location_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $service_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$service_Order_Line_Replacement_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($service_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) ? get_class($service_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($service_Order_Line_Replacement_DataTypeWorktags_ReferenceItem), var_export($service_Order_Line_Replacement_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Service_Purchase_Order_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getService_Purchase_Order_Line_Split_Data()
    {
        return $this->Service_Purchase_Order_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Purchase_Order_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Purchase_Order_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Purchase_Order_Line_Split_DataForArrayConstraintsFromSetService_Purchase_Order_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $service_Order_Line_Replacement_DataTypeService_Purchase_Order_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$service_Order_Line_Replacement_DataTypeService_Purchase_Order_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($service_Order_Line_Replacement_DataTypeService_Purchase_Order_Line_Split_DataItem) ? get_class($service_Order_Line_Replacement_DataTypeService_Purchase_Order_Line_Split_DataItem) : sprintf('%s(%s)', gettype($service_Order_Line_Replacement_DataTypeService_Purchase_Order_Line_Split_DataItem), var_export($service_Order_Line_Replacement_DataTypeService_Purchase_Order_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Purchase_Order_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Purchase_Order_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $service_Purchase_Order_Line_Split_Data
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setService_Purchase_Order_Line_Split_Data(array $service_Purchase_Order_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Purchase_Order_Line_Split_DataArrayErrorMessage = self::validateService_Purchase_Order_Line_Split_DataForArrayConstraintsFromSetService_Purchase_Order_Line_Split_Data($service_Purchase_Order_Line_Split_Data))) {
            throw new \InvalidArgumentException($service_Purchase_Order_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Purchase_Order_Line_Split_Data = $service_Purchase_Order_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Service_Purchase_Order_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function addToService_Purchase_Order_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Service_Purchase_Order_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Purchase_Order_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Close_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getClose_Status_Reference()
    {
        return $this->Close_Status_Reference;
    }
    /**
     * Set Close_Status_Reference value
     * @param \StructType\Document_StatusObjectType $close_Status_Reference
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setClose_Status_Reference(\StructType\Document_StatusObjectType $close_Status_Reference = null)
    {
        $this->Close_Status_Reference = $close_Status_Reference;
        return $this;
    }
    /**
     * Get Close_Status_Information value
     * @return \StructType\Close_Status_InformationType[]|null
     */
    public function getClose_Status_Information()
    {
        return $this->Close_Status_Information;
    }
    /**
     * This method is responsible for validating the values passed to the setClose_Status_Information method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClose_Status_Information method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClose_Status_InformationForArrayConstraintsFromSetClose_Status_Information(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $service_Order_Line_Replacement_DataTypeClose_Status_InformationItem) {
            // validation for constraint: itemType
            if (!$service_Order_Line_Replacement_DataTypeClose_Status_InformationItem instanceof \StructType\Close_Status_InformationType) {
                $invalidValues[] = is_object($service_Order_Line_Replacement_DataTypeClose_Status_InformationItem) ? get_class($service_Order_Line_Replacement_DataTypeClose_Status_InformationItem) : sprintf('%s(%s)', gettype($service_Order_Line_Replacement_DataTypeClose_Status_InformationItem), var_export($service_Order_Line_Replacement_DataTypeClose_Status_InformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Close_Status_Information property can only contain items of type \StructType\Close_Status_InformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Close_Status_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Close_Status_InformationType[] $close_Status_Information
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function setClose_Status_Information(array $close_Status_Information = array())
    {
        // validation for constraint: array
        if ('' !== ($close_Status_InformationArrayErrorMessage = self::validateClose_Status_InformationForArrayConstraintsFromSetClose_Status_Information($close_Status_Information))) {
            throw new \InvalidArgumentException($close_Status_InformationArrayErrorMessage, __LINE__);
        }
        $this->Close_Status_Information = $close_Status_Information;
        return $this;
    }
    /**
     * Add item to Close_Status_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Close_Status_InformationType $item
     * @return \StructType\Service_Order_Line_Replacement_DataType
     */
    public function addToClose_Status_Information(\StructType\Close_Status_InformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Close_Status_InformationType) {
            throw new \InvalidArgumentException(sprintf('The Close_Status_Information property can only contain items of type \StructType\Close_Status_InformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Close_Status_Information[] = $item;
        return $this;
    }
}
