<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Receipt Adjustment data
 * @subpackage Structs
 */
class Receipt_Adjustment_DataType extends AbstractStructBase
{
    /**
     * The Receipt_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Receipt being Adjusted by Receipt Adjustment
     * - minOccurs: 0
     * @var \StructType\ReceiptObjectType
     */
    public $Receipt_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Document Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Item_Receipt_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all editable fields for Receipt Adjustment Item Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_Item_LineType[]
     */
    public $Item_Receipt_Line_Data;
    /**
     * The Service_Receipt_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all editable fields for Receipt Adjustment Service Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_Service_LineType[]
     */
    public $Service_Receipt_Line_Data;
    /**
     * Constructor method for Receipt_Adjustment_DataType
     * @uses Receipt_Adjustment_DataType::setReceipt_Reference()
     * @uses Receipt_Adjustment_DataType::setMemo()
     * @uses Receipt_Adjustment_DataType::setSubmit()
     * @uses Receipt_Adjustment_DataType::setItem_Receipt_Line_Data()
     * @uses Receipt_Adjustment_DataType::setService_Receipt_Line_Data()
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @param string $memo
     * @param bool $submit
     * @param \StructType\Receipt_Adjustment_Item_LineType[] $item_Receipt_Line_Data
     * @param \StructType\Receipt_Adjustment_Service_LineType[] $service_Receipt_Line_Data
     */
    public function __construct(\StructType\ReceiptObjectType $receipt_Reference = null, $memo = null, $submit = null, array $item_Receipt_Line_Data = array(), array $service_Receipt_Line_Data = array())
    {
        $this
            ->setReceipt_Reference($receipt_Reference)
            ->setMemo($memo)
            ->setSubmit($submit)
            ->setItem_Receipt_Line_Data($item_Receipt_Line_Data)
            ->setService_Receipt_Line_Data($service_Receipt_Line_Data);
    }
    /**
     * Get Receipt_Reference value
     * @return \StructType\ReceiptObjectType|null
     */
    public function getReceipt_Reference()
    {
        return $this->Receipt_Reference;
    }
    /**
     * Set Receipt_Reference value
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function setReceipt_Reference(\StructType\ReceiptObjectType $receipt_Reference = null)
    {
        $this->Receipt_Reference = $receipt_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Item_Receipt_Line_Data value
     * @return \StructType\Receipt_Adjustment_Item_LineType[]|null
     */
    public function getItem_Receipt_Line_Data()
    {
        return $this->Item_Receipt_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Receipt_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Receipt_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Receipt_Line_DataForArrayConstraintsFromSetItem_Receipt_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_DataTypeItem_Receipt_Line_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_DataTypeItem_Receipt_Line_DataItem instanceof \StructType\Receipt_Adjustment_Item_LineType) {
                $invalidValues[] = is_object($receipt_Adjustment_DataTypeItem_Receipt_Line_DataItem) ? get_class($receipt_Adjustment_DataTypeItem_Receipt_Line_DataItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_DataTypeItem_Receipt_Line_DataItem), var_export($receipt_Adjustment_DataTypeItem_Receipt_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_LineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_LineType[] $item_Receipt_Line_Data
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function setItem_Receipt_Line_Data(array $item_Receipt_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Receipt_Line_DataArrayErrorMessage = self::validateItem_Receipt_Line_DataForArrayConstraintsFromSetItem_Receipt_Line_Data($item_Receipt_Line_Data))) {
            throw new \InvalidArgumentException($item_Receipt_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Receipt_Line_Data = $item_Receipt_Line_Data;
        return $this;
    }
    /**
     * Add item to Item_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_LineType $item
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function addToItem_Receipt_Line_Data(\StructType\Receipt_Adjustment_Item_LineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Adjustment_Item_LineType) {
            throw new \InvalidArgumentException(sprintf('The Item_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_LineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Receipt_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Service_Receipt_Line_Data value
     * @return \StructType\Receipt_Adjustment_Service_LineType[]|null
     */
    public function getService_Receipt_Line_Data()
    {
        return $this->Service_Receipt_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Receipt_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Receipt_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Receipt_Line_DataForArrayConstraintsFromSetService_Receipt_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_DataTypeService_Receipt_Line_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_DataTypeService_Receipt_Line_DataItem instanceof \StructType\Receipt_Adjustment_Service_LineType) {
                $invalidValues[] = is_object($receipt_Adjustment_DataTypeService_Receipt_Line_DataItem) ? get_class($receipt_Adjustment_DataTypeService_Receipt_Line_DataItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_DataTypeService_Receipt_Line_DataItem), var_export($receipt_Adjustment_DataTypeService_Receipt_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Service_LineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Service_LineType[] $service_Receipt_Line_Data
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function setService_Receipt_Line_Data(array $service_Receipt_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Receipt_Line_DataArrayErrorMessage = self::validateService_Receipt_Line_DataForArrayConstraintsFromSetService_Receipt_Line_Data($service_Receipt_Line_Data))) {
            throw new \InvalidArgumentException($service_Receipt_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Receipt_Line_Data = $service_Receipt_Line_Data;
        return $this;
    }
    /**
     * Add item to Service_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Service_LineType $item
     * @return \StructType\Receipt_Adjustment_DataType
     */
    public function addToService_Receipt_Line_Data(\StructType\Receipt_Adjustment_Service_LineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Adjustment_Service_LineType) {
            throw new \InvalidArgumentException(sprintf('The Service_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Service_LineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Receipt_Line_Data[] = $item;
        return $this;
    }
}
