<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Response_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to capture a response to a Request for Quote document. It includes responses to RFQ Lines and header level bid requirements.
 * @subpackage Structs
 */
class RFQ_Response_Data_InboundType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Response_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Response Document.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Response_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company used to record RFQ Response.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The RFQ_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ for which the response is created.
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $RFQ_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Supplier for which the response is created.
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Response_Recorded_By
     * Meta information extracted from the WSDL
     * - documentation: Response Recorded By
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Recorded_By;
    /**
     * The Response_Date
     * Meta information extracted from the WSDL
     * - documentation: Response Date with time precision up to minute.
     * - maxOccurs: 1
     * @var string
     */
    public $Response_Date;
    /**
     * The Shipping_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Terms for the Request For Quote Response
     * - minOccurs: 0
     * @var \StructType\Shipping_TermsObjectType
     */
    public $Shipping_Terms_Reference;
    /**
     * The Shipping_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Method for the Request For Quote Response
     * - minOccurs: 0
     * @var \StructType\Shipping_MethodObjectType
     */
    public $Shipping_Method_Reference;
    /**
     * The Shipping_Instruction
     * Meta information extracted from the WSDL
     * - documentation: Shipping Instruction for the Request For Quote Response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Instruction;
    /**
     * The Response_Memo
     * Meta information extracted from the WSDL
     * - documentation: Response Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Memo;
    /**
     * The Request_for_Quote_Response_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Response_Line_Data_InboundType[]
     */
    public $Request_for_Quote_Response_Line_Data;
    /**
     * The RFQ_Header_Bid_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[]
     */
    public $RFQ_Header_Bid_Response_Data;
    /**
     * The RFQ_Response_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $RFQ_Response_Attachment_Data;
    /**
     * Constructor method for RFQ_Response_Data_InboundType
     * @uses RFQ_Response_Data_InboundType::setRequest_for_Quote_Response_ID()
     * @uses RFQ_Response_Data_InboundType::setSubmit()
     * @uses RFQ_Response_Data_InboundType::setCompany_Reference()
     * @uses RFQ_Response_Data_InboundType::setRFQ_Reference()
     * @uses RFQ_Response_Data_InboundType::setSupplier_Reference()
     * @uses RFQ_Response_Data_InboundType::setResponse_Recorded_By()
     * @uses RFQ_Response_Data_InboundType::setResponse_Date()
     * @uses RFQ_Response_Data_InboundType::setShipping_Terms_Reference()
     * @uses RFQ_Response_Data_InboundType::setShipping_Method_Reference()
     * @uses RFQ_Response_Data_InboundType::setShipping_Instruction()
     * @uses RFQ_Response_Data_InboundType::setResponse_Memo()
     * @uses RFQ_Response_Data_InboundType::setRequest_for_Quote_Response_Line_Data()
     * @uses RFQ_Response_Data_InboundType::setRFQ_Header_Bid_Response_Data()
     * @uses RFQ_Response_Data_InboundType::setRFQ_Response_Attachment_Data()
     * @param string $request_for_Quote_Response_ID
     * @param bool $submit
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Request_for_QuoteObjectType $rFQ_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param string $response_Recorded_By
     * @param string $response_Date
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @param string $shipping_Instruction
     * @param string $response_Memo
     * @param \StructType\RFQ_Response_Line_Data_InboundType[] $request_for_Quote_Response_Line_Data
     * @param \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[] $rFQ_Header_Bid_Response_Data
     * @param \StructType\Financials_Attachment_DataType[] $rFQ_Response_Attachment_Data
     */
    public function __construct($request_for_Quote_Response_ID = null, $submit = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Request_for_QuoteObjectType $rFQ_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $response_Recorded_By = null, $response_Date = null, \StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null, \StructType\Shipping_MethodObjectType $shipping_Method_Reference = null, $shipping_Instruction = null, $response_Memo = null, array $request_for_Quote_Response_Line_Data = array(), array $rFQ_Header_Bid_Response_Data = array(), array $rFQ_Response_Attachment_Data = array())
    {
        $this
            ->setRequest_for_Quote_Response_ID($request_for_Quote_Response_ID)
            ->setSubmit($submit)
            ->setCompany_Reference($company_Reference)
            ->setRFQ_Reference($rFQ_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setResponse_Recorded_By($response_Recorded_By)
            ->setResponse_Date($response_Date)
            ->setShipping_Terms_Reference($shipping_Terms_Reference)
            ->setShipping_Method_Reference($shipping_Method_Reference)
            ->setShipping_Instruction($shipping_Instruction)
            ->setResponse_Memo($response_Memo)
            ->setRequest_for_Quote_Response_Line_Data($request_for_Quote_Response_Line_Data)
            ->setRFQ_Header_Bid_Response_Data($rFQ_Header_Bid_Response_Data)
            ->setRFQ_Response_Attachment_Data($rFQ_Response_Attachment_Data);
    }
    /**
     * Get Request_for_Quote_Response_ID value
     * @return string|null
     */
    public function getRequest_for_Quote_Response_ID()
    {
        return $this->Request_for_Quote_Response_ID;
    }
    /**
     * Set Request_for_Quote_Response_ID value
     * @param string $request_for_Quote_Response_ID
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setRequest_for_Quote_Response_ID($request_for_Quote_Response_ID = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Response_ID) && !is_string($request_for_Quote_Response_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Response_ID, true), gettype($request_for_Quote_Response_ID)), __LINE__);
        }
        $this->Request_for_Quote_Response_ID = $request_for_Quote_Response_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get RFQ_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRFQ_Reference()
    {
        return $this->RFQ_Reference;
    }
    /**
     * Set RFQ_Reference value
     * @param \StructType\Request_for_QuoteObjectType $rFQ_Reference
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setRFQ_Reference(\StructType\Request_for_QuoteObjectType $rFQ_Reference = null)
    {
        $this->RFQ_Reference = $rFQ_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Response_Recorded_By value
     * @return string|null
     */
    public function getResponse_Recorded_By()
    {
        return $this->Response_Recorded_By;
    }
    /**
     * Set Response_Recorded_By value
     * @param string $response_Recorded_By
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setResponse_Recorded_By($response_Recorded_By = null)
    {
        // validation for constraint: string
        if (!is_null($response_Recorded_By) && !is_string($response_Recorded_By)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Recorded_By, true), gettype($response_Recorded_By)), __LINE__);
        }
        $this->Response_Recorded_By = $response_Recorded_By;
        return $this;
    }
    /**
     * Get Response_Date value
     * @return string|null
     */
    public function getResponse_Date()
    {
        return $this->Response_Date;
    }
    /**
     * Set Response_Date value
     * @param string $response_Date
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setResponse_Date($response_Date = null)
    {
        // validation for constraint: string
        if (!is_null($response_Date) && !is_string($response_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Date, true), gettype($response_Date)), __LINE__);
        }
        $this->Response_Date = $response_Date;
        return $this;
    }
    /**
     * Get Shipping_Terms_Reference value
     * @return \StructType\Shipping_TermsObjectType|null
     */
    public function getShipping_Terms_Reference()
    {
        return $this->Shipping_Terms_Reference;
    }
    /**
     * Set Shipping_Terms_Reference value
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setShipping_Terms_Reference(\StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null)
    {
        $this->Shipping_Terms_Reference = $shipping_Terms_Reference;
        return $this;
    }
    /**
     * Get Shipping_Method_Reference value
     * @return \StructType\Shipping_MethodObjectType|null
     */
    public function getShipping_Method_Reference()
    {
        return $this->Shipping_Method_Reference;
    }
    /**
     * Set Shipping_Method_Reference value
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setShipping_Method_Reference(\StructType\Shipping_MethodObjectType $shipping_Method_Reference = null)
    {
        $this->Shipping_Method_Reference = $shipping_Method_Reference;
        return $this;
    }
    /**
     * Get Shipping_Instruction value
     * @return string|null
     */
    public function getShipping_Instruction()
    {
        return $this->Shipping_Instruction;
    }
    /**
     * Set Shipping_Instruction value
     * @param string $shipping_Instruction
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setShipping_Instruction($shipping_Instruction = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Instruction) && !is_string($shipping_Instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Instruction, true), gettype($shipping_Instruction)), __LINE__);
        }
        $this->Shipping_Instruction = $shipping_Instruction;
        return $this;
    }
    /**
     * Get Response_Memo value
     * @return string|null
     */
    public function getResponse_Memo()
    {
        return $this->Response_Memo;
    }
    /**
     * Set Response_Memo value
     * @param string $response_Memo
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setResponse_Memo($response_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($response_Memo) && !is_string($response_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Memo, true), gettype($response_Memo)), __LINE__);
        }
        $this->Response_Memo = $response_Memo;
        return $this;
    }
    /**
     * Get Request_for_Quote_Response_Line_Data value
     * @return \StructType\RFQ_Response_Line_Data_InboundType[]|null
     */
    public function getRequest_for_Quote_Response_Line_Data()
    {
        return $this->Request_for_Quote_Response_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Response_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Response_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Response_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Response_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Data_InboundTypeRequest_for_Quote_Response_Line_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Data_InboundTypeRequest_for_Quote_Response_Line_DataItem instanceof \StructType\RFQ_Response_Line_Data_InboundType) {
                $invalidValues[] = is_object($rFQ_Response_Data_InboundTypeRequest_for_Quote_Response_Line_DataItem) ? get_class($rFQ_Response_Data_InboundTypeRequest_for_Quote_Response_Line_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Data_InboundTypeRequest_for_Quote_Response_Line_DataItem), var_export($rFQ_Response_Data_InboundTypeRequest_for_Quote_Response_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Response_Line_Data property can only contain items of type \StructType\RFQ_Response_Line_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Response_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Response_Line_Data_InboundType[] $request_for_Quote_Response_Line_Data
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setRequest_for_Quote_Response_Line_Data(array $request_for_Quote_Response_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Response_Line_DataArrayErrorMessage = self::validateRequest_for_Quote_Response_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Response_Line_Data($request_for_Quote_Response_Line_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Response_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Response_Line_Data = $request_for_Quote_Response_Line_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Response_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Response_Line_Data_InboundType $item
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function addToRequest_for_Quote_Response_Line_Data(\StructType\RFQ_Response_Line_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Response_Line_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Response_Line_Data property can only contain items of type \StructType\RFQ_Response_Line_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Response_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Header_Bid_Response_Data value
     * @return \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[]|null
     */
    public function getRFQ_Header_Bid_Response_Data()
    {
        return $this->RFQ_Header_Bid_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Header_Bid_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Header_Bid_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Header_Bid_Response_DataForArrayConstraintsFromSetRFQ_Header_Bid_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Data_InboundTypeRFQ_Header_Bid_Response_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Data_InboundTypeRFQ_Header_Bid_Response_DataItem instanceof \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType) {
                $invalidValues[] = is_object($rFQ_Response_Data_InboundTypeRFQ_Header_Bid_Response_DataItem) ? get_class($rFQ_Response_Data_InboundTypeRFQ_Header_Bid_Response_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Data_InboundTypeRFQ_Header_Bid_Response_DataItem), var_export($rFQ_Response_Data_InboundTypeRFQ_Header_Bid_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Header_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Header_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType[] $rFQ_Header_Bid_Response_Data
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setRFQ_Header_Bid_Response_Data(array $rFQ_Header_Bid_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Header_Bid_Response_DataArrayErrorMessage = self::validateRFQ_Header_Bid_Response_DataForArrayConstraintsFromSetRFQ_Header_Bid_Response_Data($rFQ_Header_Bid_Response_Data))) {
            throw new \InvalidArgumentException($rFQ_Header_Bid_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Header_Bid_Response_Data = $rFQ_Header_Bid_Response_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Header_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType $item
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function addToRFQ_Header_Bid_Response_Data(\StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Header_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_Or_Line_Bid_Response_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Header_Bid_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Response_Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getRFQ_Response_Attachment_Data()
    {
        return $this->RFQ_Response_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Response_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Response_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Response_Attachment_DataForArrayConstraintsFromSetRFQ_Response_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Data_InboundTypeRFQ_Response_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Data_InboundTypeRFQ_Response_Attachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($rFQ_Response_Data_InboundTypeRFQ_Response_Attachment_DataItem) ? get_class($rFQ_Response_Data_InboundTypeRFQ_Response_Attachment_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Data_InboundTypeRFQ_Response_Attachment_DataItem), var_export($rFQ_Response_Data_InboundTypeRFQ_Response_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Response_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Response_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $rFQ_Response_Attachment_Data
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function setRFQ_Response_Attachment_Data(array $rFQ_Response_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Response_Attachment_DataArrayErrorMessage = self::validateRFQ_Response_Attachment_DataForArrayConstraintsFromSetRFQ_Response_Attachment_Data($rFQ_Response_Attachment_Data))) {
            throw new \InvalidArgumentException($rFQ_Response_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Response_Attachment_Data = $rFQ_Response_Attachment_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Response_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\RFQ_Response_Data_InboundType
     */
    public function addToRFQ_Response_Attachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Response_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Response_Attachment_Data[] = $item;
        return $this;
    }
}
