<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Worker_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Contingent Worker request criteria
 * @subpackage Structs
 */
class Contingent_Worker_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Without_Supplier_Assigned
     * Meta information extracted from the WSDL
     * - documentation: Attribute returning if a Contingent Worker is assigned to a supplier
     * - choice: Without_Supplier_Assigned | Supervisory_Organization_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Without_Supplier_Assigned;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supervisory Organization on which Contingent Worker is assigned
     * - choice: Without_Supplier_Assigned | Supervisory_Organization_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * Constructor method for Contingent_Worker_Request_CriteriaType
     * @uses Contingent_Worker_Request_CriteriaType::setWithout_Supplier_Assigned()
     * @uses Contingent_Worker_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @param bool $without_Supplier_Assigned
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     */
    public function __construct($without_Supplier_Assigned = null, \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this
            ->setWithout_Supplier_Assigned($without_Supplier_Assigned)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference);
    }
    /**
     * Get Without_Supplier_Assigned value
     * @return bool|null
     */
    public function getWithout_Supplier_Assigned()
    {
        return isset($this->Without_Supplier_Assigned) ? $this->Without_Supplier_Assigned : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWithout_Supplier_Assigned method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithout_Supplier_Assigned method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWithout_Supplier_AssignedForChoiceConstraintsFromSetWithout_Supplier_Assigned($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supervisory_Organization_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Without_Supplier_Assigned can\'t be set as the property %s is already set. Only one property must be set among these properties: Without_Supplier_Assigned, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Without_Supplier_Assigned value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $without_Supplier_Assigned
     * @return \StructType\Contingent_Worker_Request_CriteriaType
     */
    public function setWithout_Supplier_Assigned($without_Supplier_Assigned = null)
    {
        // validation for constraint: boolean
        if (!is_null($without_Supplier_Assigned) && !is_bool($without_Supplier_Assigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($without_Supplier_Assigned, true), gettype($without_Supplier_Assigned)), __LINE__);
        }
        // validation for constraint: choice(Without_Supplier_Assigned, Supervisory_Organization_Reference)
        if ('' !== ($without_Supplier_AssignedChoiceErrorMessage = self::validateWithout_Supplier_AssignedForChoiceConstraintsFromSetWithout_Supplier_Assigned($without_Supplier_Assigned))) {
            throw new \InvalidArgumentException($without_Supplier_AssignedChoiceErrorMessage, __LINE__);
        }
        if (is_null($without_Supplier_Assigned) || (is_array($without_Supplier_Assigned) && empty($without_Supplier_Assigned))) {
            unset($this->Without_Supplier_Assigned);
        } else {
            $this->Without_Supplier_Assigned = $without_Supplier_Assigned;
        }
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return isset($this->Supervisory_Organization_Reference) ? $this->Supervisory_Organization_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupervisory_Organization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupervisory_Organization_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupervisory_Organization_ReferenceForChoiceConstraintsFromSetSupervisory_Organization_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Without_Supplier_Assigned',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supervisory_Organization_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supervisory_Organization_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Contingent_Worker_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        // validation for constraint: choice(Without_Supplier_Assigned, Supervisory_Organization_Reference)
        if ('' !== ($supervisory_Organization_ReferenceChoiceErrorMessage = self::validateSupervisory_Organization_ReferenceForChoiceConstraintsFromSetSupervisory_Organization_Reference($supervisory_Organization_Reference))) {
            throw new \InvalidArgumentException($supervisory_Organization_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supervisory_Organization_Reference) || (is_array($supervisory_Organization_Reference) && empty($supervisory_Organization_Reference))) {
            unset($this->Supervisory_Organization_Reference);
        } else {
            $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        }
        return $this;
    }
}
