<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Configuration_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Declining Balance Depreciation Method must have a threshold. | Element containing Asset Depreciation Schedule data; In order to assign 'Half-Year' as the depreciation convention, the company asset book must use a fiscal schedule with
 * an even number of fiscal periods per fiscal year.In order to assign 'Mid-Quarter' as the depreciation convention, the company asset book must use a fiscal schedule where number of fiscal periods per fiscal year is divisible by 4.
 * @subpackage Structs
 */
class Asset_Book_Configuration_WWS_DataType extends AbstractStructBase
{
    /**
     * The Depreciation_Profile_Override_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing depreciation profile for this depreciation schedule. This value may be overridden for the primary book.
     * - minOccurs: 0
     * @var \StructType\Depreciation_ProfileObjectType
     */
    public $Depreciation_Profile_Override_Reference;
    /**
     * The Depreciation_Method_Override_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Depreciation Method. Depreciation Methods are provided by Workday and include STRAIGHT_LINE, DECLINING_BALANCE_SW_SL, and SUM_OF_YEARS_DIGITS. This field defaults from the spend category but can be entered.
     * - minOccurs: 0
     * @var \StructType\Abstract_Depreciation_MethodObjectType
     */
    public $Depreciation_Method_Override_Reference;
    /**
     * The Depreciation_Percent_Override
     * Meta information extracted from the WSDL
     * - documentation: Depreciation percent for Declining Balance with Switch to Straight Line (DECLINING_BALANCE_SW_SL) method. Enter 200 for Double Declining. This field defaults from the spend category depreciation profile but can be entered. |
     * Depreciation percent should be greater than 100 when the depreciation method is Declining Balance with switch to Straight Line. | Depreciation Percent cannot be entered if Depreciation Method is not Declining Balance (with or without Switch to
     * Straight Line). | Depreciation percent must be greater than 0 and less than 100 when the depreciation method is Declining Balance.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Depreciation_Percent_Override;
    /**
     * The Useful_Life_in_Periods_Override
     * Meta information extracted from the WSDL
     * - documentation: Numeric value representing the useful life (in periods) for the business asset. This field defaults from Spend Category Depreciation Profile but can be entered | Useful Life cannot be more than 200 years. Useful life in years is
     * useful life in periods divided by number of periods in the company's fiscal year. | Useful Life must be equal to zero if the Depreciation Method is Declining Balance.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Useful_Life_in_Periods_Override;
    /**
     * The Depreciation_Threshold_Override
     * Meta information extracted from the WSDL
     * - documentation: Depreciation Threshold. Enter only if method is declining balance. | Only Declining Balance Depreciation Method can have a threshold. | Depreciation Threshold is greater than Total Asset Cost.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Depreciation_Threshold_Override;
    /**
     * The Depreciation_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Depreciation start date cannot be prior to contract end date unless the asset is loaded as fully depreciated. | Depreciation Start Date must match start date of the first ledger period that depreciation is to start being recorded in
     * Workday. | For converted assets with no historical accumulated depreciation, leave the depreciation start date blank so that Workday can determine the correct date. | Ledger Period must exist for the Depreciation Start Date. | Depreciation Start Date
     * is required when Accumulated Depreciation is provided | Depreciation Start Date is required when Remaining Periods is provided | For converted assets, the depreciation start date represents the date that depreciation starts in Workday. For converted
     * assets with historical accumulated depreciation, the depreciation start date should be 1 day greater than the date up to which the historical accumulated depreciation is calculated. The date cannot be prior to the acquisition date. For converted
     * assets with no historical accumulated depreciation, leave the depreciation start date blank so that Workday can determine the correct date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Depreciation_Start_Date;
    /**
     * The Remaining_Depreciation_Periods
     * Meta information extracted from the WSDL
     * - documentation: Numeric value for remaining depreciation periods if entering accumulated depreciation from a prior system. | Remaining depreciation periods must be 0 when depreciation method is Term or Declining Balance. | Remaining Depreciation
     * Periods cannot be greater than useful life in periods provided or defaulted from profile for spend category | Numeric value for remaining depreciation periods if entering accumulated depreciation from a prior system and depreciation start date.
     * Workday will generate depreciation entries for this schedule for the number of remaining periods. | Remaining depreciation periods is required when you enter Accumulated Depreciation | The fiscal period must exist for the depreciation start date in
     * the fiscal schedule for the company asset book. | Remaining depreciation periods must be 0 when depreciation start date is blank | Remaining depreciation periods cannot be greater than useful life | When depreciation is based on the number of days
     * per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation amount for each period correctly. In order to complete the depreciation setup for this asset and create the
     * depreciation schedule, you will need to create additional fiscal years / periods for fiscal schedule linked to the company asset book(s).
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Remaining_Depreciation_Periods;
    /**
     * The Accumulated_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Accumulated Depreciation | Accumulated Depreciation cannot be greater than Acquisition Cost minus Residual Value | The accumulated depreciation amount at the time the asset was transferred to a different company. | Numeric value
     * representing historical accumulated depreciation as of a day prior to depreciation start date. This value cannot be greater than historical cost minus historical residual value. Workday uses this accumulated depreciation value to determine
     * depreciable cost basis to generate the depreciation schedule for remaining useful life starting from depreciation start date. | Accumulated depreciation cannot be greater than cost minus residual value for the asset book | Accumulated depreciation
     * must be 0 when depreciation start date is blank | Accumulated depreciation is required when depreciation start date has a value | The accumulated depreciation entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Accumulated_Depreciation;
    /**
     * The Year_To_Date_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Year To Date depreciation as of the Depreciation Start Date. Enter only if method is declining balance or sum of years digits. | The year to date depreciation entered has too many digits beyond the decimal point | Year To Date
     * Depreciation is required when method is Declining Balance (with or without switch to Straight Line) or Sum Of Years Digits and Depreciation Start Date is not in the first period.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Year_To_Date_Depreciation;
    /**
     * Constructor method for Asset_Book_Configuration_WWS_DataType
     * @uses Asset_Book_Configuration_WWS_DataType::setDepreciation_Profile_Override_Reference()
     * @uses Asset_Book_Configuration_WWS_DataType::setDepreciation_Method_Override_Reference()
     * @uses Asset_Book_Configuration_WWS_DataType::setDepreciation_Percent_Override()
     * @uses Asset_Book_Configuration_WWS_DataType::setUseful_Life_in_Periods_Override()
     * @uses Asset_Book_Configuration_WWS_DataType::setDepreciation_Threshold_Override()
     * @uses Asset_Book_Configuration_WWS_DataType::setDepreciation_Start_Date()
     * @uses Asset_Book_Configuration_WWS_DataType::setRemaining_Depreciation_Periods()
     * @uses Asset_Book_Configuration_WWS_DataType::setAccumulated_Depreciation()
     * @uses Asset_Book_Configuration_WWS_DataType::setYear_To_Date_Depreciation()
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Override_Reference
     * @param \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Override_Reference
     * @param float $depreciation_Percent_Override
     * @param float $useful_Life_in_Periods_Override
     * @param float $depreciation_Threshold_Override
     * @param string $depreciation_Start_Date
     * @param float $remaining_Depreciation_Periods
     * @param float $accumulated_Depreciation
     * @param float $year_To_Date_Depreciation
     */
    public function __construct(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Override_Reference = null, \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Override_Reference = null, $depreciation_Percent_Override = null, $useful_Life_in_Periods_Override = null, $depreciation_Threshold_Override = null, $depreciation_Start_Date = null, $remaining_Depreciation_Periods = null, $accumulated_Depreciation = null, $year_To_Date_Depreciation = null)
    {
        $this
            ->setDepreciation_Profile_Override_Reference($depreciation_Profile_Override_Reference)
            ->setDepreciation_Method_Override_Reference($depreciation_Method_Override_Reference)
            ->setDepreciation_Percent_Override($depreciation_Percent_Override)
            ->setUseful_Life_in_Periods_Override($useful_Life_in_Periods_Override)
            ->setDepreciation_Threshold_Override($depreciation_Threshold_Override)
            ->setDepreciation_Start_Date($depreciation_Start_Date)
            ->setRemaining_Depreciation_Periods($remaining_Depreciation_Periods)
            ->setAccumulated_Depreciation($accumulated_Depreciation)
            ->setYear_To_Date_Depreciation($year_To_Date_Depreciation);
    }
    /**
     * Get Depreciation_Profile_Override_Reference value
     * @return \StructType\Depreciation_ProfileObjectType|null
     */
    public function getDepreciation_Profile_Override_Reference()
    {
        return $this->Depreciation_Profile_Override_Reference;
    }
    /**
     * Set Depreciation_Profile_Override_Reference value
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Override_Reference
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setDepreciation_Profile_Override_Reference(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Override_Reference = null)
    {
        $this->Depreciation_Profile_Override_Reference = $depreciation_Profile_Override_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Method_Override_Reference value
     * @return \StructType\Abstract_Depreciation_MethodObjectType|null
     */
    public function getDepreciation_Method_Override_Reference()
    {
        return $this->Depreciation_Method_Override_Reference;
    }
    /**
     * Set Depreciation_Method_Override_Reference value
     * @param \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Override_Reference
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setDepreciation_Method_Override_Reference(\StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Override_Reference = null)
    {
        $this->Depreciation_Method_Override_Reference = $depreciation_Method_Override_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Percent_Override value
     * @return float|null
     */
    public function getDepreciation_Percent_Override()
    {
        return $this->Depreciation_Percent_Override;
    }
    /**
     * Set Depreciation_Percent_Override value
     * @param float $depreciation_Percent_Override
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setDepreciation_Percent_Override($depreciation_Percent_Override = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Percent_Override) && !(is_float($depreciation_Percent_Override) || is_numeric($depreciation_Percent_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Percent_Override, true), gettype($depreciation_Percent_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($depreciation_Percent_Override) && mb_strlen(mb_substr($depreciation_Percent_Override, false !== mb_strpos($depreciation_Percent_Override, '.') ? mb_strpos($depreciation_Percent_Override, '.') + 1 : mb_strlen($depreciation_Percent_Override))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($depreciation_Percent_Override, true), mb_strlen(mb_substr($depreciation_Percent_Override, mb_strpos($depreciation_Percent_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($depreciation_Percent_Override) && $depreciation_Percent_Override < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($depreciation_Percent_Override, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($depreciation_Percent_Override) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Percent_Override)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($depreciation_Percent_Override, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Percent_Override))), __LINE__);
        }
        $this->Depreciation_Percent_Override = $depreciation_Percent_Override;
        return $this;
    }
    /**
     * Get Useful_Life_in_Periods_Override value
     * @return float|null
     */
    public function getUseful_Life_in_Periods_Override()
    {
        return $this->Useful_Life_in_Periods_Override;
    }
    /**
     * Set Useful_Life_in_Periods_Override value
     * @param float $useful_Life_in_Periods_Override
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setUseful_Life_in_Periods_Override($useful_Life_in_Periods_Override = null)
    {
        // validation for constraint: float
        if (!is_null($useful_Life_in_Periods_Override) && !(is_float($useful_Life_in_Periods_Override) || is_numeric($useful_Life_in_Periods_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($useful_Life_in_Periods_Override, true), gettype($useful_Life_in_Periods_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($useful_Life_in_Periods_Override) && mb_strlen(mb_substr($useful_Life_in_Periods_Override, false !== mb_strpos($useful_Life_in_Periods_Override, '.') ? mb_strpos($useful_Life_in_Periods_Override, '.') + 1 : mb_strlen($useful_Life_in_Periods_Override))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($useful_Life_in_Periods_Override, true), mb_strlen(mb_substr($useful_Life_in_Periods_Override, mb_strpos($useful_Life_in_Periods_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($useful_Life_in_Periods_Override) && $useful_Life_in_Periods_Override < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($useful_Life_in_Periods_Override, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($useful_Life_in_Periods_Override) && mb_strlen(preg_replace('/(\D)/', '', $useful_Life_in_Periods_Override)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($useful_Life_in_Periods_Override, true), mb_strlen(preg_replace('/(\D)/', '', $useful_Life_in_Periods_Override))), __LINE__);
        }
        $this->Useful_Life_in_Periods_Override = $useful_Life_in_Periods_Override;
        return $this;
    }
    /**
     * Get Depreciation_Threshold_Override value
     * @return float|null
     */
    public function getDepreciation_Threshold_Override()
    {
        return $this->Depreciation_Threshold_Override;
    }
    /**
     * Set Depreciation_Threshold_Override value
     * @param float $depreciation_Threshold_Override
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setDepreciation_Threshold_Override($depreciation_Threshold_Override = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Threshold_Override) && !(is_float($depreciation_Threshold_Override) || is_numeric($depreciation_Threshold_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Threshold_Override, true), gettype($depreciation_Threshold_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($depreciation_Threshold_Override) && mb_strlen(mb_substr($depreciation_Threshold_Override, false !== mb_strpos($depreciation_Threshold_Override, '.') ? mb_strpos($depreciation_Threshold_Override, '.') + 1 : mb_strlen($depreciation_Threshold_Override))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($depreciation_Threshold_Override, true), mb_strlen(mb_substr($depreciation_Threshold_Override, mb_strpos($depreciation_Threshold_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($depreciation_Threshold_Override) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Threshold_Override)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($depreciation_Threshold_Override, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Threshold_Override))), __LINE__);
        }
        $this->Depreciation_Threshold_Override = $depreciation_Threshold_Override;
        return $this;
    }
    /**
     * Get Depreciation_Start_Date value
     * @return string|null
     */
    public function getDepreciation_Start_Date()
    {
        return $this->Depreciation_Start_Date;
    }
    /**
     * Set Depreciation_Start_Date value
     * @param string $depreciation_Start_Date
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setDepreciation_Start_Date($depreciation_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($depreciation_Start_Date) && !is_string($depreciation_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depreciation_Start_Date, true), gettype($depreciation_Start_Date)), __LINE__);
        }
        $this->Depreciation_Start_Date = $depreciation_Start_Date;
        return $this;
    }
    /**
     * Get Remaining_Depreciation_Periods value
     * @return float|null
     */
    public function getRemaining_Depreciation_Periods()
    {
        return $this->Remaining_Depreciation_Periods;
    }
    /**
     * Set Remaining_Depreciation_Periods value
     * @param float $remaining_Depreciation_Periods
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setRemaining_Depreciation_Periods($remaining_Depreciation_Periods = null)
    {
        // validation for constraint: float
        if (!is_null($remaining_Depreciation_Periods) && !(is_float($remaining_Depreciation_Periods) || is_numeric($remaining_Depreciation_Periods))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining_Depreciation_Periods, true), gettype($remaining_Depreciation_Periods)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($remaining_Depreciation_Periods) && mb_strlen(mb_substr($remaining_Depreciation_Periods, false !== mb_strpos($remaining_Depreciation_Periods, '.') ? mb_strpos($remaining_Depreciation_Periods, '.') + 1 : mb_strlen($remaining_Depreciation_Periods))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($remaining_Depreciation_Periods, true), mb_strlen(mb_substr($remaining_Depreciation_Periods, mb_strpos($remaining_Depreciation_Periods, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($remaining_Depreciation_Periods) && $remaining_Depreciation_Periods < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($remaining_Depreciation_Periods, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($remaining_Depreciation_Periods) && mb_strlen(preg_replace('/(\D)/', '', $remaining_Depreciation_Periods)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($remaining_Depreciation_Periods, true), mb_strlen(preg_replace('/(\D)/', '', $remaining_Depreciation_Periods))), __LINE__);
        }
        $this->Remaining_Depreciation_Periods = $remaining_Depreciation_Periods;
        return $this;
    }
    /**
     * Get Accumulated_Depreciation value
     * @return float|null
     */
    public function getAccumulated_Depreciation()
    {
        return $this->Accumulated_Depreciation;
    }
    /**
     * Set Accumulated_Depreciation value
     * @param float $accumulated_Depreciation
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setAccumulated_Depreciation($accumulated_Depreciation = null)
    {
        // validation for constraint: float
        if (!is_null($accumulated_Depreciation) && !(is_float($accumulated_Depreciation) || is_numeric($accumulated_Depreciation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accumulated_Depreciation, true), gettype($accumulated_Depreciation)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($accumulated_Depreciation) && mb_strlen(mb_substr($accumulated_Depreciation, false !== mb_strpos($accumulated_Depreciation, '.') ? mb_strpos($accumulated_Depreciation, '.') + 1 : mb_strlen($accumulated_Depreciation))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($accumulated_Depreciation, true), mb_strlen(mb_substr($accumulated_Depreciation, mb_strpos($accumulated_Depreciation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($accumulated_Depreciation) && mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($accumulated_Depreciation, true), mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation))), __LINE__);
        }
        $this->Accumulated_Depreciation = $accumulated_Depreciation;
        return $this;
    }
    /**
     * Get Year_To_Date_Depreciation value
     * @return float|null
     */
    public function getYear_To_Date_Depreciation()
    {
        return $this->Year_To_Date_Depreciation;
    }
    /**
     * Set Year_To_Date_Depreciation value
     * @param float $year_To_Date_Depreciation
     * @return \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public function setYear_To_Date_Depreciation($year_To_Date_Depreciation = null)
    {
        // validation for constraint: float
        if (!is_null($year_To_Date_Depreciation) && !(is_float($year_To_Date_Depreciation) || is_numeric($year_To_Date_Depreciation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($year_To_Date_Depreciation, true), gettype($year_To_Date_Depreciation)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($year_To_Date_Depreciation) && mb_strlen(mb_substr($year_To_Date_Depreciation, false !== mb_strpos($year_To_Date_Depreciation, '.') ? mb_strpos($year_To_Date_Depreciation, '.') + 1 : mb_strlen($year_To_Date_Depreciation))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($year_To_Date_Depreciation, true), mb_strlen(mb_substr($year_To_Date_Depreciation, mb_strpos($year_To_Date_Depreciation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($year_To_Date_Depreciation) && mb_strlen(preg_replace('/(\D)/', '', $year_To_Date_Depreciation)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($year_To_Date_Depreciation, true), mb_strlen(preg_replace('/(\D)/', '', $year_To_Date_Depreciation))), __LINE__);
        }
        $this->Year_To_Date_Depreciation = $year_To_Date_Depreciation;
        return $this;
    }
}
