<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Suspend_Asset_Depreciation_for_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You cannot suspend depreciation in an asset book that is already suspended. | Suspend date cannot be prior to depreciation start date | Suspend date cannot be after last depreciation period end date | The book selected is not a
 * configured book for this company | Element containing Business Asset data to suspend an asset
 * @subpackage Structs
 */
class Suspend_Asset_Depreciation_for_WWS_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: The asset is part of a lease contract. You can't suspend depreciation on leased assets. | The Asset one would like to suspend depreciation for.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Suspend_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Suspend depreciation on or after this date is required for ALL requests. The response will contain the ‘Suspend From Date’ from the latest suspend schedule.
     * - maxOccurs: 1
     * @var string
     */
    public $Suspend_From_Date;
    /**
     * The Suspend_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Suspend depreciation on or before this date is required for ALL requests. The response will contain the ‘Suspend To Date’ from the latest suspend schedule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Suspend_To_Date;
    /**
     * The Restricted_To_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Asset Book(s) to record the asset depreciation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restricted_To_Books_Reference;
    /**
     * Constructor method for Suspend_Asset_Depreciation_for_WWS_DataType
     * @uses Suspend_Asset_Depreciation_for_WWS_DataType::setAsset_Reference()
     * @uses Suspend_Asset_Depreciation_for_WWS_DataType::setSuspend_From_Date()
     * @uses Suspend_Asset_Depreciation_for_WWS_DataType::setSuspend_To_Date()
     * @uses Suspend_Asset_Depreciation_for_WWS_DataType::setRestricted_To_Books_Reference()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $suspend_From_Date
     * @param string $suspend_To_Date
     * @param \StructType\Asset_BookObjectType[] $restricted_To_Books_Reference
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $suspend_From_Date = null, $suspend_To_Date = null, array $restricted_To_Books_Reference = array())
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setSuspend_From_Date($suspend_From_Date)
            ->setSuspend_To_Date($suspend_To_Date)
            ->setRestricted_To_Books_Reference($restricted_To_Books_Reference);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Suspend_Asset_Depreciation_for_WWS_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Suspend_From_Date value
     * @return string|null
     */
    public function getSuspend_From_Date()
    {
        return $this->Suspend_From_Date;
    }
    /**
     * Set Suspend_From_Date value
     * @param string $suspend_From_Date
     * @return \StructType\Suspend_Asset_Depreciation_for_WWS_DataType
     */
    public function setSuspend_From_Date($suspend_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($suspend_From_Date) && !is_string($suspend_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suspend_From_Date, true), gettype($suspend_From_Date)), __LINE__);
        }
        $this->Suspend_From_Date = $suspend_From_Date;
        return $this;
    }
    /**
     * Get Suspend_To_Date value
     * @return string|null
     */
    public function getSuspend_To_Date()
    {
        return $this->Suspend_To_Date;
    }
    /**
     * Set Suspend_To_Date value
     * @param string $suspend_To_Date
     * @return \StructType\Suspend_Asset_Depreciation_for_WWS_DataType
     */
    public function setSuspend_To_Date($suspend_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($suspend_To_Date) && !is_string($suspend_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suspend_To_Date, true), gettype($suspend_To_Date)), __LINE__);
        }
        $this->Suspend_To_Date = $suspend_To_Date;
        return $this;
    }
    /**
     * Get Restricted_To_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestricted_To_Books_Reference()
    {
        return $this->Restricted_To_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_To_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_To_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_To_Books_ReferenceForArrayConstraintsFromSetRestricted_To_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suspend_Asset_Depreciation_for_WWS_DataTypeRestricted_To_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$suspend_Asset_Depreciation_for_WWS_DataTypeRestricted_To_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($suspend_Asset_Depreciation_for_WWS_DataTypeRestricted_To_Books_ReferenceItem) ? get_class($suspend_Asset_Depreciation_for_WWS_DataTypeRestricted_To_Books_ReferenceItem) : sprintf('%s(%s)', gettype($suspend_Asset_Depreciation_for_WWS_DataTypeRestricted_To_Books_ReferenceItem), var_export($suspend_Asset_Depreciation_for_WWS_DataTypeRestricted_To_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_To_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_To_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restricted_To_Books_Reference
     * @return \StructType\Suspend_Asset_Depreciation_for_WWS_DataType
     */
    public function setRestricted_To_Books_Reference(array $restricted_To_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_To_Books_ReferenceArrayErrorMessage = self::validateRestricted_To_Books_ReferenceForArrayConstraintsFromSetRestricted_To_Books_Reference($restricted_To_Books_Reference))) {
            throw new \InvalidArgumentException($restricted_To_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_To_Books_Reference = $restricted_To_Books_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_To_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Suspend_Asset_Depreciation_for_WWS_DataType
     */
    public function addToRestricted_To_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_To_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_To_Books_Reference[] = $item;
        return $this;
    }
}
