<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_Inventory_Site_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Documentation Element that represents the contents of an inventory site requisition sourcing rule
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_Inventory_Site_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the inventory site sourcing rule
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these companies or company hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition Types that must match to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType[]
     */
    public $Requisition_Type_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these spend categories or spend category Hierarchies to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Suppliers that must match to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these Ship-To Addresses to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Ship_To_Address_Reference;
    /**
     * The Active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Active Deliver-To Locations or Location Hierarchies that must match to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Location_or_Location_HierarchyObjectType[]
     */
    public $Active_Location_or_Location_Hierarchy_for_Procurement_Reference;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Must match one of these purchase items to apply this rule. If empty, no match is required.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType[]
     */
    public $Purchase_Item_Reference;
    /**
     * The Use_Inventory_Distribution_Network
     * Meta information extracted from the WSDL
     * - documentation: If this is true, Inventory distribution network is required
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Inventory_Distribution_Network;
    /**
     * The Inventory_Distribution_Network_Reference
     * Meta information extracted from the WSDL
     * - documentation: If Use Inventory distribution network is true, then this is required
     * - minOccurs: 0
     * @var \StructType\Inventory_Distribution_NetworkObjectType
     */
    public $Inventory_Distribution_Network_Reference;
    /**
     * The Inventory_Site_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resulting inventory site to apply for requisition sourcing if criteria is matched.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Inventory_Site_Location_Reference;
    /**
     * The Resulting_Stock_Request_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resulting stock request type to apply for requisition sourcing if criteria is matched.
     * - minOccurs: 0
     * @var \StructType\Inventory_Stock_Request_TypeObjectType
     */
    public $Resulting_Stock_Request_Type_Reference;
    /**
     * Constructor method for Requisition_Sourcing_Rule_Inventory_Site_DataType
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setID()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setCompany_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setRequisition_Type_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setSpend_Category_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setSupplier_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setShip_To_Address_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setActive_Location_or_Location_Hierarchy_for_Procurement_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setPurchase_Item_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setUse_Inventory_Distribution_Network()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setInventory_Distribution_Network_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setInventory_Site_Location_Reference()
     * @uses Requisition_Sourcing_Rule_Inventory_Site_DataType::setResulting_Stock_Request_Type_Reference()
     * @param string $iD
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @param bool $use_Inventory_Distribution_Network
     * @param \StructType\Inventory_Distribution_NetworkObjectType $inventory_Distribution_Network_Reference
     * @param \StructType\LocationObjectType $inventory_Site_Location_Reference
     * @param \StructType\Inventory_Stock_Request_TypeObjectType $resulting_Stock_Request_Type_Reference
     */
    public function __construct($iD = null, array $company_Reference = array(), array $requisition_Type_Reference = array(), array $spend_Category_Reference = array(), array $supplier_Reference = array(), array $ship_To_Address_Reference = array(), array $active_Location_or_Location_Hierarchy_for_Procurement_Reference = array(), array $purchase_Item_Reference = array(), $use_Inventory_Distribution_Network = null, \StructType\Inventory_Distribution_NetworkObjectType $inventory_Distribution_Network_Reference = null, \StructType\LocationObjectType $inventory_Site_Location_Reference = null, \StructType\Inventory_Stock_Request_TypeObjectType $resulting_Stock_Request_Type_Reference = null)
    {
        $this
            ->setID($iD)
            ->setCompany_Reference($company_Reference)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setActive_Location_or_Location_Hierarchy_for_Procurement_Reference($active_Location_or_Location_Hierarchy_for_Procurement_Reference)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setUse_Inventory_Distribution_Network($use_Inventory_Distribution_Network)
            ->setInventory_Distribution_Network_Reference($inventory_Distribution_Network_Reference)
            ->setInventory_Site_Location_Reference($inventory_Site_Location_Reference)
            ->setResulting_Stock_Request_Type_Reference($resulting_Stock_Request_Type_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypeCompany_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypeCompany_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType[]|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypeRequisition_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypeRequisition_Type_ReferenceItem instanceof \StructType\Requisition_TypeObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypeRequisition_Type_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypeRequisition_Type_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypeRequisition_Type_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypeRequisition_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setRequisition_Type_Reference(array $requisition_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Type_ReferenceArrayErrorMessage = self::validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference($requisition_Type_Reference))) {
            throw new \InvalidArgumentException($requisition_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypeSpend_Category_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypeSpend_Category_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypeSupplier_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypeSupplier_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To_Address_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Address_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypeShip_To_Address_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypeShip_To_Address_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypeShip_To_Address_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypeShip_To_Address_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypeShip_To_Address_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypeShip_To_Address_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $ship_To_Address_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setShip_To_Address_Reference(array $ship_To_Address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_To_Address_ReferenceArrayErrorMessage = self::validateShip_To_Address_ReferenceForArrayConstraintsFromSetShip_To_Address_Reference($ship_To_Address_Reference))) {
            throw new \InvalidArgumentException($ship_To_Address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Add item to Ship_To_Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To_Address_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To_Address_Reference[] = $this->{'Ship-To_Address_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Active_Location_or_Location_Hierarchy_for_Procurement_Reference value
     * @return \StructType\Asset_Location_or_Location_HierarchyObjectType[]|null
     */
    public function getActive_Location_or_Location_Hierarchy_for_Procurement_Reference()
    {
        return $this->Active_Location_or_Location_Hierarchy_for_Procurement_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setActive_Location_or_Location_Hierarchy_for_Procurement_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActive_Location_or_Location_Hierarchy_for_Procurement_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceForArrayConstraintsFromSetActive_Location_or_Location_Hierarchy_for_Procurement_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypeActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Active_Location_or_Location_Hierarchy_for_Procurement_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Active_Location_or_Location_Hierarchy_for_Procurement_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setActive_Location_or_Location_Hierarchy_for_Procurement_Reference(array $active_Location_or_Location_Hierarchy_for_Procurement_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($active_Location_or_Location_Hierarchy_for_Procurement_ReferenceArrayErrorMessage = self::validateActive_Location_or_Location_Hierarchy_for_Procurement_ReferenceForArrayConstraintsFromSetActive_Location_or_Location_Hierarchy_for_Procurement_Reference($active_Location_or_Location_Hierarchy_for_Procurement_Reference))) {
            throw new \InvalidArgumentException($active_Location_or_Location_Hierarchy_for_Procurement_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Active_Location_or_Location_Hierarchy_for_Procurement_Reference = $active_Location_or_Location_Hierarchy_for_Procurement_Reference;
        return $this;
    }
    /**
     * Add item to Active_Location_or_Location_Hierarchy_for_Procurement_Reference
     * value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToActive_Location_or_Location_Hierarchy_for_Procurement_Reference(\StructType\Asset_Location_or_Location_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Active_Location_or_Location_Hierarchy_for_Procurement_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Active_Location_or_Location_Hierarchy_for_Procurement_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType[]|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Inventory_Site_DataTypePurchase_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Inventory_Site_DataTypePurchase_Item_ReferenceItem instanceof \StructType\Purchase_ItemObjectType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Inventory_Site_DataTypePurchase_Item_ReferenceItem) ? get_class($requisition_Sourcing_Rule_Inventory_Site_DataTypePurchase_Item_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Inventory_Site_DataTypePurchase_Item_ReferenceItem), var_export($requisition_Sourcing_Rule_Inventory_Site_DataTypePurchase_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setPurchase_Item_Reference(array $purchase_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_ReferenceArrayErrorMessage = self::validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference($purchase_Item_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType $item
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function addToPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Use_Inventory_Distribution_Network value
     * @return bool|null
     */
    public function getUse_Inventory_Distribution_Network()
    {
        return $this->Use_Inventory_Distribution_Network;
    }
    /**
     * Set Use_Inventory_Distribution_Network value
     * @param bool $use_Inventory_Distribution_Network
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setUse_Inventory_Distribution_Network($use_Inventory_Distribution_Network = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Inventory_Distribution_Network) && !is_bool($use_Inventory_Distribution_Network)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Inventory_Distribution_Network, true), gettype($use_Inventory_Distribution_Network)), __LINE__);
        }
        $this->Use_Inventory_Distribution_Network = $use_Inventory_Distribution_Network;
        return $this;
    }
    /**
     * Get Inventory_Distribution_Network_Reference value
     * @return \StructType\Inventory_Distribution_NetworkObjectType|null
     */
    public function getInventory_Distribution_Network_Reference()
    {
        return $this->Inventory_Distribution_Network_Reference;
    }
    /**
     * Set Inventory_Distribution_Network_Reference value
     * @param \StructType\Inventory_Distribution_NetworkObjectType $inventory_Distribution_Network_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setInventory_Distribution_Network_Reference(\StructType\Inventory_Distribution_NetworkObjectType $inventory_Distribution_Network_Reference = null)
    {
        $this->Inventory_Distribution_Network_Reference = $inventory_Distribution_Network_Reference;
        return $this;
    }
    /**
     * Get Inventory_Site_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getInventory_Site_Location_Reference()
    {
        return $this->Inventory_Site_Location_Reference;
    }
    /**
     * Set Inventory_Site_Location_Reference value
     * @param \StructType\LocationObjectType $inventory_Site_Location_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setInventory_Site_Location_Reference(\StructType\LocationObjectType $inventory_Site_Location_Reference = null)
    {
        $this->Inventory_Site_Location_Reference = $inventory_Site_Location_Reference;
        return $this;
    }
    /**
     * Get Resulting_Stock_Request_Type_Reference value
     * @return \StructType\Inventory_Stock_Request_TypeObjectType|null
     */
    public function getResulting_Stock_Request_Type_Reference()
    {
        return $this->Resulting_Stock_Request_Type_Reference;
    }
    /**
     * Set Resulting_Stock_Request_Type_Reference value
     * @param \StructType\Inventory_Stock_Request_TypeObjectType $resulting_Stock_Request_Type_Reference
     * @return \StructType\Requisition_Sourcing_Rule_Inventory_Site_DataType
     */
    public function setResulting_Stock_Request_Type_Reference(\StructType\Inventory_Stock_Request_TypeObjectType $resulting_Stock_Request_Type_Reference = null)
    {
        $this->Resulting_Stock_Request_Type_Reference = $resulting_Stock_Request_Type_Reference;
        return $this;
    }
}
