<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of the entire RFQ Award Document
 * @subpackage Structs
 */
class Request_for_Quote_Award_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Award_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for RFQ Response Document
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Award_ID;
    /**
     * The RFQ_Award_Number
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Award_Number;
    /**
     * The RFQ_Award_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Type Reference
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_TypeObjectType
     */
    public $RFQ_Award_Type_Reference;
    /**
     * The RFQ_Award_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Status Reference
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $RFQ_Award_Status_Reference;
    /**
     * The Approved_On_Date
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Approval Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved_On_Date;
    /**
     * The Awarded_Business_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order or Supplier Contract that the RFQ was awarded to
     * - minOccurs: 0
     * @var \StructType\Business_DocumentObjectType
     */
    public $Awarded_Business_Document_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company on RFQ Award
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Request_for_Quote_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ
     * - minOccurs: 0
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $Request_for_Quote_Reference;
    /**
     * The RFQ_Response_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ Response
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_ResponseObjectType
     */
    public $RFQ_Response_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier on RFQ Award
     * - minOccurs: 0
     * @var \StructType\Abstract_Request_for_Quote_ParticipantObjectType
     */
    public $Supplier_Reference;
    /**
     * The Sourcing_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Sourcing Buyer on RFQ Award
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Sourcing_Buyer_Reference;
    /**
     * The Award_Date
     * Meta information extracted from the WSDL
     * - documentation: Award Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Award_Date;
    /**
     * The Request_for_Quote_Award_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Award Reason for Request for Quote Award.
     * - minOccurs: 0
     * @var \StructType\Procurement_Award_ReasonObjectType
     */
    public $Request_for_Quote_Award_Reason_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency on RFQ Award
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Award Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Auto_submit_Award_Outcome_for_Approval
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether to submit the RFQ Award outcome document for approval
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_submit_Award_Outcome_for_Approval;
    /**
     * The RFQ_Award_PO_Defaults_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Award_PO_Defaults_DataType[]
     */
    public $RFQ_Award_PO_Defaults_Data;
    /**
     * The RFQ_Award_Contract_Defaults_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Award_Contract_Defaults_DataType[]
     */
    public $RFQ_Award_Contract_Defaults_Data;
    /**
     * The Request_for_Quote_Award_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures information related to RFQ Award Lines
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_Line_DataType[]
     */
    public $Request_for_Quote_Award_Line_Data;
    /**
     * The Business_Document_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Attachment_Data;
    /**
     * Constructor method for Request_for_Quote_Award_DataType
     * @uses Request_for_Quote_Award_DataType::setRequest_for_Quote_Award_ID()
     * @uses Request_for_Quote_Award_DataType::setRFQ_Award_Number()
     * @uses Request_for_Quote_Award_DataType::setRFQ_Award_Type_Reference()
     * @uses Request_for_Quote_Award_DataType::setRFQ_Award_Status_Reference()
     * @uses Request_for_Quote_Award_DataType::setApproved_On_Date()
     * @uses Request_for_Quote_Award_DataType::setAwarded_Business_Document_Reference()
     * @uses Request_for_Quote_Award_DataType::setCompany_Reference()
     * @uses Request_for_Quote_Award_DataType::setRequest_for_Quote_Reference()
     * @uses Request_for_Quote_Award_DataType::setRFQ_Response_Reference()
     * @uses Request_for_Quote_Award_DataType::setSupplier_Reference()
     * @uses Request_for_Quote_Award_DataType::setSourcing_Buyer_Reference()
     * @uses Request_for_Quote_Award_DataType::setAward_Date()
     * @uses Request_for_Quote_Award_DataType::setRequest_for_Quote_Award_Reason_Reference()
     * @uses Request_for_Quote_Award_DataType::setCurrency_Reference()
     * @uses Request_for_Quote_Award_DataType::setMemo()
     * @uses Request_for_Quote_Award_DataType::setAuto_submit_Award_Outcome_for_Approval()
     * @uses Request_for_Quote_Award_DataType::setRFQ_Award_PO_Defaults_Data()
     * @uses Request_for_Quote_Award_DataType::setRFQ_Award_Contract_Defaults_Data()
     * @uses Request_for_Quote_Award_DataType::setRequest_for_Quote_Award_Line_Data()
     * @uses Request_for_Quote_Award_DataType::setBusiness_Document_Attachment_Data()
     * @param string $request_for_Quote_Award_ID
     * @param string $rFQ_Award_Number
     * @param \StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference
     * @param \StructType\Document_StatusObjectType $rFQ_Award_Status_Reference
     * @param string $approved_On_Date
     * @param \StructType\Business_DocumentObjectType $awarded_Business_Document_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @param \StructType\Request_for_Quote_ResponseObjectType $rFQ_Response_Reference
     * @param \StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @param string $award_Date
     * @param \StructType\Procurement_Award_ReasonObjectType $request_for_Quote_Award_Reason_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $memo
     * @param bool $auto_submit_Award_Outcome_for_Approval
     * @param \StructType\RFQ_Award_PO_Defaults_DataType[] $rFQ_Award_PO_Defaults_Data
     * @param \StructType\RFQ_Award_Contract_Defaults_DataType[] $rFQ_Award_Contract_Defaults_Data
     * @param \StructType\Request_for_Quote_Award_Line_DataType[] $request_for_Quote_Award_Line_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     */
    public function __construct($request_for_Quote_Award_ID = null, $rFQ_Award_Number = null, \StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference = null, \StructType\Document_StatusObjectType $rFQ_Award_Status_Reference = null, $approved_On_Date = null, \StructType\Business_DocumentObjectType $awarded_Business_Document_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null, \StructType\Request_for_Quote_ResponseObjectType $rFQ_Response_Reference = null, \StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference = null, \StructType\WorkerObjectType $sourcing_Buyer_Reference = null, $award_Date = null, \StructType\Procurement_Award_ReasonObjectType $request_for_Quote_Award_Reason_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $memo = null, $auto_submit_Award_Outcome_for_Approval = null, array $rFQ_Award_PO_Defaults_Data = array(), array $rFQ_Award_Contract_Defaults_Data = array(), array $request_for_Quote_Award_Line_Data = array(), array $business_Document_Attachment_Data = array())
    {
        $this
            ->setRequest_for_Quote_Award_ID($request_for_Quote_Award_ID)
            ->setRFQ_Award_Number($rFQ_Award_Number)
            ->setRFQ_Award_Type_Reference($rFQ_Award_Type_Reference)
            ->setRFQ_Award_Status_Reference($rFQ_Award_Status_Reference)
            ->setApproved_On_Date($approved_On_Date)
            ->setAwarded_Business_Document_Reference($awarded_Business_Document_Reference)
            ->setCompany_Reference($company_Reference)
            ->setRequest_for_Quote_Reference($request_for_Quote_Reference)
            ->setRFQ_Response_Reference($rFQ_Response_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSourcing_Buyer_Reference($sourcing_Buyer_Reference)
            ->setAward_Date($award_Date)
            ->setRequest_for_Quote_Award_Reason_Reference($request_for_Quote_Award_Reason_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setMemo($memo)
            ->setAuto_submit_Award_Outcome_for_Approval($auto_submit_Award_Outcome_for_Approval)
            ->setRFQ_Award_PO_Defaults_Data($rFQ_Award_PO_Defaults_Data)
            ->setRFQ_Award_Contract_Defaults_Data($rFQ_Award_Contract_Defaults_Data)
            ->setRequest_for_Quote_Award_Line_Data($request_for_Quote_Award_Line_Data)
            ->setBusiness_Document_Attachment_Data($business_Document_Attachment_Data);
    }
    /**
     * Get Request_for_Quote_Award_ID value
     * @return string|null
     */
    public function getRequest_for_Quote_Award_ID()
    {
        return $this->Request_for_Quote_Award_ID;
    }
    /**
     * Set Request_for_Quote_Award_ID value
     * @param string $request_for_Quote_Award_ID
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRequest_for_Quote_Award_ID($request_for_Quote_Award_ID = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Award_ID) && !is_string($request_for_Quote_Award_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Award_ID, true), gettype($request_for_Quote_Award_ID)), __LINE__);
        }
        $this->Request_for_Quote_Award_ID = $request_for_Quote_Award_ID;
        return $this;
    }
    /**
     * Get RFQ_Award_Number value
     * @return string|null
     */
    public function getRFQ_Award_Number()
    {
        return $this->RFQ_Award_Number;
    }
    /**
     * Set RFQ_Award_Number value
     * @param string $rFQ_Award_Number
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRFQ_Award_Number($rFQ_Award_Number = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Award_Number) && !is_string($rFQ_Award_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Award_Number, true), gettype($rFQ_Award_Number)), __LINE__);
        }
        $this->RFQ_Award_Number = $rFQ_Award_Number;
        return $this;
    }
    /**
     * Get RFQ_Award_Type_Reference value
     * @return \StructType\Request_for_Quote_Award_TypeObjectType|null
     */
    public function getRFQ_Award_Type_Reference()
    {
        return $this->RFQ_Award_Type_Reference;
    }
    /**
     * Set RFQ_Award_Type_Reference value
     * @param \StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRFQ_Award_Type_Reference(\StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference = null)
    {
        $this->RFQ_Award_Type_Reference = $rFQ_Award_Type_Reference;
        return $this;
    }
    /**
     * Get RFQ_Award_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getRFQ_Award_Status_Reference()
    {
        return $this->RFQ_Award_Status_Reference;
    }
    /**
     * Set RFQ_Award_Status_Reference value
     * @param \StructType\Document_StatusObjectType $rFQ_Award_Status_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRFQ_Award_Status_Reference(\StructType\Document_StatusObjectType $rFQ_Award_Status_Reference = null)
    {
        $this->RFQ_Award_Status_Reference = $rFQ_Award_Status_Reference;
        return $this;
    }
    /**
     * Get Approved_On_Date value
     * @return string|null
     */
    public function getApproved_On_Date()
    {
        return $this->Approved_On_Date;
    }
    /**
     * Set Approved_On_Date value
     * @param string $approved_On_Date
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setApproved_On_Date($approved_On_Date = null)
    {
        // validation for constraint: string
        if (!is_null($approved_On_Date) && !is_string($approved_On_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved_On_Date, true), gettype($approved_On_Date)), __LINE__);
        }
        $this->Approved_On_Date = $approved_On_Date;
        return $this;
    }
    /**
     * Get Awarded_Business_Document_Reference value
     * @return \StructType\Business_DocumentObjectType|null
     */
    public function getAwarded_Business_Document_Reference()
    {
        return $this->Awarded_Business_Document_Reference;
    }
    /**
     * Set Awarded_Business_Document_Reference value
     * @param \StructType\Business_DocumentObjectType $awarded_Business_Document_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setAwarded_Business_Document_Reference(\StructType\Business_DocumentObjectType $awarded_Business_Document_Reference = null)
    {
        $this->Awarded_Business_Document_Reference = $awarded_Business_Document_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Request_for_Quote_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRequest_for_Quote_Reference()
    {
        return $this->Request_for_Quote_Reference;
    }
    /**
     * Set Request_for_Quote_Reference value
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRequest_for_Quote_Reference(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null)
    {
        $this->Request_for_Quote_Reference = $request_for_Quote_Reference;
        return $this;
    }
    /**
     * Get RFQ_Response_Reference value
     * @return \StructType\Request_for_Quote_ResponseObjectType|null
     */
    public function getRFQ_Response_Reference()
    {
        return $this->RFQ_Response_Reference;
    }
    /**
     * Set RFQ_Response_Reference value
     * @param \StructType\Request_for_Quote_ResponseObjectType $rFQ_Response_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRFQ_Response_Reference(\StructType\Request_for_Quote_ResponseObjectType $rFQ_Response_Reference = null)
    {
        $this->RFQ_Response_Reference = $rFQ_Response_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Abstract_Request_for_Quote_ParticipantObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setSupplier_Reference(\StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Sourcing_Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getSourcing_Buyer_Reference()
    {
        return $this->Sourcing_Buyer_Reference;
    }
    /**
     * Set Sourcing_Buyer_Reference value
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setSourcing_Buyer_Reference(\StructType\WorkerObjectType $sourcing_Buyer_Reference = null)
    {
        $this->Sourcing_Buyer_Reference = $sourcing_Buyer_Reference;
        return $this;
    }
    /**
     * Get Award_Date value
     * @return string|null
     */
    public function getAward_Date()
    {
        return $this->Award_Date;
    }
    /**
     * Set Award_Date value
     * @param string $award_Date
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setAward_Date($award_Date = null)
    {
        // validation for constraint: string
        if (!is_null($award_Date) && !is_string($award_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_Date, true), gettype($award_Date)), __LINE__);
        }
        $this->Award_Date = $award_Date;
        return $this;
    }
    /**
     * Get Request_for_Quote_Award_Reason_Reference value
     * @return \StructType\Procurement_Award_ReasonObjectType|null
     */
    public function getRequest_for_Quote_Award_Reason_Reference()
    {
        return $this->Request_for_Quote_Award_Reason_Reference;
    }
    /**
     * Set Request_for_Quote_Award_Reason_Reference value
     * @param \StructType\Procurement_Award_ReasonObjectType $request_for_Quote_Award_Reason_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRequest_for_Quote_Award_Reason_Reference(\StructType\Procurement_Award_ReasonObjectType $request_for_Quote_Award_Reason_Reference = null)
    {
        $this->Request_for_Quote_Award_Reason_Reference = $request_for_Quote_Award_Reason_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Auto_submit_Award_Outcome_for_Approval value
     * @return bool|null
     */
    public function getAuto_submit_Award_Outcome_for_Approval()
    {
        return $this->{'Auto-submit_Award_Outcome_for_Approval'};
    }
    /**
     * Set Auto_submit_Award_Outcome_for_Approval value
     * @param bool $auto_submit_Award_Outcome_for_Approval
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setAuto_submit_Award_Outcome_for_Approval($auto_submit_Award_Outcome_for_Approval = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_submit_Award_Outcome_for_Approval) && !is_bool($auto_submit_Award_Outcome_for_Approval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_submit_Award_Outcome_for_Approval, true), gettype($auto_submit_Award_Outcome_for_Approval)), __LINE__);
        }
        $this->Auto_submit_Award_Outcome_for_Approval = $this->{'Auto-submit_Award_Outcome_for_Approval'} = $auto_submit_Award_Outcome_for_Approval;
        return $this;
    }
    /**
     * Get RFQ_Award_PO_Defaults_Data value
     * @return \StructType\RFQ_Award_PO_Defaults_DataType[]|null
     */
    public function getRFQ_Award_PO_Defaults_Data()
    {
        return $this->RFQ_Award_PO_Defaults_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Award_PO_Defaults_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Award_PO_Defaults_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Award_PO_Defaults_DataForArrayConstraintsFromSetRFQ_Award_PO_Defaults_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_DataTypeRFQ_Award_PO_Defaults_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_DataTypeRFQ_Award_PO_Defaults_DataItem instanceof \StructType\RFQ_Award_PO_Defaults_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_DataTypeRFQ_Award_PO_Defaults_DataItem) ? get_class($request_for_Quote_Award_DataTypeRFQ_Award_PO_Defaults_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_DataTypeRFQ_Award_PO_Defaults_DataItem), var_export($request_for_Quote_Award_DataTypeRFQ_Award_PO_Defaults_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Award_PO_Defaults_Data property can only contain items of type \StructType\RFQ_Award_PO_Defaults_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Award_PO_Defaults_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Award_PO_Defaults_DataType[] $rFQ_Award_PO_Defaults_Data
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRFQ_Award_PO_Defaults_Data(array $rFQ_Award_PO_Defaults_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Award_PO_Defaults_DataArrayErrorMessage = self::validateRFQ_Award_PO_Defaults_DataForArrayConstraintsFromSetRFQ_Award_PO_Defaults_Data($rFQ_Award_PO_Defaults_Data))) {
            throw new \InvalidArgumentException($rFQ_Award_PO_Defaults_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Award_PO_Defaults_Data = $rFQ_Award_PO_Defaults_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Award_PO_Defaults_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Award_PO_Defaults_DataType $item
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function addToRFQ_Award_PO_Defaults_Data(\StructType\RFQ_Award_PO_Defaults_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Award_PO_Defaults_DataType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Award_PO_Defaults_Data property can only contain items of type \StructType\RFQ_Award_PO_Defaults_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Award_PO_Defaults_Data[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Award_Contract_Defaults_Data value
     * @return \StructType\RFQ_Award_Contract_Defaults_DataType[]|null
     */
    public function getRFQ_Award_Contract_Defaults_Data()
    {
        return $this->RFQ_Award_Contract_Defaults_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Award_Contract_Defaults_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Award_Contract_Defaults_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Award_Contract_Defaults_DataForArrayConstraintsFromSetRFQ_Award_Contract_Defaults_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_DataTypeRFQ_Award_Contract_Defaults_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_DataTypeRFQ_Award_Contract_Defaults_DataItem instanceof \StructType\RFQ_Award_Contract_Defaults_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_DataTypeRFQ_Award_Contract_Defaults_DataItem) ? get_class($request_for_Quote_Award_DataTypeRFQ_Award_Contract_Defaults_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_DataTypeRFQ_Award_Contract_Defaults_DataItem), var_export($request_for_Quote_Award_DataTypeRFQ_Award_Contract_Defaults_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Award_Contract_Defaults_Data property can only contain items of type \StructType\RFQ_Award_Contract_Defaults_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Award_Contract_Defaults_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Award_Contract_Defaults_DataType[] $rFQ_Award_Contract_Defaults_Data
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRFQ_Award_Contract_Defaults_Data(array $rFQ_Award_Contract_Defaults_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Award_Contract_Defaults_DataArrayErrorMessage = self::validateRFQ_Award_Contract_Defaults_DataForArrayConstraintsFromSetRFQ_Award_Contract_Defaults_Data($rFQ_Award_Contract_Defaults_Data))) {
            throw new \InvalidArgumentException($rFQ_Award_Contract_Defaults_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Award_Contract_Defaults_Data = $rFQ_Award_Contract_Defaults_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Award_Contract_Defaults_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Award_Contract_Defaults_DataType $item
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function addToRFQ_Award_Contract_Defaults_Data(\StructType\RFQ_Award_Contract_Defaults_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Award_Contract_Defaults_DataType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Award_Contract_Defaults_Data property can only contain items of type \StructType\RFQ_Award_Contract_Defaults_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Award_Contract_Defaults_Data[] = $item;
        return $this;
    }
    /**
     * Get Request_for_Quote_Award_Line_Data value
     * @return \StructType\Request_for_Quote_Award_Line_DataType[]|null
     */
    public function getRequest_for_Quote_Award_Line_Data()
    {
        return $this->Request_for_Quote_Award_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Award_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_DataTypeRequest_for_Quote_Award_Line_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_DataTypeRequest_for_Quote_Award_Line_DataItem instanceof \StructType\Request_for_Quote_Award_Line_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_DataTypeRequest_for_Quote_Award_Line_DataItem) ? get_class($request_for_Quote_Award_DataTypeRequest_for_Quote_Award_Line_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_DataTypeRequest_for_Quote_Award_Line_DataItem), var_export($request_for_Quote_Award_DataTypeRequest_for_Quote_Award_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award_Line_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_DataType[] $request_for_Quote_Award_Line_Data
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setRequest_for_Quote_Award_Line_Data(array $request_for_Quote_Award_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Award_Line_DataArrayErrorMessage = self::validateRequest_for_Quote_Award_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Data($request_for_Quote_Award_Line_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Award_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Data = $request_for_Quote_Award_Line_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_DataType $item
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function addToRequest_for_Quote_Award_Line_Data(\StructType\Request_for_Quote_Award_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Award_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award_Line_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Attachment_Data()
    {
        return $this->Business_Document_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_DataTypeBusiness_Document_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_DataTypeBusiness_Document_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_DataTypeBusiness_Document_Attachment_DataItem) ? get_class($request_for_Quote_Award_DataTypeBusiness_Document_Attachment_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_DataTypeBusiness_Document_Attachment_DataItem), var_export($request_for_Quote_Award_DataTypeBusiness_Document_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function setBusiness_Document_Attachment_Data(array $business_Document_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data($business_Document_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Attachment_Data = $business_Document_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Request_for_Quote_Award_DataType
     */
    public function addToBusiness_Document_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Attachment_Data[] = $item;
        return $this;
    }
}
