<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Renewal_Terms_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains renewal terms for supplier contracts
 * @subpackage Structs
 */
class Renewal_Terms_DataType extends AbstractStructBase
{
    /**
     * The Automatically_Renew
     * Meta information extracted from the WSDL
     * - documentation: Automatically Renew
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Renew;
    /**
     * The Send_Expiration_Notification
     * Meta information extracted from the WSDL
     * - documentation: Send Expiration Notification
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Send_Expiration_Notification;
    /**
     * The Notice_Period
     * Meta information extracted from the WSDL
     * - documentation: Notice Period
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Notice_Period;
    /**
     * The Notice_Period_Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Notice Period Frequency
     * - minOccurs: 0
     * @var \StructType\Unit_of_Time_for_ProcurementObjectType
     */
    public $Notice_Period_Frequency_Reference;
    /**
     * The Renewal_Term
     * Meta information extracted from the WSDL
     * - documentation: Renewal Term
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Renewal_Term;
    /**
     * The Renewal_Term_Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Renewal Term Frequency
     * - minOccurs: 0
     * @var \StructType\Unit_of_Time_for_ProcurementObjectType
     */
    public $Renewal_Term_Frequency_Reference;
    /**
     * Constructor method for Renewal_Terms_DataType
     * @uses Renewal_Terms_DataType::setAutomatically_Renew()
     * @uses Renewal_Terms_DataType::setSend_Expiration_Notification()
     * @uses Renewal_Terms_DataType::setNotice_Period()
     * @uses Renewal_Terms_DataType::setNotice_Period_Frequency_Reference()
     * @uses Renewal_Terms_DataType::setRenewal_Term()
     * @uses Renewal_Terms_DataType::setRenewal_Term_Frequency_Reference()
     * @param bool $automatically_Renew
     * @param bool $send_Expiration_Notification
     * @param float $notice_Period
     * @param \StructType\Unit_of_Time_for_ProcurementObjectType $notice_Period_Frequency_Reference
     * @param float $renewal_Term
     * @param \StructType\Unit_of_Time_for_ProcurementObjectType $renewal_Term_Frequency_Reference
     */
    public function __construct($automatically_Renew = null, $send_Expiration_Notification = null, $notice_Period = null, \StructType\Unit_of_Time_for_ProcurementObjectType $notice_Period_Frequency_Reference = null, $renewal_Term = null, \StructType\Unit_of_Time_for_ProcurementObjectType $renewal_Term_Frequency_Reference = null)
    {
        $this
            ->setAutomatically_Renew($automatically_Renew)
            ->setSend_Expiration_Notification($send_Expiration_Notification)
            ->setNotice_Period($notice_Period)
            ->setNotice_Period_Frequency_Reference($notice_Period_Frequency_Reference)
            ->setRenewal_Term($renewal_Term)
            ->setRenewal_Term_Frequency_Reference($renewal_Term_Frequency_Reference);
    }
    /**
     * Get Automatically_Renew value
     * @return bool|null
     */
    public function getAutomatically_Renew()
    {
        return $this->Automatically_Renew;
    }
    /**
     * Set Automatically_Renew value
     * @param bool $automatically_Renew
     * @return \StructType\Renewal_Terms_DataType
     */
    public function setAutomatically_Renew($automatically_Renew = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Renew) && !is_bool($automatically_Renew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Renew, true), gettype($automatically_Renew)), __LINE__);
        }
        $this->Automatically_Renew = $automatically_Renew;
        return $this;
    }
    /**
     * Get Send_Expiration_Notification value
     * @return bool|null
     */
    public function getSend_Expiration_Notification()
    {
        return $this->Send_Expiration_Notification;
    }
    /**
     * Set Send_Expiration_Notification value
     * @param bool $send_Expiration_Notification
     * @return \StructType\Renewal_Terms_DataType
     */
    public function setSend_Expiration_Notification($send_Expiration_Notification = null)
    {
        // validation for constraint: boolean
        if (!is_null($send_Expiration_Notification) && !is_bool($send_Expiration_Notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($send_Expiration_Notification, true), gettype($send_Expiration_Notification)), __LINE__);
        }
        $this->Send_Expiration_Notification = $send_Expiration_Notification;
        return $this;
    }
    /**
     * Get Notice_Period value
     * @return float|null
     */
    public function getNotice_Period()
    {
        return $this->Notice_Period;
    }
    /**
     * Set Notice_Period value
     * @param float $notice_Period
     * @return \StructType\Renewal_Terms_DataType
     */
    public function setNotice_Period($notice_Period = null)
    {
        // validation for constraint: float
        if (!is_null($notice_Period) && !(is_float($notice_Period) || is_numeric($notice_Period))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($notice_Period, true), gettype($notice_Period)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($notice_Period) && mb_strlen(mb_substr($notice_Period, false !== mb_strpos($notice_Period, '.') ? mb_strpos($notice_Period, '.') + 1 : mb_strlen($notice_Period))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($notice_Period, true), mb_strlen(mb_substr($notice_Period, mb_strpos($notice_Period, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($notice_Period) && $notice_Period < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($notice_Period, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($notice_Period) && mb_strlen(preg_replace('/(\D)/', '', $notice_Period)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($notice_Period, true), mb_strlen(preg_replace('/(\D)/', '', $notice_Period))), __LINE__);
        }
        $this->Notice_Period = $notice_Period;
        return $this;
    }
    /**
     * Get Notice_Period_Frequency_Reference value
     * @return \StructType\Unit_of_Time_for_ProcurementObjectType|null
     */
    public function getNotice_Period_Frequency_Reference()
    {
        return $this->Notice_Period_Frequency_Reference;
    }
    /**
     * Set Notice_Period_Frequency_Reference value
     * @param \StructType\Unit_of_Time_for_ProcurementObjectType $notice_Period_Frequency_Reference
     * @return \StructType\Renewal_Terms_DataType
     */
    public function setNotice_Period_Frequency_Reference(\StructType\Unit_of_Time_for_ProcurementObjectType $notice_Period_Frequency_Reference = null)
    {
        $this->Notice_Period_Frequency_Reference = $notice_Period_Frequency_Reference;
        return $this;
    }
    /**
     * Get Renewal_Term value
     * @return float|null
     */
    public function getRenewal_Term()
    {
        return $this->Renewal_Term;
    }
    /**
     * Set Renewal_Term value
     * @param float $renewal_Term
     * @return \StructType\Renewal_Terms_DataType
     */
    public function setRenewal_Term($renewal_Term = null)
    {
        // validation for constraint: float
        if (!is_null($renewal_Term) && !(is_float($renewal_Term) || is_numeric($renewal_Term))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($renewal_Term, true), gettype($renewal_Term)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($renewal_Term) && mb_strlen(mb_substr($renewal_Term, false !== mb_strpos($renewal_Term, '.') ? mb_strpos($renewal_Term, '.') + 1 : mb_strlen($renewal_Term))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($renewal_Term, true), mb_strlen(mb_substr($renewal_Term, mb_strpos($renewal_Term, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($renewal_Term) && $renewal_Term < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($renewal_Term, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($renewal_Term) && mb_strlen(preg_replace('/(\D)/', '', $renewal_Term)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($renewal_Term, true), mb_strlen(preg_replace('/(\D)/', '', $renewal_Term))), __LINE__);
        }
        $this->Renewal_Term = $renewal_Term;
        return $this;
    }
    /**
     * Get Renewal_Term_Frequency_Reference value
     * @return \StructType\Unit_of_Time_for_ProcurementObjectType|null
     */
    public function getRenewal_Term_Frequency_Reference()
    {
        return $this->Renewal_Term_Frequency_Reference;
    }
    /**
     * Set Renewal_Term_Frequency_Reference value
     * @param \StructType\Unit_of_Time_for_ProcurementObjectType $renewal_Term_Frequency_Reference
     * @return \StructType\Renewal_Terms_DataType
     */
    public function setRenewal_Term_Frequency_Reference(\StructType\Unit_of_Time_for_ProcurementObjectType $renewal_Term_Frequency_Reference = null)
    {
        $this->Renewal_Term_Frequency_Reference = $renewal_Term_Frequency_Reference;
        return $this;
    }
}
