<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Phase_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains project plan phase template information, such as project phase name, ID and task template data.
 * @subpackage Structs
 */
class Project_Plan_Phase_Template_DataType extends AbstractStructBase
{
    /**
     * The Plan_ID
     * Meta information extracted from the WSDL
     * - documentation: Contains a unique identifier for an instance of project plan phase.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Plan_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of project plan phase on the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Phase_Name_Data
     * Meta information extracted from the WSDL
     * - documentation: The project phase name for the project plan template.
     * - minOccurs: 0
     * @var \StructType\Project_Phase_Name_DataType
     */
    public $Phase_Name_Data;
    /**
     * The Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project phase reference for the project plan template.
     * - minOccurs: 0
     * @var \StructType\Project_PhaseObjectType
     */
    public $Phase_Reference;
    /**
     * The Task_Template_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains project plan task template information, such as project task name, ID, offset dates, milestone flag, etc.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Task_Template_DataType[]
     */
    public $Task_Template_Data;
    /**
     * Constructor method for Project_Plan_Phase_Template_DataType
     * @uses Project_Plan_Phase_Template_DataType::setPlan_ID()
     * @uses Project_Plan_Phase_Template_DataType::setOrder()
     * @uses Project_Plan_Phase_Template_DataType::setPhase_Name_Data()
     * @uses Project_Plan_Phase_Template_DataType::setPhase_Reference()
     * @uses Project_Plan_Phase_Template_DataType::setTask_Template_Data()
     * @param string $plan_ID
     * @param string $order
     * @param \StructType\Project_Phase_Name_DataType $phase_Name_Data
     * @param \StructType\Project_PhaseObjectType $phase_Reference
     * @param \StructType\Project_Plan_Task_Template_DataType[] $task_Template_Data
     */
    public function __construct($plan_ID = null, $order = null, \StructType\Project_Phase_Name_DataType $phase_Name_Data = null, \StructType\Project_PhaseObjectType $phase_Reference = null, array $task_Template_Data = array())
    {
        $this
            ->setPlan_ID($plan_ID)
            ->setOrder($order)
            ->setPhase_Name_Data($phase_Name_Data)
            ->setPhase_Reference($phase_Reference)
            ->setTask_Template_Data($task_Template_Data);
    }
    /**
     * Get Plan_ID value
     * @return string|null
     */
    public function getPlan_ID()
    {
        return $this->Plan_ID;
    }
    /**
     * Set Plan_ID value
     * @param string $plan_ID
     * @return \StructType\Project_Plan_Phase_Template_DataType
     */
    public function setPlan_ID($plan_ID = null)
    {
        // validation for constraint: string
        if (!is_null($plan_ID) && !is_string($plan_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plan_ID, true), gettype($plan_ID)), __LINE__);
        }
        $this->Plan_ID = $plan_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Project_Plan_Phase_Template_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Phase_Name_Data value
     * @return \StructType\Project_Phase_Name_DataType|null
     */
    public function getPhase_Name_Data()
    {
        return $this->Phase_Name_Data;
    }
    /**
     * Set Phase_Name_Data value
     * @param \StructType\Project_Phase_Name_DataType $phase_Name_Data
     * @return \StructType\Project_Plan_Phase_Template_DataType
     */
    public function setPhase_Name_Data(\StructType\Project_Phase_Name_DataType $phase_Name_Data = null)
    {
        $this->Phase_Name_Data = $phase_Name_Data;
        return $this;
    }
    /**
     * Get Phase_Reference value
     * @return \StructType\Project_PhaseObjectType|null
     */
    public function getPhase_Reference()
    {
        return $this->Phase_Reference;
    }
    /**
     * Set Phase_Reference value
     * @param \StructType\Project_PhaseObjectType $phase_Reference
     * @return \StructType\Project_Plan_Phase_Template_DataType
     */
    public function setPhase_Reference(\StructType\Project_PhaseObjectType $phase_Reference = null)
    {
        $this->Phase_Reference = $phase_Reference;
        return $this;
    }
    /**
     * Get Task_Template_Data value
     * @return \StructType\Project_Plan_Task_Template_DataType[]|null
     */
    public function getTask_Template_Data()
    {
        return $this->Task_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTask_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTask_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTask_Template_DataForArrayConstraintsFromSetTask_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Phase_Template_DataTypeTask_Template_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Phase_Template_DataTypeTask_Template_DataItem instanceof \StructType\Project_Plan_Task_Template_DataType) {
                $invalidValues[] = is_object($project_Plan_Phase_Template_DataTypeTask_Template_DataItem) ? get_class($project_Plan_Phase_Template_DataTypeTask_Template_DataItem) : sprintf('%s(%s)', gettype($project_Plan_Phase_Template_DataTypeTask_Template_DataItem), var_export($project_Plan_Phase_Template_DataTypeTask_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Task_Template_Data property can only contain items of type \StructType\Project_Plan_Task_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Task_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Task_Template_DataType[] $task_Template_Data
     * @return \StructType\Project_Plan_Phase_Template_DataType
     */
    public function setTask_Template_Data(array $task_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($task_Template_DataArrayErrorMessage = self::validateTask_Template_DataForArrayConstraintsFromSetTask_Template_Data($task_Template_Data))) {
            throw new \InvalidArgumentException($task_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Task_Template_Data = $task_Template_Data;
        return $this;
    }
    /**
     * Add item to Task_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Task_Template_DataType $item
     * @return \StructType\Project_Plan_Phase_Template_DataType
     */
    public function addToTask_Template_Data(\StructType\Project_Plan_Task_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Task_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Task_Template_Data property can only contain items of type \StructType\Project_Plan_Task_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Task_Template_Data[] = $item;
        return $this;
    }
}
