<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Line_Split_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Supplier Invoice Line Split must only reference Purchase Order Line Splits from the Purchase Order Line that is related to the current Supplier Invoice Line. | A Supplier Invoice Line Split must only reference Supplier Invoice Line
 * Splits from the Supplier Invoice Line to Adjust that is related to the current Supplier Invoice Line. | Encapsulating element containing Supplier Invoice Line Split data.
 * @subpackage Structs
 */
class Supplier_Invoice_Line_Split_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line_Split_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Line Split Reference. Not to be used on Submit WS, only for reference when using Get WS.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_SplitObjectType
     */
    public $Supplier_Invoice_Line_Split_Reference;
    /**
     * The Supplier_Invoice_Line_Split_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Line_Split_ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Split line. This is free form text.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Line_Split_Allocation_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order line split or Supplier Invoice Line Split to Adjust
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_SplitObjectType
     */
    public $Line_Split_Allocation_Reference;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date from the supplier invoice header.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: For supplier invoice line splits tagged with a capital project worktag, the company of the invoice line split must equal the company on the capital project. | You have chosen an invalid combination of header company, line company,
     * and intercompany affiliate. | Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Clear the prepaid or billable option for the line when Deferred Project Cost Accounting is configured. Only 1 of these options can apply to the supplier invoice line split. | The supplier invoice line split can't be marked as
     * Billable if the selected Worktag is not for a billable project | Billable Flag at Invoice Line Split Level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * Constructor method for Supplier_Invoice_Line_Split_DataType
     * @uses Supplier_Invoice_Line_Split_DataType::setSupplier_Invoice_Line_Split_Reference()
     * @uses Supplier_Invoice_Line_Split_DataType::setSupplier_Invoice_Line_Split_ID()
     * @uses Supplier_Invoice_Line_Split_DataType::setQuantity()
     * @uses Supplier_Invoice_Line_Split_DataType::setExtended_Amount()
     * @uses Supplier_Invoice_Line_Split_DataType::setMemo()
     * @uses Supplier_Invoice_Line_Split_DataType::setLine_Split_Allocation_Reference()
     * @uses Supplier_Invoice_Line_Split_DataType::setBudget_Date()
     * @uses Supplier_Invoice_Line_Split_DataType::setWorktag_Reference()
     * @uses Supplier_Invoice_Line_Split_DataType::setBillable()
     * @param \StructType\Supplier_Invoice_Line_SplitObjectType $supplier_Invoice_Line_Split_Reference
     * @param string $supplier_Invoice_Line_Split_ID
     * @param float $quantity
     * @param float $extended_Amount
     * @param string $memo
     * @param \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference
     * @param string $budget_Date
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param bool $billable
     */
    public function __construct(\StructType\Supplier_Invoice_Line_SplitObjectType $supplier_Invoice_Line_Split_Reference = null, $supplier_Invoice_Line_Split_ID = null, $quantity = null, $extended_Amount = null, $memo = null, \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference = null, $budget_Date = null, array $worktag_Reference = array(), $billable = null)
    {
        $this
            ->setSupplier_Invoice_Line_Split_Reference($supplier_Invoice_Line_Split_Reference)
            ->setSupplier_Invoice_Line_Split_ID($supplier_Invoice_Line_Split_ID)
            ->setQuantity($quantity)
            ->setExtended_Amount($extended_Amount)
            ->setMemo($memo)
            ->setLine_Split_Allocation_Reference($line_Split_Allocation_Reference)
            ->setBudget_Date($budget_Date)
            ->setWorktag_Reference($worktag_Reference)
            ->setBillable($billable);
    }
    /**
     * Get Supplier_Invoice_Line_Split_Reference value
     * @return \StructType\Supplier_Invoice_Line_SplitObjectType|null
     */
    public function getSupplier_Invoice_Line_Split_Reference()
    {
        return $this->Supplier_Invoice_Line_Split_Reference;
    }
    /**
     * Set Supplier_Invoice_Line_Split_Reference value
     * @param \StructType\Supplier_Invoice_Line_SplitObjectType $supplier_Invoice_Line_Split_Reference
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setSupplier_Invoice_Line_Split_Reference(\StructType\Supplier_Invoice_Line_SplitObjectType $supplier_Invoice_Line_Split_Reference = null)
    {
        $this->Supplier_Invoice_Line_Split_Reference = $supplier_Invoice_Line_Split_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Line_Split_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Line_Split_ID()
    {
        return $this->Supplier_Invoice_Line_Split_ID;
    }
    /**
     * Set Supplier_Invoice_Line_Split_ID value
     * @param string $supplier_Invoice_Line_Split_ID
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setSupplier_Invoice_Line_Split_ID($supplier_Invoice_Line_Split_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Line_Split_ID) && !is_string($supplier_Invoice_Line_Split_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Line_Split_ID, true), gettype($supplier_Invoice_Line_Split_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Line_Split_ID = $supplier_Invoice_Line_Split_ID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Line_Split_Allocation_Reference value
     * @return \StructType\Business_Document_Line_SplitObjectType|null
     */
    public function getLine_Split_Allocation_Reference()
    {
        return $this->Line_Split_Allocation_Reference;
    }
    /**
     * Set Line_Split_Allocation_Reference value
     * @param \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setLine_Split_Allocation_Reference(\StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference = null)
    {
        $this->Line_Split_Allocation_Reference = $line_Split_Allocation_Reference;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Line_Split_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Line_Split_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Line_Split_DataTypeWorktag_ReferenceItem) ? get_class($supplier_Invoice_Line_Split_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Line_Split_DataTypeWorktag_ReferenceItem), var_export($supplier_Invoice_Line_Split_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Supplier_Invoice_Line_Split_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
}
