<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Document_Link_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Invoice Document Link Text Data
 * @subpackage Structs
 */
class Supplier_Invoice_Document_Link_DataType extends AbstractStructBase
{
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Enter a valid URL or update link types on the Maintain External Link validation task. Links must have a valid Uniform Resource Identifier (URI) pattern defined by your security administrator. | Document Link
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * Constructor method for Supplier_Invoice_Document_Link_DataType
     * @uses Supplier_Invoice_Document_Link_DataType::setDocument_Link()
     * @param string $document_Link
     */
    public function __construct($document_Link = null)
    {
        $this
            ->setDocument_Link($document_Link);
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Supplier_Invoice_Document_Link_DataType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
}
