<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing references instance for a Receipt Adjustment
 * @subpackage Structs
 */
class Receipt_Adjustment_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Receipt_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receipt Adjustment.
     * - maxOccurs: unbounded
     * @var \StructType\Receipt_AdjustmentObjectType[]
     */
    public $Receipt_Adjustment_Reference;
    /**
     * Constructor method for Receipt_Adjustment_Request_ReferencesType
     * @uses Receipt_Adjustment_Request_ReferencesType::setReceipt_Adjustment_Reference()
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     */
    public function __construct(array $receipt_Adjustment_Reference = array())
    {
        $this
            ->setReceipt_Adjustment_Reference($receipt_Adjustment_Reference);
    }
    /**
     * Get Receipt_Adjustment_Reference value
     * @return \StructType\Receipt_AdjustmentObjectType[]|null
     */
    public function getReceipt_Adjustment_Reference()
    {
        return $this->Receipt_Adjustment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Adjustment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Adjustment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Request_ReferencesTypeReceipt_Adjustment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Request_ReferencesTypeReceipt_Adjustment_ReferenceItem instanceof \StructType\Receipt_AdjustmentObjectType) {
                $invalidValues[] = is_object($receipt_Adjustment_Request_ReferencesTypeReceipt_Adjustment_ReferenceItem) ? get_class($receipt_Adjustment_Request_ReferencesTypeReceipt_Adjustment_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Request_ReferencesTypeReceipt_Adjustment_ReferenceItem), var_export($receipt_Adjustment_Request_ReferencesTypeReceipt_Adjustment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @return \StructType\Receipt_Adjustment_Request_ReferencesType
     */
    public function setReceipt_Adjustment_Reference(array $receipt_Adjustment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Adjustment_ReferenceArrayErrorMessage = self::validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference($receipt_Adjustment_Reference))) {
            throw new \InvalidArgumentException($receipt_Adjustment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Adjustment_Reference = $receipt_Adjustment_Reference;
        return $this;
    }
    /**
     * Add item to Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType $item
     * @return \StructType\Receipt_Adjustment_Request_ReferencesType
     */
    public function addToReceipt_Adjustment_Reference(\StructType\Receipt_AdjustmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_AdjustmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Adjustment_Reference[] = $item;
        return $this;
    }
}
