<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Header_or_Line_Bid_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures header and line level bid responses on RFQ Response Document.
 * @subpackage Structs
 */
class RFQ_Header_or_Line_Bid_Response_DataType extends AbstractStructBase
{
    /**
     * The RFQ_Bid_Response_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Bid response.
     * - minOccurs: 0
     * @var \StructType\Abstract_Request_for_Quote_Bid_ResponseObjectType
     */
    public $RFQ_Bid_Response_Reference;
    /**
     * The RFQ_Bid_Requirement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the original bid requirement recorded on RFQ.
     * - minOccurs: 0
     * @var \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType
     */
    public $RFQ_Bid_Requirement_Reference;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Bid Requirement Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Bid Requirement Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Response_Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether a response is required on this bid requirement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Response_Required;
    /**
     * The Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bid Requirement Type
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType
     */
    public $Type_Reference;
    /**
     * The Response_Value
     * Meta information extracted from the WSDL
     * - documentation: Bid Response Value recorded against bid requirement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Value;
    /**
     * The Request_for_Quote_Bid_Response_Memo
     * Meta information extracted from the WSDL
     * - documentation: Bid Response Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Bid_Response_Memo;
    /**
     * Constructor method for RFQ_Header_or_Line_Bid_Response_DataType
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setRFQ_Bid_Response_Reference()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setRFQ_Bid_Requirement_Reference()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setName()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setMemo()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setResponse_Required()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setType_Reference()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setResponse_Value()
     * @uses RFQ_Header_or_Line_Bid_Response_DataType::setRequest_for_Quote_Bid_Response_Memo()
     * @param \StructType\Abstract_Request_for_Quote_Bid_ResponseObjectType $rFQ_Bid_Response_Reference
     * @param \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference
     * @param string $name
     * @param string $memo
     * @param bool $response_Required
     * @param \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference
     * @param string $response_Value
     * @param string $request_for_Quote_Bid_Response_Memo
     */
    public function __construct(\StructType\Abstract_Request_for_Quote_Bid_ResponseObjectType $rFQ_Bid_Response_Reference = null, \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference = null, $name = null, $memo = null, $response_Required = null, \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference = null, $response_Value = null, $request_for_Quote_Bid_Response_Memo = null)
    {
        $this
            ->setRFQ_Bid_Response_Reference($rFQ_Bid_Response_Reference)
            ->setRFQ_Bid_Requirement_Reference($rFQ_Bid_Requirement_Reference)
            ->setName($name)
            ->setMemo($memo)
            ->setResponse_Required($response_Required)
            ->setType_Reference($type_Reference)
            ->setResponse_Value($response_Value)
            ->setRequest_for_Quote_Bid_Response_Memo($request_for_Quote_Bid_Response_Memo);
    }
    /**
     * Get RFQ_Bid_Response_Reference value
     * @return \StructType\Abstract_Request_for_Quote_Bid_ResponseObjectType|null
     */
    public function getRFQ_Bid_Response_Reference()
    {
        return $this->RFQ_Bid_Response_Reference;
    }
    /**
     * Set RFQ_Bid_Response_Reference value
     * @param \StructType\Abstract_Request_for_Quote_Bid_ResponseObjectType $rFQ_Bid_Response_Reference
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setRFQ_Bid_Response_Reference(\StructType\Abstract_Request_for_Quote_Bid_ResponseObjectType $rFQ_Bid_Response_Reference = null)
    {
        $this->RFQ_Bid_Response_Reference = $rFQ_Bid_Response_Reference;
        return $this;
    }
    /**
     * Get RFQ_Bid_Requirement_Reference value
     * @return \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType|null
     */
    public function getRFQ_Bid_Requirement_Reference()
    {
        return $this->RFQ_Bid_Requirement_Reference;
    }
    /**
     * Set RFQ_Bid_Requirement_Reference value
     * @param \StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setRFQ_Bid_Requirement_Reference(\StructType\Abstract_Request_for_Quote_Bid_RequirementObjectType $rFQ_Bid_Requirement_Reference = null)
    {
        $this->RFQ_Bid_Requirement_Reference = $rFQ_Bid_Requirement_Reference;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Response_Required value
     * @return bool|null
     */
    public function getResponse_Required()
    {
        return $this->Response_Required;
    }
    /**
     * Set Response_Required value
     * @param bool $response_Required
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setResponse_Required($response_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($response_Required) && !is_bool($response_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($response_Required, true), gettype($response_Required)), __LINE__);
        }
        $this->Response_Required = $response_Required;
        return $this;
    }
    /**
     * Get Type_Reference value
     * @return \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType|null
     */
    public function getType_Reference()
    {
        return $this->Type_Reference;
    }
    /**
     * Set Type_Reference value
     * @param \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setType_Reference(\StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference = null)
    {
        $this->Type_Reference = $type_Reference;
        return $this;
    }
    /**
     * Get Response_Value value
     * @return string|null
     */
    public function getResponse_Value()
    {
        return $this->Response_Value;
    }
    /**
     * Set Response_Value value
     * @param string $response_Value
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setResponse_Value($response_Value = null)
    {
        // validation for constraint: string
        if (!is_null($response_Value) && !is_string($response_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Value, true), gettype($response_Value)), __LINE__);
        }
        $this->Response_Value = $response_Value;
        return $this;
    }
    /**
     * Get Request_for_Quote_Bid_Response_Memo value
     * @return string|null
     */
    public function getRequest_for_Quote_Bid_Response_Memo()
    {
        return $this->Request_for_Quote_Bid_Response_Memo;
    }
    /**
     * Set Request_for_Quote_Bid_Response_Memo value
     * @param string $request_for_Quote_Bid_Response_Memo
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType
     */
    public function setRequest_for_Quote_Bid_Response_Memo($request_for_Quote_Bid_Response_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Bid_Response_Memo) && !is_string($request_for_Quote_Bid_Response_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Bid_Response_Memo, true), gettype($request_for_Quote_Bid_Response_Memo)), __LINE__);
        }
        $this->Request_for_Quote_Bid_Response_Memo = $request_for_Quote_Bid_Response_Memo;
        return $this;
    }
}
