<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Internal_Catalog_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Catalog already has catalog items loaded, only the Catalog Name can be updated. | Create a new Internal Catalog, or change 'Add Only' to 'false' to edit the Internal Catalog. | Element containing Internal Catalog reference
 * Internal Catalog data.
 * @subpackage Structs
 */
class Put_Internal_Catalog_RequestType extends AbstractStructBase
{
    /**
     * The Internal_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Internal Catalog.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_CatalogObjectType
     */
    public $Internal_Catalog_Reference;
    /**
     * The Internal_Catalog_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Internal Catalog data.
     * - minOccurs: 0
     * @var \StructType\Internal_Catalog_DataType
     */
    public $Internal_Catalog_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Internal_Catalog_RequestType
     * @uses Put_Internal_Catalog_RequestType::setInternal_Catalog_Reference()
     * @uses Put_Internal_Catalog_RequestType::setInternal_Catalog_Data()
     * @uses Put_Internal_Catalog_RequestType::setAdd_Only()
     * @uses Put_Internal_Catalog_RequestType::setVersion()
     * @param \StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference
     * @param \StructType\Internal_Catalog_DataType $internal_Catalog_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference = null, \StructType\Internal_Catalog_DataType $internal_Catalog_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setInternal_Catalog_Reference($internal_Catalog_Reference)
            ->setInternal_Catalog_Data($internal_Catalog_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Internal_Catalog_Reference value
     * @return \StructType\Internal_Service_CatalogObjectType|null
     */
    public function getInternal_Catalog_Reference()
    {
        return $this->Internal_Catalog_Reference;
    }
    /**
     * Set Internal_Catalog_Reference value
     * @param \StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference
     * @return \StructType\Put_Internal_Catalog_RequestType
     */
    public function setInternal_Catalog_Reference(\StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference = null)
    {
        $this->Internal_Catalog_Reference = $internal_Catalog_Reference;
        return $this;
    }
    /**
     * Get Internal_Catalog_Data value
     * @return \StructType\Internal_Catalog_DataType|null
     */
    public function getInternal_Catalog_Data()
    {
        return $this->Internal_Catalog_Data;
    }
    /**
     * Set Internal_Catalog_Data value
     * @param \StructType\Internal_Catalog_DataType $internal_Catalog_Data
     * @return \StructType\Put_Internal_Catalog_RequestType
     */
    public function setInternal_Catalog_Data(\StructType\Internal_Catalog_DataType $internal_Catalog_Data = null)
    {
        $this->Internal_Catalog_Data = $internal_Catalog_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Internal_Catalog_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Internal_Catalog_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
