<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Worker_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer wrapper element that contains the Continget Worker data elements that are included in the response
 * @subpackage Structs
 */
class Contingent_Worker_Response_DataType extends AbstractStructBase
{
    /**
     * The Contingent_Worker
     * Meta information extracted from the WSDL
     * - documentation: Element storing information from Contingent Worker
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Contingent_Worker_WWSType[]
     */
    public $Contingent_Worker;
    /**
     * Constructor method for Contingent_Worker_Response_DataType
     * @uses Contingent_Worker_Response_DataType::setContingent_Worker()
     * @param \StructType\Contingent_Worker_WWSType[] $contingent_Worker
     */
    public function __construct(array $contingent_Worker = array())
    {
        $this
            ->setContingent_Worker($contingent_Worker);
    }
    /**
     * Get Contingent_Worker value
     * @return \StructType\Contingent_Worker_WWSType[]|null
     */
    public function getContingent_Worker()
    {
        return $this->Contingent_Worker;
    }
    /**
     * This method is responsible for validating the values passed to the setContingent_Worker method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContingent_Worker method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContingent_WorkerForArrayConstraintsFromSetContingent_Worker(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Response_DataTypeContingent_WorkerItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Response_DataTypeContingent_WorkerItem instanceof \StructType\Contingent_Worker_WWSType) {
                $invalidValues[] = is_object($contingent_Worker_Response_DataTypeContingent_WorkerItem) ? get_class($contingent_Worker_Response_DataTypeContingent_WorkerItem) : sprintf('%s(%s)', gettype($contingent_Worker_Response_DataTypeContingent_WorkerItem), var_export($contingent_Worker_Response_DataTypeContingent_WorkerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contingent_Worker property can only contain items of type \StructType\Contingent_Worker_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contingent_Worker value
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_Worker_WWSType[] $contingent_Worker
     * @return \StructType\Contingent_Worker_Response_DataType
     */
    public function setContingent_Worker(array $contingent_Worker = array())
    {
        // validation for constraint: array
        if ('' !== ($contingent_WorkerArrayErrorMessage = self::validateContingent_WorkerForArrayConstraintsFromSetContingent_Worker($contingent_Worker))) {
            throw new \InvalidArgumentException($contingent_WorkerArrayErrorMessage, __LINE__);
        }
        $this->Contingent_Worker = $contingent_Worker;
        return $this;
    }
    /**
     * Add item to Contingent_Worker value
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_Worker_WWSType $item
     * @return \StructType\Contingent_Worker_Response_DataType
     */
    public function addToContingent_Worker(\StructType\Contingent_Worker_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contingent_Worker_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Contingent_Worker property can only contain items of type \StructType\Contingent_Worker_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contingent_Worker[] = $item;
        return $this;
    }
}
