<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_CityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Travel City Instance and Data
 * @subpackage Structs
 */
class Travel_CityType extends AbstractStructBase
{
    /**
     * The Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel City Reference
     * - minOccurs: 0
     * @var \StructType\Travel_CityObjectType
     */
    public $Travel_City_Reference;
    /**
     * The Travel_City_Data
     * Meta information extracted from the WSDL
     * - documentation: Travel City Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_City_DataType[]
     */
    public $Travel_City_Data;
    /**
     * Constructor method for Travel_CityType
     * @uses Travel_CityType::setTravel_City_Reference()
     * @uses Travel_CityType::setTravel_City_Data()
     * @param \StructType\Travel_CityObjectType $travel_City_Reference
     * @param \StructType\Travel_City_DataType[] $travel_City_Data
     */
    public function __construct(\StructType\Travel_CityObjectType $travel_City_Reference = null, array $travel_City_Data = array())
    {
        $this
            ->setTravel_City_Reference($travel_City_Reference)
            ->setTravel_City_Data($travel_City_Data);
    }
    /**
     * Get Travel_City_Reference value
     * @return \StructType\Travel_CityObjectType|null
     */
    public function getTravel_City_Reference()
    {
        return $this->Travel_City_Reference;
    }
    /**
     * Set Travel_City_Reference value
     * @param \StructType\Travel_CityObjectType $travel_City_Reference
     * @return \StructType\Travel_CityType
     */
    public function setTravel_City_Reference(\StructType\Travel_CityObjectType $travel_City_Reference = null)
    {
        $this->Travel_City_Reference = $travel_City_Reference;
        return $this;
    }
    /**
     * Get Travel_City_Data value
     * @return \StructType\Travel_City_DataType[]|null
     */
    public function getTravel_City_Data()
    {
        return $this->Travel_City_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_City_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_City_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_City_DataForArrayConstraintsFromSetTravel_City_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_CityTypeTravel_City_DataItem) {
            // validation for constraint: itemType
            if (!$travel_CityTypeTravel_City_DataItem instanceof \StructType\Travel_City_DataType) {
                $invalidValues[] = is_object($travel_CityTypeTravel_City_DataItem) ? get_class($travel_CityTypeTravel_City_DataItem) : sprintf('%s(%s)', gettype($travel_CityTypeTravel_City_DataItem), var_export($travel_CityTypeTravel_City_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_City_Data property can only contain items of type \StructType\Travel_City_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_City_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_City_DataType[] $travel_City_Data
     * @return \StructType\Travel_CityType
     */
    public function setTravel_City_Data(array $travel_City_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_City_DataArrayErrorMessage = self::validateTravel_City_DataForArrayConstraintsFromSetTravel_City_Data($travel_City_Data))) {
            throw new \InvalidArgumentException($travel_City_DataArrayErrorMessage, __LINE__);
        }
        $this->Travel_City_Data = $travel_City_Data;
        return $this;
    }
    /**
     * Add item to Travel_City_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_City_DataType $item
     * @return \StructType\Travel_CityType
     */
    public function addToTravel_City_Data(\StructType\Travel_City_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_City_DataType) {
            throw new \InvalidArgumentException(sprintf('The Travel_City_Data property can only contain items of type \StructType\Travel_City_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_City_Data[] = $item;
        return $this;
    }
}
