<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_Record_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Booking Record Data.
 * @subpackage Structs
 */
class Travel_Booking_Record_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record ID. This is the Travel Booking Record unique identifier.
     * - maxOccurs: 1
     * @var string
     */
    public $ID;
    /**
     * The Employee_ID
     * Meta information extracted from the WSDL
     * - documentation: This is the unique identifier of the Employee that is associated with the Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Employee_ID;
    /**
     * The Accountholder_Name
     * Meta information extracted from the WSDL
     * - documentation: Accountholder name with the Travel Management Company.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accountholder_Name;
    /**
     * The Traveler_Name
     * Meta information extracted from the WSDL
     * - documentation: Traveler Name for the Itinerary.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Traveler_Name;
    /**
     * The Booking_Date
     * Meta information extracted from the WSDL
     * - documentation: Date of this Travel Booking Record event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Booking_Date;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company of the Employee on the Travel Booking Record
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Travel_Booking_Record_Closed
     * Meta information extracted from the WSDL
     * - documentation: Import travel booking records as a closed expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Travel_Booking_Record_Closed;
    /**
     * The Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Ticket Number on Travel Booking Record
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Number;
    /**
     * The Original_Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Original Ticket Number on Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Original_Ticket_Number;
    /**
     * The Reissued_Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Reissued Ticket Number on Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reissued_Ticket_Number;
    /**
     * The Travel_Provider
     * Meta information extracted from the WSDL
     * - documentation: Identifying name of the Travel management provider.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Provider;
    /**
     * The Itinerary_Number
     * Meta information extracted from the WSDL
     * - documentation: Itinerary description from the Travel Management Provider.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Itinerary_Number;
    /**
     * The Itinerary_Description
     * Meta information extracted from the WSDL
     * - documentation: Itinerary description from the Travel Management Provider.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Itinerary_Description;
    /**
     * The Reservation_Number
     * Meta information extracted from the WSDL
     * - documentation: Reservation number provided for this Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reservation_Number;
    /**
     * The Travel_Record_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Type of the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_Record_TypeObjectType
     */
    public $Travel_Record_Type_Reference;
    /**
     * The Booking_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Booking Status of Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Booking_StatusObjectType
     */
    public $Booking_Status_Reference;
    /**
     * The Fare_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The fare categories available for use on travel booking records.
     * - minOccurs: 0
     * @var \StructType\Fare_CategoryObjectType
     */
    public $Fare_Category_Reference;
    /**
     * The Ticket_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ticket type that's on the travel booking record. The type of fare determines the ticket type - a one-way, round-trip, or multi-destination fare.
     * - minOccurs: 0
     * @var \StructType\Ticket_TypeObjectType
     */
    public $Ticket_Type_Reference;
    /**
     * The Location_Code_Destination
     * Meta information extracted from the WSDL
     * - documentation: Destination Location Code for Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location_Code_Destination;
    /**
     * The Location_Code_Origin
     * Meta information extracted from the WSDL
     * - documentation: Origination Location Code for Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Location_Code_Origin;
    /**
     * The Travel_Route
     * Meta information extracted from the WSDL
     * - documentation: Concatenate codes for this route, with each code representing a destination on the trip and separated by a dash. Example: For airports, SFO-ORD-GRR-DEN-SFO.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Route;
    /**
     * The Class_Of_Service_Reference
     * Meta information extracted from the WSDL
     * - documentation: Class Of Service for Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Class_of_ServiceObjectType
     */
    public $Class_Of_Service_Reference;
    /**
     * The Purchased
     * Meta information extracted from the WSDL
     * - documentation: Purchase Status of Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Purchased;
    /**
     * The Purchase_Date
     * Meta information extracted from the WSDL
     * - documentation: Purchase Date of Travel Booking.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Date;
    /**
     * The Source_Base_Fare_Amount
     * Meta information extracted from the WSDL
     * - documentation: Identifies the value of the ticket in source currency. If a pre-existing credit has been applied at time of booking, then the extended amount may be different from the ticket value.Populated for Travel Type Air, Rail, and Other only.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Source_Base_Fare_Amount;
    /**
     * The Transaction_Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total amount for this Travel Booking item in source currency. Includes the Tax amount. This may be a refund amount or Fees.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Transaction_Extended_Amount;
    /**
     * The Source_Total_Amount
     * Meta information extracted from the WSDL
     * - documentation: The total amount paid for the Travel Booking Record, including base fare, tax, fees, and ancillaries.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Source_Total_Amount;
    /**
     * The Source_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Source Currency for Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Source_Currency_Reference;
    /**
     * The Source_Lowest_Logical_Amount
     * Meta information extracted from the WSDL
     * - documentation: Identifies the lowest logical fare for the identified Travel Booking booking in Source Currency.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 32
     * @var float
     */
    public $Source_Lowest_Logical_Amount;
    /**
     * The Last_4_Digits_of_Credit_Card_Number
     * Meta information extracted from the WSDL
     * - documentation: Last 4 Digits of Credit Card Number for the Expense Credit Card | Last four digits of the card number used for Travel Booking. | Expense Credit Card Number Last 4 Digits.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_4_Digits_of_Credit_Card_Number;
    /**
     * The Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Card Transaction Reference Number if Booking Item is prepaid.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Transaction_Reference;
    /**
     * The Destination_City
     * Meta information extracted from the WSDL
     * - documentation: Destination City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_City;
    /**
     * The Destination_State
     * Meta information extracted from the WSDL
     * - documentation: Destination State
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_State;
    /**
     * The Destination_Country
     * Meta information extracted from the WSDL
     * - documentation: Destination Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_Country;
    /**
     * The Origination_City
     * Meta information extracted from the WSDL
     * - documentation: Origination City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_City;
    /**
     * The Origination_State
     * Meta information extracted from the WSDL
     * - documentation: Origination State
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_State;
    /**
     * The Origination_Country
     * Meta information extracted from the WSDL
     * - documentation: Origination Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_Country;
    /**
     * The Merchant_Code
     * Meta information extracted from the WSDL
     * - documentation: Merchant Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Code;
    /**
     * The Merchant_Name
     * Meta information extracted from the WSDL
     * - documentation: Merchant Name for Travel Booking.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Name;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking related Start Date. Example : Air: Departure Date, Hotel: Check in Date, Car Rental: Pick up Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Related End Date. Example: Air: Return Date, Hotel: Check Out Date, Car Rental: Return Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Source_Daily_Amount
     * Meta information extracted from the WSDL
     * - documentation: Source Daily Amount.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Source_Daily_Amount;
    /**
     * The Travel_Policy_Code
     * Meta information extracted from the WSDL
     * - documentation: Travel Policy Code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Policy_Code;
    /**
     * The Policy_Description
     * Meta information extracted from the WSDL
     * - documentation: Travel Policy Description.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Policy_Description;
    /**
     * The Travel_Booking_Record_Name_Match_Data
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record Name Match Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_Record_Name_Match_DataType[]
     */
    public $Travel_Booking_Record_Name_Match_Data;
    /**
     * Constructor method for Travel_Booking_Record_DataType
     * @uses Travel_Booking_Record_DataType::setID()
     * @uses Travel_Booking_Record_DataType::setEmployee_ID()
     * @uses Travel_Booking_Record_DataType::setAccountholder_Name()
     * @uses Travel_Booking_Record_DataType::setTraveler_Name()
     * @uses Travel_Booking_Record_DataType::setBooking_Date()
     * @uses Travel_Booking_Record_DataType::setCompany_Reference()
     * @uses Travel_Booking_Record_DataType::setTravel_Booking_Record_Closed()
     * @uses Travel_Booking_Record_DataType::setTicket_Number()
     * @uses Travel_Booking_Record_DataType::setOriginal_Ticket_Number()
     * @uses Travel_Booking_Record_DataType::setReissued_Ticket_Number()
     * @uses Travel_Booking_Record_DataType::setTravel_Provider()
     * @uses Travel_Booking_Record_DataType::setItinerary_Number()
     * @uses Travel_Booking_Record_DataType::setItinerary_Description()
     * @uses Travel_Booking_Record_DataType::setReservation_Number()
     * @uses Travel_Booking_Record_DataType::setTravel_Record_Type_Reference()
     * @uses Travel_Booking_Record_DataType::setBooking_Status_Reference()
     * @uses Travel_Booking_Record_DataType::setFare_Category_Reference()
     * @uses Travel_Booking_Record_DataType::setTicket_Type_Reference()
     * @uses Travel_Booking_Record_DataType::setLocation_Code_Destination()
     * @uses Travel_Booking_Record_DataType::setLocation_Code_Origin()
     * @uses Travel_Booking_Record_DataType::setTravel_Route()
     * @uses Travel_Booking_Record_DataType::setClass_Of_Service_Reference()
     * @uses Travel_Booking_Record_DataType::setPurchased()
     * @uses Travel_Booking_Record_DataType::setPurchase_Date()
     * @uses Travel_Booking_Record_DataType::setSource_Base_Fare_Amount()
     * @uses Travel_Booking_Record_DataType::setTransaction_Extended_Amount()
     * @uses Travel_Booking_Record_DataType::setSource_Total_Amount()
     * @uses Travel_Booking_Record_DataType::setSource_Currency_Reference()
     * @uses Travel_Booking_Record_DataType::setSource_Lowest_Logical_Amount()
     * @uses Travel_Booking_Record_DataType::setLast_4_Digits_of_Credit_Card_Number()
     * @uses Travel_Booking_Record_DataType::setCredit_Card_Transaction_Reference()
     * @uses Travel_Booking_Record_DataType::setDestination_City()
     * @uses Travel_Booking_Record_DataType::setDestination_State()
     * @uses Travel_Booking_Record_DataType::setDestination_Country()
     * @uses Travel_Booking_Record_DataType::setOrigination_City()
     * @uses Travel_Booking_Record_DataType::setOrigination_State()
     * @uses Travel_Booking_Record_DataType::setOrigination_Country()
     * @uses Travel_Booking_Record_DataType::setMerchant_Code()
     * @uses Travel_Booking_Record_DataType::setMerchant_Name()
     * @uses Travel_Booking_Record_DataType::setStart_Date()
     * @uses Travel_Booking_Record_DataType::setEnd_Date()
     * @uses Travel_Booking_Record_DataType::setSource_Daily_Amount()
     * @uses Travel_Booking_Record_DataType::setTravel_Policy_Code()
     * @uses Travel_Booking_Record_DataType::setPolicy_Description()
     * @uses Travel_Booking_Record_DataType::setTravel_Booking_Record_Name_Match_Data()
     * @param string $iD
     * @param string $employee_ID
     * @param string $accountholder_Name
     * @param string $traveler_Name
     * @param string $booking_Date
     * @param \StructType\CompanyObjectType $company_Reference
     * @param bool $travel_Booking_Record_Closed
     * @param string $ticket_Number
     * @param string $original_Ticket_Number
     * @param string $reissued_Ticket_Number
     * @param string $travel_Provider
     * @param string $itinerary_Number
     * @param string $itinerary_Description
     * @param string $reservation_Number
     * @param \StructType\Travel_Booking_Record_TypeObjectType $travel_Record_Type_Reference
     * @param \StructType\Booking_StatusObjectType $booking_Status_Reference
     * @param \StructType\Fare_CategoryObjectType $fare_Category_Reference
     * @param \StructType\Ticket_TypeObjectType $ticket_Type_Reference
     * @param string $location_Code_Destination
     * @param string $location_Code_Origin
     * @param string $travel_Route
     * @param \StructType\Class_of_ServiceObjectType $class_Of_Service_Reference
     * @param bool $purchased
     * @param string $purchase_Date
     * @param float $source_Base_Fare_Amount
     * @param float $transaction_Extended_Amount
     * @param float $source_Total_Amount
     * @param \StructType\CurrencyObjectType $source_Currency_Reference
     * @param float $source_Lowest_Logical_Amount
     * @param string $last_4_Digits_of_Credit_Card_Number
     * @param string $credit_Card_Transaction_Reference
     * @param string $destination_City
     * @param string $destination_State
     * @param string $destination_Country
     * @param string $origination_City
     * @param string $origination_State
     * @param string $origination_Country
     * @param string $merchant_Code
     * @param string $merchant_Name
     * @param string $start_Date
     * @param string $end_Date
     * @param float $source_Daily_Amount
     * @param string $travel_Policy_Code
     * @param string $policy_Description
     * @param \StructType\Travel_Booking_Record_Name_Match_DataType[] $travel_Booking_Record_Name_Match_Data
     */
    public function __construct($iD = null, $employee_ID = null, $accountholder_Name = null, $traveler_Name = null, $booking_Date = null, \StructType\CompanyObjectType $company_Reference = null, $travel_Booking_Record_Closed = null, $ticket_Number = null, $original_Ticket_Number = null, $reissued_Ticket_Number = null, $travel_Provider = null, $itinerary_Number = null, $itinerary_Description = null, $reservation_Number = null, \StructType\Travel_Booking_Record_TypeObjectType $travel_Record_Type_Reference = null, \StructType\Booking_StatusObjectType $booking_Status_Reference = null, \StructType\Fare_CategoryObjectType $fare_Category_Reference = null, \StructType\Ticket_TypeObjectType $ticket_Type_Reference = null, $location_Code_Destination = null, $location_Code_Origin = null, $travel_Route = null, \StructType\Class_of_ServiceObjectType $class_Of_Service_Reference = null, $purchased = null, $purchase_Date = null, $source_Base_Fare_Amount = null, $transaction_Extended_Amount = null, $source_Total_Amount = null, \StructType\CurrencyObjectType $source_Currency_Reference = null, $source_Lowest_Logical_Amount = null, $last_4_Digits_of_Credit_Card_Number = null, $credit_Card_Transaction_Reference = null, $destination_City = null, $destination_State = null, $destination_Country = null, $origination_City = null, $origination_State = null, $origination_Country = null, $merchant_Code = null, $merchant_Name = null, $start_Date = null, $end_Date = null, $source_Daily_Amount = null, $travel_Policy_Code = null, $policy_Description = null, array $travel_Booking_Record_Name_Match_Data = array())
    {
        $this
            ->setID($iD)
            ->setEmployee_ID($employee_ID)
            ->setAccountholder_Name($accountholder_Name)
            ->setTraveler_Name($traveler_Name)
            ->setBooking_Date($booking_Date)
            ->setCompany_Reference($company_Reference)
            ->setTravel_Booking_Record_Closed($travel_Booking_Record_Closed)
            ->setTicket_Number($ticket_Number)
            ->setOriginal_Ticket_Number($original_Ticket_Number)
            ->setReissued_Ticket_Number($reissued_Ticket_Number)
            ->setTravel_Provider($travel_Provider)
            ->setItinerary_Number($itinerary_Number)
            ->setItinerary_Description($itinerary_Description)
            ->setReservation_Number($reservation_Number)
            ->setTravel_Record_Type_Reference($travel_Record_Type_Reference)
            ->setBooking_Status_Reference($booking_Status_Reference)
            ->setFare_Category_Reference($fare_Category_Reference)
            ->setTicket_Type_Reference($ticket_Type_Reference)
            ->setLocation_Code_Destination($location_Code_Destination)
            ->setLocation_Code_Origin($location_Code_Origin)
            ->setTravel_Route($travel_Route)
            ->setClass_Of_Service_Reference($class_Of_Service_Reference)
            ->setPurchased($purchased)
            ->setPurchase_Date($purchase_Date)
            ->setSource_Base_Fare_Amount($source_Base_Fare_Amount)
            ->setTransaction_Extended_Amount($transaction_Extended_Amount)
            ->setSource_Total_Amount($source_Total_Amount)
            ->setSource_Currency_Reference($source_Currency_Reference)
            ->setSource_Lowest_Logical_Amount($source_Lowest_Logical_Amount)
            ->setLast_4_Digits_of_Credit_Card_Number($last_4_Digits_of_Credit_Card_Number)
            ->setCredit_Card_Transaction_Reference($credit_Card_Transaction_Reference)
            ->setDestination_City($destination_City)
            ->setDestination_State($destination_State)
            ->setDestination_Country($destination_Country)
            ->setOrigination_City($origination_City)
            ->setOrigination_State($origination_State)
            ->setOrigination_Country($origination_Country)
            ->setMerchant_Code($merchant_Code)
            ->setMerchant_Name($merchant_Name)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setSource_Daily_Amount($source_Daily_Amount)
            ->setTravel_Policy_Code($travel_Policy_Code)
            ->setPolicy_Description($policy_Description)
            ->setTravel_Booking_Record_Name_Match_Data($travel_Booking_Record_Name_Match_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Employee_ID value
     * @return string|null
     */
    public function getEmployee_ID()
    {
        return $this->Employee_ID;
    }
    /**
     * Set Employee_ID value
     * @param string $employee_ID
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setEmployee_ID($employee_ID = null)
    {
        // validation for constraint: string
        if (!is_null($employee_ID) && !is_string($employee_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employee_ID, true), gettype($employee_ID)), __LINE__);
        }
        $this->Employee_ID = $employee_ID;
        return $this;
    }
    /**
     * Get Accountholder_Name value
     * @return string|null
     */
    public function getAccountholder_Name()
    {
        return $this->Accountholder_Name;
    }
    /**
     * Set Accountholder_Name value
     * @param string $accountholder_Name
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setAccountholder_Name($accountholder_Name = null)
    {
        // validation for constraint: string
        if (!is_null($accountholder_Name) && !is_string($accountholder_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountholder_Name, true), gettype($accountholder_Name)), __LINE__);
        }
        $this->Accountholder_Name = $accountholder_Name;
        return $this;
    }
    /**
     * Get Traveler_Name value
     * @return string|null
     */
    public function getTraveler_Name()
    {
        return $this->Traveler_Name;
    }
    /**
     * Set Traveler_Name value
     * @param string $traveler_Name
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTraveler_Name($traveler_Name = null)
    {
        // validation for constraint: string
        if (!is_null($traveler_Name) && !is_string($traveler_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traveler_Name, true), gettype($traveler_Name)), __LINE__);
        }
        $this->Traveler_Name = $traveler_Name;
        return $this;
    }
    /**
     * Get Booking_Date value
     * @return string|null
     */
    public function getBooking_Date()
    {
        return $this->Booking_Date;
    }
    /**
     * Set Booking_Date value
     * @param string $booking_Date
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setBooking_Date($booking_Date = null)
    {
        // validation for constraint: string
        if (!is_null($booking_Date) && !is_string($booking_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($booking_Date, true), gettype($booking_Date)), __LINE__);
        }
        $this->Booking_Date = $booking_Date;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Travel_Booking_Record_Closed value
     * @return bool|null
     */
    public function getTravel_Booking_Record_Closed()
    {
        return $this->Travel_Booking_Record_Closed;
    }
    /**
     * Set Travel_Booking_Record_Closed value
     * @param bool $travel_Booking_Record_Closed
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTravel_Booking_Record_Closed($travel_Booking_Record_Closed = null)
    {
        // validation for constraint: boolean
        if (!is_null($travel_Booking_Record_Closed) && !is_bool($travel_Booking_Record_Closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($travel_Booking_Record_Closed, true), gettype($travel_Booking_Record_Closed)), __LINE__);
        }
        $this->Travel_Booking_Record_Closed = $travel_Booking_Record_Closed;
        return $this;
    }
    /**
     * Get Ticket_Number value
     * @return string|null
     */
    public function getTicket_Number()
    {
        return $this->Ticket_Number;
    }
    /**
     * Set Ticket_Number value
     * @param string $ticket_Number
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTicket_Number($ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Number) && !is_string($ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Number, true), gettype($ticket_Number)), __LINE__);
        }
        $this->Ticket_Number = $ticket_Number;
        return $this;
    }
    /**
     * Get Original_Ticket_Number value
     * @return string|null
     */
    public function getOriginal_Ticket_Number()
    {
        return $this->Original_Ticket_Number;
    }
    /**
     * Set Original_Ticket_Number value
     * @param string $original_Ticket_Number
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setOriginal_Ticket_Number($original_Ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($original_Ticket_Number) && !is_string($original_Ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($original_Ticket_Number, true), gettype($original_Ticket_Number)), __LINE__);
        }
        $this->Original_Ticket_Number = $original_Ticket_Number;
        return $this;
    }
    /**
     * Get Reissued_Ticket_Number value
     * @return string|null
     */
    public function getReissued_Ticket_Number()
    {
        return $this->Reissued_Ticket_Number;
    }
    /**
     * Set Reissued_Ticket_Number value
     * @param string $reissued_Ticket_Number
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setReissued_Ticket_Number($reissued_Ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($reissued_Ticket_Number) && !is_string($reissued_Ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reissued_Ticket_Number, true), gettype($reissued_Ticket_Number)), __LINE__);
        }
        $this->Reissued_Ticket_Number = $reissued_Ticket_Number;
        return $this;
    }
    /**
     * Get Travel_Provider value
     * @return string|null
     */
    public function getTravel_Provider()
    {
        return $this->Travel_Provider;
    }
    /**
     * Set Travel_Provider value
     * @param string $travel_Provider
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTravel_Provider($travel_Provider = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Provider) && !is_string($travel_Provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Provider, true), gettype($travel_Provider)), __LINE__);
        }
        $this->Travel_Provider = $travel_Provider;
        return $this;
    }
    /**
     * Get Itinerary_Number value
     * @return string|null
     */
    public function getItinerary_Number()
    {
        return $this->Itinerary_Number;
    }
    /**
     * Set Itinerary_Number value
     * @param string $itinerary_Number
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setItinerary_Number($itinerary_Number = null)
    {
        // validation for constraint: string
        if (!is_null($itinerary_Number) && !is_string($itinerary_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itinerary_Number, true), gettype($itinerary_Number)), __LINE__);
        }
        $this->Itinerary_Number = $itinerary_Number;
        return $this;
    }
    /**
     * Get Itinerary_Description value
     * @return string|null
     */
    public function getItinerary_Description()
    {
        return $this->Itinerary_Description;
    }
    /**
     * Set Itinerary_Description value
     * @param string $itinerary_Description
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setItinerary_Description($itinerary_Description = null)
    {
        // validation for constraint: string
        if (!is_null($itinerary_Description) && !is_string($itinerary_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itinerary_Description, true), gettype($itinerary_Description)), __LINE__);
        }
        $this->Itinerary_Description = $itinerary_Description;
        return $this;
    }
    /**
     * Get Reservation_Number value
     * @return string|null
     */
    public function getReservation_Number()
    {
        return $this->Reservation_Number;
    }
    /**
     * Set Reservation_Number value
     * @param string $reservation_Number
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setReservation_Number($reservation_Number = null)
    {
        // validation for constraint: string
        if (!is_null($reservation_Number) && !is_string($reservation_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservation_Number, true), gettype($reservation_Number)), __LINE__);
        }
        $this->Reservation_Number = $reservation_Number;
        return $this;
    }
    /**
     * Get Travel_Record_Type_Reference value
     * @return \StructType\Travel_Booking_Record_TypeObjectType|null
     */
    public function getTravel_Record_Type_Reference()
    {
        return $this->Travel_Record_Type_Reference;
    }
    /**
     * Set Travel_Record_Type_Reference value
     * @param \StructType\Travel_Booking_Record_TypeObjectType $travel_Record_Type_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTravel_Record_Type_Reference(\StructType\Travel_Booking_Record_TypeObjectType $travel_Record_Type_Reference = null)
    {
        $this->Travel_Record_Type_Reference = $travel_Record_Type_Reference;
        return $this;
    }
    /**
     * Get Booking_Status_Reference value
     * @return \StructType\Booking_StatusObjectType|null
     */
    public function getBooking_Status_Reference()
    {
        return $this->Booking_Status_Reference;
    }
    /**
     * Set Booking_Status_Reference value
     * @param \StructType\Booking_StatusObjectType $booking_Status_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setBooking_Status_Reference(\StructType\Booking_StatusObjectType $booking_Status_Reference = null)
    {
        $this->Booking_Status_Reference = $booking_Status_Reference;
        return $this;
    }
    /**
     * Get Fare_Category_Reference value
     * @return \StructType\Fare_CategoryObjectType|null
     */
    public function getFare_Category_Reference()
    {
        return $this->Fare_Category_Reference;
    }
    /**
     * Set Fare_Category_Reference value
     * @param \StructType\Fare_CategoryObjectType $fare_Category_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setFare_Category_Reference(\StructType\Fare_CategoryObjectType $fare_Category_Reference = null)
    {
        $this->Fare_Category_Reference = $fare_Category_Reference;
        return $this;
    }
    /**
     * Get Ticket_Type_Reference value
     * @return \StructType\Ticket_TypeObjectType|null
     */
    public function getTicket_Type_Reference()
    {
        return $this->Ticket_Type_Reference;
    }
    /**
     * Set Ticket_Type_Reference value
     * @param \StructType\Ticket_TypeObjectType $ticket_Type_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTicket_Type_Reference(\StructType\Ticket_TypeObjectType $ticket_Type_Reference = null)
    {
        $this->Ticket_Type_Reference = $ticket_Type_Reference;
        return $this;
    }
    /**
     * Get Location_Code_Destination value
     * @return string|null
     */
    public function getLocation_Code_Destination()
    {
        return $this->Location_Code_Destination;
    }
    /**
     * Set Location_Code_Destination value
     * @param string $location_Code_Destination
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setLocation_Code_Destination($location_Code_Destination = null)
    {
        // validation for constraint: string
        if (!is_null($location_Code_Destination) && !is_string($location_Code_Destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location_Code_Destination, true), gettype($location_Code_Destination)), __LINE__);
        }
        $this->Location_Code_Destination = $location_Code_Destination;
        return $this;
    }
    /**
     * Get Location_Code_Origin value
     * @return string|null
     */
    public function getLocation_Code_Origin()
    {
        return $this->Location_Code_Origin;
    }
    /**
     * Set Location_Code_Origin value
     * @param string $location_Code_Origin
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setLocation_Code_Origin($location_Code_Origin = null)
    {
        // validation for constraint: string
        if (!is_null($location_Code_Origin) && !is_string($location_Code_Origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location_Code_Origin, true), gettype($location_Code_Origin)), __LINE__);
        }
        $this->Location_Code_Origin = $location_Code_Origin;
        return $this;
    }
    /**
     * Get Travel_Route value
     * @return string|null
     */
    public function getTravel_Route()
    {
        return $this->Travel_Route;
    }
    /**
     * Set Travel_Route value
     * @param string $travel_Route
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTravel_Route($travel_Route = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Route) && !is_string($travel_Route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Route, true), gettype($travel_Route)), __LINE__);
        }
        $this->Travel_Route = $travel_Route;
        return $this;
    }
    /**
     * Get Class_Of_Service_Reference value
     * @return \StructType\Class_of_ServiceObjectType|null
     */
    public function getClass_Of_Service_Reference()
    {
        return $this->Class_Of_Service_Reference;
    }
    /**
     * Set Class_Of_Service_Reference value
     * @param \StructType\Class_of_ServiceObjectType $class_Of_Service_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setClass_Of_Service_Reference(\StructType\Class_of_ServiceObjectType $class_Of_Service_Reference = null)
    {
        $this->Class_Of_Service_Reference = $class_Of_Service_Reference;
        return $this;
    }
    /**
     * Get Purchased value
     * @return bool|null
     */
    public function getPurchased()
    {
        return $this->Purchased;
    }
    /**
     * Set Purchased value
     * @param bool $purchased
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setPurchased($purchased = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchased) && !is_bool($purchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchased, true), gettype($purchased)), __LINE__);
        }
        $this->Purchased = $purchased;
        return $this;
    }
    /**
     * Get Purchase_Date value
     * @return string|null
     */
    public function getPurchase_Date()
    {
        return $this->Purchase_Date;
    }
    /**
     * Set Purchase_Date value
     * @param string $purchase_Date
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setPurchase_Date($purchase_Date = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Date) && !is_string($purchase_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Date, true), gettype($purchase_Date)), __LINE__);
        }
        $this->Purchase_Date = $purchase_Date;
        return $this;
    }
    /**
     * Get Source_Base_Fare_Amount value
     * @return float|null
     */
    public function getSource_Base_Fare_Amount()
    {
        return $this->Source_Base_Fare_Amount;
    }
    /**
     * Set Source_Base_Fare_Amount value
     * @param float $source_Base_Fare_Amount
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setSource_Base_Fare_Amount($source_Base_Fare_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($source_Base_Fare_Amount) && !(is_float($source_Base_Fare_Amount) || is_numeric($source_Base_Fare_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($source_Base_Fare_Amount, true), gettype($source_Base_Fare_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($source_Base_Fare_Amount) && mb_strlen(mb_substr($source_Base_Fare_Amount, false !== mb_strpos($source_Base_Fare_Amount, '.') ? mb_strpos($source_Base_Fare_Amount, '.') + 1 : mb_strlen($source_Base_Fare_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($source_Base_Fare_Amount, true), mb_strlen(mb_substr($source_Base_Fare_Amount, mb_strpos($source_Base_Fare_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($source_Base_Fare_Amount) && mb_strlen(preg_replace('/(\D)/', '', $source_Base_Fare_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($source_Base_Fare_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $source_Base_Fare_Amount))), __LINE__);
        }
        $this->Source_Base_Fare_Amount = $source_Base_Fare_Amount;
        return $this;
    }
    /**
     * Get Transaction_Extended_Amount value
     * @return float|null
     */
    public function getTransaction_Extended_Amount()
    {
        return $this->Transaction_Extended_Amount;
    }
    /**
     * Set Transaction_Extended_Amount value
     * @param float $transaction_Extended_Amount
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTransaction_Extended_Amount($transaction_Extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($transaction_Extended_Amount) && !(is_float($transaction_Extended_Amount) || is_numeric($transaction_Extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transaction_Extended_Amount, true), gettype($transaction_Extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($transaction_Extended_Amount) && mb_strlen(mb_substr($transaction_Extended_Amount, false !== mb_strpos($transaction_Extended_Amount, '.') ? mb_strpos($transaction_Extended_Amount, '.') + 1 : mb_strlen($transaction_Extended_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($transaction_Extended_Amount, true), mb_strlen(mb_substr($transaction_Extended_Amount, mb_strpos($transaction_Extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($transaction_Extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $transaction_Extended_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($transaction_Extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $transaction_Extended_Amount))), __LINE__);
        }
        $this->Transaction_Extended_Amount = $transaction_Extended_Amount;
        return $this;
    }
    /**
     * Get Source_Total_Amount value
     * @return float|null
     */
    public function getSource_Total_Amount()
    {
        return $this->Source_Total_Amount;
    }
    /**
     * Set Source_Total_Amount value
     * @param float $source_Total_Amount
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setSource_Total_Amount($source_Total_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($source_Total_Amount) && !(is_float($source_Total_Amount) || is_numeric($source_Total_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($source_Total_Amount, true), gettype($source_Total_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($source_Total_Amount) && mb_strlen(mb_substr($source_Total_Amount, false !== mb_strpos($source_Total_Amount, '.') ? mb_strpos($source_Total_Amount, '.') + 1 : mb_strlen($source_Total_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($source_Total_Amount, true), mb_strlen(mb_substr($source_Total_Amount, mb_strpos($source_Total_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($source_Total_Amount) && mb_strlen(preg_replace('/(\D)/', '', $source_Total_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($source_Total_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $source_Total_Amount))), __LINE__);
        }
        $this->Source_Total_Amount = $source_Total_Amount;
        return $this;
    }
    /**
     * Get Source_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getSource_Currency_Reference()
    {
        return $this->Source_Currency_Reference;
    }
    /**
     * Set Source_Currency_Reference value
     * @param \StructType\CurrencyObjectType $source_Currency_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setSource_Currency_Reference(\StructType\CurrencyObjectType $source_Currency_Reference = null)
    {
        $this->Source_Currency_Reference = $source_Currency_Reference;
        return $this;
    }
    /**
     * Get Source_Lowest_Logical_Amount value
     * @return float|null
     */
    public function getSource_Lowest_Logical_Amount()
    {
        return $this->Source_Lowest_Logical_Amount;
    }
    /**
     * Set Source_Lowest_Logical_Amount value
     * @param float $source_Lowest_Logical_Amount
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setSource_Lowest_Logical_Amount($source_Lowest_Logical_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($source_Lowest_Logical_Amount) && !(is_float($source_Lowest_Logical_Amount) || is_numeric($source_Lowest_Logical_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($source_Lowest_Logical_Amount, true), gettype($source_Lowest_Logical_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($source_Lowest_Logical_Amount) && mb_strlen(mb_substr($source_Lowest_Logical_Amount, false !== mb_strpos($source_Lowest_Logical_Amount, '.') ? mb_strpos($source_Lowest_Logical_Amount, '.') + 1 : mb_strlen($source_Lowest_Logical_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($source_Lowest_Logical_Amount, true), mb_strlen(mb_substr($source_Lowest_Logical_Amount, mb_strpos($source_Lowest_Logical_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($source_Lowest_Logical_Amount) && $source_Lowest_Logical_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($source_Lowest_Logical_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(32)
        if (!is_null($source_Lowest_Logical_Amount) && mb_strlen(preg_replace('/(\D)/', '', $source_Lowest_Logical_Amount)) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 32 digits, "%d" given', var_export($source_Lowest_Logical_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $source_Lowest_Logical_Amount))), __LINE__);
        }
        $this->Source_Lowest_Logical_Amount = $source_Lowest_Logical_Amount;
        return $this;
    }
    /**
     * Get last_Digits_of_Credit_Card_Number value
     * @return last_Digits_of_Credit_Card_Number
     */
    public function getLast_4_Digits_of_Credit_Card_Number()
    {
        return $this->Last_4_Digits_of_Credit_Card_Number;
    }
    /**
     * Set last_Digits_of_Credit_Card_Number value
     * @param last_Digits_of_Credit_Card_Number $last_Digits_of_Credit_Card_Number
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setLast_4_Digits_of_Credit_Card_Number($last_4_Digits_of_Credit_Card_Number = null)
    {
        // validation for constraint: string
        if (!is_null($last_4_Digits_of_Credit_Card_Number) && !is_string($last_4_Digits_of_Credit_Card_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_4_Digits_of_Credit_Card_Number, true), gettype($last_4_Digits_of_Credit_Card_Number)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($last_4_Digits_of_Credit_Card_Number) && mb_strlen($last_4_Digits_of_Credit_Card_Number) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($last_4_Digits_of_Credit_Card_Number)), __LINE__);
        }
        $this->Last_4_Digits_of_Credit_Card_Number = $last_4_Digits_of_Credit_Card_Number;
        return $this;
    }
    /**
     * Get Credit_Card_Transaction_Reference value
     * @return string|null
     */
    public function getCredit_Card_Transaction_Reference()
    {
        return $this->Credit_Card_Transaction_Reference;
    }
    /**
     * Set Credit_Card_Transaction_Reference value
     * @param string $credit_Card_Transaction_Reference
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setCredit_Card_Transaction_Reference($credit_Card_Transaction_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Transaction_Reference) && !is_string($credit_Card_Transaction_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Transaction_Reference, true), gettype($credit_Card_Transaction_Reference)), __LINE__);
        }
        $this->Credit_Card_Transaction_Reference = $credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get Destination_City value
     * @return string|null
     */
    public function getDestination_City()
    {
        return $this->Destination_City;
    }
    /**
     * Set Destination_City value
     * @param string $destination_City
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setDestination_City($destination_City = null)
    {
        // validation for constraint: string
        if (!is_null($destination_City) && !is_string($destination_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_City, true), gettype($destination_City)), __LINE__);
        }
        $this->Destination_City = $destination_City;
        return $this;
    }
    /**
     * Get Destination_State value
     * @return string|null
     */
    public function getDestination_State()
    {
        return $this->Destination_State;
    }
    /**
     * Set Destination_State value
     * @param string $destination_State
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setDestination_State($destination_State = null)
    {
        // validation for constraint: string
        if (!is_null($destination_State) && !is_string($destination_State)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_State, true), gettype($destination_State)), __LINE__);
        }
        $this->Destination_State = $destination_State;
        return $this;
    }
    /**
     * Get Destination_Country value
     * @return string|null
     */
    public function getDestination_Country()
    {
        return $this->Destination_Country;
    }
    /**
     * Set Destination_Country value
     * @param string $destination_Country
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setDestination_Country($destination_Country = null)
    {
        // validation for constraint: string
        if (!is_null($destination_Country) && !is_string($destination_Country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_Country, true), gettype($destination_Country)), __LINE__);
        }
        $this->Destination_Country = $destination_Country;
        return $this;
    }
    /**
     * Get Origination_City value
     * @return string|null
     */
    public function getOrigination_City()
    {
        return $this->Origination_City;
    }
    /**
     * Set Origination_City value
     * @param string $origination_City
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setOrigination_City($origination_City = null)
    {
        // validation for constraint: string
        if (!is_null($origination_City) && !is_string($origination_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_City, true), gettype($origination_City)), __LINE__);
        }
        $this->Origination_City = $origination_City;
        return $this;
    }
    /**
     * Get Origination_State value
     * @return string|null
     */
    public function getOrigination_State()
    {
        return $this->Origination_State;
    }
    /**
     * Set Origination_State value
     * @param string $origination_State
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setOrigination_State($origination_State = null)
    {
        // validation for constraint: string
        if (!is_null($origination_State) && !is_string($origination_State)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_State, true), gettype($origination_State)), __LINE__);
        }
        $this->Origination_State = $origination_State;
        return $this;
    }
    /**
     * Get Origination_Country value
     * @return string|null
     */
    public function getOrigination_Country()
    {
        return $this->Origination_Country;
    }
    /**
     * Set Origination_Country value
     * @param string $origination_Country
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setOrigination_Country($origination_Country = null)
    {
        // validation for constraint: string
        if (!is_null($origination_Country) && !is_string($origination_Country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_Country, true), gettype($origination_Country)), __LINE__);
        }
        $this->Origination_Country = $origination_Country;
        return $this;
    }
    /**
     * Get Merchant_Code value
     * @return string|null
     */
    public function getMerchant_Code()
    {
        return $this->Merchant_Code;
    }
    /**
     * Set Merchant_Code value
     * @param string $merchant_Code
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setMerchant_Code($merchant_Code = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Code) && !is_string($merchant_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Code, true), gettype($merchant_Code)), __LINE__);
        }
        $this->Merchant_Code = $merchant_Code;
        return $this;
    }
    /**
     * Get Merchant_Name value
     * @return string|null
     */
    public function getMerchant_Name()
    {
        return $this->Merchant_Name;
    }
    /**
     * Set Merchant_Name value
     * @param string $merchant_Name
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setMerchant_Name($merchant_Name = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Name) && !is_string($merchant_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Name, true), gettype($merchant_Name)), __LINE__);
        }
        $this->Merchant_Name = $merchant_Name;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Source_Daily_Amount value
     * @return float|null
     */
    public function getSource_Daily_Amount()
    {
        return $this->Source_Daily_Amount;
    }
    /**
     * Set Source_Daily_Amount value
     * @param float $source_Daily_Amount
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setSource_Daily_Amount($source_Daily_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($source_Daily_Amount) && !(is_float($source_Daily_Amount) || is_numeric($source_Daily_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($source_Daily_Amount, true), gettype($source_Daily_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($source_Daily_Amount) && mb_strlen(mb_substr($source_Daily_Amount, false !== mb_strpos($source_Daily_Amount, '.') ? mb_strpos($source_Daily_Amount, '.') + 1 : mb_strlen($source_Daily_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($source_Daily_Amount, true), mb_strlen(mb_substr($source_Daily_Amount, mb_strpos($source_Daily_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($source_Daily_Amount) && $source_Daily_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($source_Daily_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($source_Daily_Amount) && mb_strlen(preg_replace('/(\D)/', '', $source_Daily_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($source_Daily_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $source_Daily_Amount))), __LINE__);
        }
        $this->Source_Daily_Amount = $source_Daily_Amount;
        return $this;
    }
    /**
     * Get Travel_Policy_Code value
     * @return string|null
     */
    public function getTravel_Policy_Code()
    {
        return $this->Travel_Policy_Code;
    }
    /**
     * Set Travel_Policy_Code value
     * @param string $travel_Policy_Code
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTravel_Policy_Code($travel_Policy_Code = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Policy_Code) && !is_string($travel_Policy_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Policy_Code, true), gettype($travel_Policy_Code)), __LINE__);
        }
        $this->Travel_Policy_Code = $travel_Policy_Code;
        return $this;
    }
    /**
     * Get Policy_Description value
     * @return string|null
     */
    public function getPolicy_Description()
    {
        return $this->Policy_Description;
    }
    /**
     * Set Policy_Description value
     * @param string $policy_Description
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setPolicy_Description($policy_Description = null)
    {
        // validation for constraint: string
        if (!is_null($policy_Description) && !is_string($policy_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policy_Description, true), gettype($policy_Description)), __LINE__);
        }
        $this->Policy_Description = $policy_Description;
        return $this;
    }
    /**
     * Get Travel_Booking_Record_Name_Match_Data value
     * @return \StructType\Travel_Booking_Record_Name_Match_DataType[]|null
     */
    public function getTravel_Booking_Record_Name_Match_Data()
    {
        return $this->Travel_Booking_Record_Name_Match_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Booking_Record_Name_Match_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Booking_Record_Name_Match_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Booking_Record_Name_Match_DataForArrayConstraintsFromSetTravel_Booking_Record_Name_Match_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_DataTypeTravel_Booking_Record_Name_Match_DataItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_DataTypeTravel_Booking_Record_Name_Match_DataItem instanceof \StructType\Travel_Booking_Record_Name_Match_DataType) {
                $invalidValues[] = is_object($travel_Booking_Record_DataTypeTravel_Booking_Record_Name_Match_DataItem) ? get_class($travel_Booking_Record_DataTypeTravel_Booking_Record_Name_Match_DataItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_DataTypeTravel_Booking_Record_Name_Match_DataItem), var_export($travel_Booking_Record_DataTypeTravel_Booking_Record_Name_Match_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Booking_Record_Name_Match_Data property can only contain items of type \StructType\Travel_Booking_Record_Name_Match_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Booking_Record_Name_Match_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_Name_Match_DataType[] $travel_Booking_Record_Name_Match_Data
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function setTravel_Booking_Record_Name_Match_Data(array $travel_Booking_Record_Name_Match_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Booking_Record_Name_Match_DataArrayErrorMessage = self::validateTravel_Booking_Record_Name_Match_DataForArrayConstraintsFromSetTravel_Booking_Record_Name_Match_Data($travel_Booking_Record_Name_Match_Data))) {
            throw new \InvalidArgumentException($travel_Booking_Record_Name_Match_DataArrayErrorMessage, __LINE__);
        }
        $this->Travel_Booking_Record_Name_Match_Data = $travel_Booking_Record_Name_Match_Data;
        return $this;
    }
    /**
     * Add item to Travel_Booking_Record_Name_Match_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_Name_Match_DataType $item
     * @return \StructType\Travel_Booking_Record_DataType
     */
    public function addToTravel_Booking_Record_Name_Match_Data(\StructType\Travel_Booking_Record_Name_Match_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_Record_Name_Match_DataType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Booking_Record_Name_Match_Data property can only contain items of type \StructType\Travel_Booking_Record_Name_Match_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Booking_Record_Name_Match_Data[] = $item;
        return $this;
    }
}
