<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing receivables repayment response data for requested references or criteria and for requested response group.
 * @subpackage Structs
 */
class Receivable_Repayment_Response_DataType extends AbstractStructBase
{
    /**
     * The Receivable_Repayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receivable_Repayment_WWSType[]
     */
    public $Receivable_Repayment;
    /**
     * Constructor method for Receivable_Repayment_Response_DataType
     * @uses Receivable_Repayment_Response_DataType::setReceivable_Repayment()
     * @param \StructType\Receivable_Repayment_WWSType[] $receivable_Repayment
     */
    public function __construct(array $receivable_Repayment = array())
    {
        $this
            ->setReceivable_Repayment($receivable_Repayment);
    }
    /**
     * Get Receivable_Repayment value
     * @return \StructType\Receivable_Repayment_WWSType[]|null
     */
    public function getReceivable_Repayment()
    {
        return $this->Receivable_Repayment;
    }
    /**
     * This method is responsible for validating the values passed to the setReceivable_Repayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceivable_Repayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceivable_RepaymentForArrayConstraintsFromSetReceivable_Repayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_Response_DataTypeReceivable_RepaymentItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_Response_DataTypeReceivable_RepaymentItem instanceof \StructType\Receivable_Repayment_WWSType) {
                $invalidValues[] = is_object($receivable_Repayment_Response_DataTypeReceivable_RepaymentItem) ? get_class($receivable_Repayment_Response_DataTypeReceivable_RepaymentItem) : sprintf('%s(%s)', gettype($receivable_Repayment_Response_DataTypeReceivable_RepaymentItem), var_export($receivable_Repayment_Response_DataTypeReceivable_RepaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receivable_Repayment property can only contain items of type \StructType\Receivable_Repayment_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receivable_Repayment value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_Repayment_WWSType[] $receivable_Repayment
     * @return \StructType\Receivable_Repayment_Response_DataType
     */
    public function setReceivable_Repayment(array $receivable_Repayment = array())
    {
        // validation for constraint: array
        if ('' !== ($receivable_RepaymentArrayErrorMessage = self::validateReceivable_RepaymentForArrayConstraintsFromSetReceivable_Repayment($receivable_Repayment))) {
            throw new \InvalidArgumentException($receivable_RepaymentArrayErrorMessage, __LINE__);
        }
        $this->Receivable_Repayment = $receivable_Repayment;
        return $this;
    }
    /**
     * Add item to Receivable_Repayment value
     * @throws \InvalidArgumentException
     * @param \StructType\Receivable_Repayment_WWSType $item
     * @return \StructType\Receivable_Repayment_Response_DataType
     */
    public function addToReceivable_Repayment(\StructType\Receivable_Repayment_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receivable_Repayment_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Receivable_Repayment property can only contain items of type \StructType\Receivable_Repayment_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receivable_Repayment[] = $item;
        return $this;
    }
}
