<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Asset_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Asset Data
 * @subpackage Structs
 */
class Project_Asset_DataType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Specify the rule evaluation order for the project asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Project_Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the project asset
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Asset_ID;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project reference for the project asset
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for a meaningful Project Asset Name - this is required for creating a project asset.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text field containing the description of the project asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tracking Spend Category Reference for the project asset
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Project_Asset_Assignment_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Specify an existing assignment rule for auto-assigning the project asset
     * - minOccurs: 0
     * @var \StructType\Capital_Project_Asset_Assignment_RuleObjectType
     */
    public $Project_Asset_Assignment_Rule_Reference;
    /**
     * The Project_Asset_Quantity
     * Meta information extracted from the WSDL
     * - documentation: The number of business assets that will be generated when the project asset is capitalized.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Project_Asset_Quantity;
    /**
     * The Uncapitalized_Cost
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Total cost associated with the project asset that has not been capitalized. Amount returned in the associated project's currency.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Uncapitalized_Cost;
    /**
     * The Capitalized_Cost
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Total capitalized cost of project asset returned in the associated project's currency.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Capitalized_Cost;
    /**
     * The Project_Asset_Cost
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Total cost associated with the project asset returned in the associated project's currency.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Project_Asset_Cost;
    /**
     * The Capitalization_Date
     * Meta information extracted from the WSDL
     * - documentation: Capitalization date for the project asset
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Capitalization_Date;
    /**
     * The Business_Assets_Detail
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Business assets for the project asset.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Assets_Detail_WWS_DataType[]
     */
    public $Business_Assets_Detail;
    /**
     * The Acquisition_Date
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Acquisition date for the project asset
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acquisition_Date;
    /**
     * Constructor method for Project_Asset_DataType
     * @uses Project_Asset_DataType::setOrder()
     * @uses Project_Asset_DataType::setProject_Asset_ID()
     * @uses Project_Asset_DataType::setProject_Reference()
     * @uses Project_Asset_DataType::setName()
     * @uses Project_Asset_DataType::setDescription()
     * @uses Project_Asset_DataType::setSpend_Category_Reference()
     * @uses Project_Asset_DataType::setProject_Asset_Assignment_Rule_Reference()
     * @uses Project_Asset_DataType::setProject_Asset_Quantity()
     * @uses Project_Asset_DataType::setUncapitalized_Cost()
     * @uses Project_Asset_DataType::setCapitalized_Cost()
     * @uses Project_Asset_DataType::setProject_Asset_Cost()
     * @uses Project_Asset_DataType::setCapitalization_Date()
     * @uses Project_Asset_DataType::setBusiness_Assets_Detail()
     * @uses Project_Asset_DataType::setAcquisition_Date()
     * @param string $order
     * @param string $project_Asset_ID
     * @param \StructType\ProjectObjectType $project_Reference
     * @param string $name
     * @param string $description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Capital_Project_Asset_Assignment_RuleObjectType $project_Asset_Assignment_Rule_Reference
     * @param float $project_Asset_Quantity
     * @param float $uncapitalized_Cost
     * @param float $capitalized_Cost
     * @param float $project_Asset_Cost
     * @param string $capitalization_Date
     * @param \StructType\Business_Assets_Detail_WWS_DataType[] $business_Assets_Detail
     * @param string $acquisition_Date
     */
    public function __construct($order = null, $project_Asset_ID = null, \StructType\ProjectObjectType $project_Reference = null, $name = null, $description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Capital_Project_Asset_Assignment_RuleObjectType $project_Asset_Assignment_Rule_Reference = null, $project_Asset_Quantity = null, $uncapitalized_Cost = null, $capitalized_Cost = null, $project_Asset_Cost = null, $capitalization_Date = null, array $business_Assets_Detail = array(), $acquisition_Date = null)
    {
        $this
            ->setOrder($order)
            ->setProject_Asset_ID($project_Asset_ID)
            ->setProject_Reference($project_Reference)
            ->setName($name)
            ->setDescription($description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setProject_Asset_Assignment_Rule_Reference($project_Asset_Assignment_Rule_Reference)
            ->setProject_Asset_Quantity($project_Asset_Quantity)
            ->setUncapitalized_Cost($uncapitalized_Cost)
            ->setCapitalized_Cost($capitalized_Cost)
            ->setProject_Asset_Cost($project_Asset_Cost)
            ->setCapitalization_Date($capitalization_Date)
            ->setBusiness_Assets_Detail($business_Assets_Detail)
            ->setAcquisition_Date($acquisition_Date);
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Project_Asset_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Project_Asset_ID value
     * @return string|null
     */
    public function getProject_Asset_ID()
    {
        return $this->Project_Asset_ID;
    }
    /**
     * Set Project_Asset_ID value
     * @param string $project_Asset_ID
     * @return \StructType\Project_Asset_DataType
     */
    public function setProject_Asset_ID($project_Asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Asset_ID) && !is_string($project_Asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Asset_ID, true), gettype($project_Asset_ID)), __LINE__);
        }
        $this->Project_Asset_ID = $project_Asset_ID;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Project_Asset_DataType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Project_Asset_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Asset_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Project_Asset_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Project_Asset_Assignment_Rule_Reference value
     * @return \StructType\Capital_Project_Asset_Assignment_RuleObjectType|null
     */
    public function getProject_Asset_Assignment_Rule_Reference()
    {
        return $this->Project_Asset_Assignment_Rule_Reference;
    }
    /**
     * Set Project_Asset_Assignment_Rule_Reference value
     * @param \StructType\Capital_Project_Asset_Assignment_RuleObjectType $project_Asset_Assignment_Rule_Reference
     * @return \StructType\Project_Asset_DataType
     */
    public function setProject_Asset_Assignment_Rule_Reference(\StructType\Capital_Project_Asset_Assignment_RuleObjectType $project_Asset_Assignment_Rule_Reference = null)
    {
        $this->Project_Asset_Assignment_Rule_Reference = $project_Asset_Assignment_Rule_Reference;
        return $this;
    }
    /**
     * Get Project_Asset_Quantity value
     * @return float|null
     */
    public function getProject_Asset_Quantity()
    {
        return $this->Project_Asset_Quantity;
    }
    /**
     * Set Project_Asset_Quantity value
     * @param float $project_Asset_Quantity
     * @return \StructType\Project_Asset_DataType
     */
    public function setProject_Asset_Quantity($project_Asset_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($project_Asset_Quantity) && !(is_float($project_Asset_Quantity) || is_numeric($project_Asset_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($project_Asset_Quantity, true), gettype($project_Asset_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($project_Asset_Quantity) && mb_strlen(mb_substr($project_Asset_Quantity, false !== mb_strpos($project_Asset_Quantity, '.') ? mb_strpos($project_Asset_Quantity, '.') + 1 : mb_strlen($project_Asset_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($project_Asset_Quantity, true), mb_strlen(mb_substr($project_Asset_Quantity, mb_strpos($project_Asset_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($project_Asset_Quantity) && $project_Asset_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($project_Asset_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($project_Asset_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $project_Asset_Quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($project_Asset_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $project_Asset_Quantity))), __LINE__);
        }
        $this->Project_Asset_Quantity = $project_Asset_Quantity;
        return $this;
    }
    /**
     * Get Uncapitalized_Cost value
     * @return float|null
     */
    public function getUncapitalized_Cost()
    {
        return $this->Uncapitalized_Cost;
    }
    /**
     * Set Uncapitalized_Cost value
     * @param float $uncapitalized_Cost
     * @return \StructType\Project_Asset_DataType
     */
    public function setUncapitalized_Cost($uncapitalized_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($uncapitalized_Cost) && !(is_float($uncapitalized_Cost) || is_numeric($uncapitalized_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uncapitalized_Cost, true), gettype($uncapitalized_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($uncapitalized_Cost) && mb_strlen(mb_substr($uncapitalized_Cost, false !== mb_strpos($uncapitalized_Cost, '.') ? mb_strpos($uncapitalized_Cost, '.') + 1 : mb_strlen($uncapitalized_Cost))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($uncapitalized_Cost, true), mb_strlen(mb_substr($uncapitalized_Cost, mb_strpos($uncapitalized_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($uncapitalized_Cost) && mb_strlen(preg_replace('/(\D)/', '', $uncapitalized_Cost)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($uncapitalized_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $uncapitalized_Cost))), __LINE__);
        }
        $this->Uncapitalized_Cost = $uncapitalized_Cost;
        return $this;
    }
    /**
     * Get Capitalized_Cost value
     * @return float|null
     */
    public function getCapitalized_Cost()
    {
        return $this->Capitalized_Cost;
    }
    /**
     * Set Capitalized_Cost value
     * @param float $capitalized_Cost
     * @return \StructType\Project_Asset_DataType
     */
    public function setCapitalized_Cost($capitalized_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($capitalized_Cost) && !(is_float($capitalized_Cost) || is_numeric($capitalized_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capitalized_Cost, true), gettype($capitalized_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($capitalized_Cost) && mb_strlen(mb_substr($capitalized_Cost, false !== mb_strpos($capitalized_Cost, '.') ? mb_strpos($capitalized_Cost, '.') + 1 : mb_strlen($capitalized_Cost))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($capitalized_Cost, true), mb_strlen(mb_substr($capitalized_Cost, mb_strpos($capitalized_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($capitalized_Cost) && mb_strlen(preg_replace('/(\D)/', '', $capitalized_Cost)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($capitalized_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $capitalized_Cost))), __LINE__);
        }
        $this->Capitalized_Cost = $capitalized_Cost;
        return $this;
    }
    /**
     * Get Project_Asset_Cost value
     * @return float|null
     */
    public function getProject_Asset_Cost()
    {
        return $this->Project_Asset_Cost;
    }
    /**
     * Set Project_Asset_Cost value
     * @param float $project_Asset_Cost
     * @return \StructType\Project_Asset_DataType
     */
    public function setProject_Asset_Cost($project_Asset_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($project_Asset_Cost) && !(is_float($project_Asset_Cost) || is_numeric($project_Asset_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($project_Asset_Cost, true), gettype($project_Asset_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($project_Asset_Cost) && mb_strlen(mb_substr($project_Asset_Cost, false !== mb_strpos($project_Asset_Cost, '.') ? mb_strpos($project_Asset_Cost, '.') + 1 : mb_strlen($project_Asset_Cost))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($project_Asset_Cost, true), mb_strlen(mb_substr($project_Asset_Cost, mb_strpos($project_Asset_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($project_Asset_Cost) && mb_strlen(preg_replace('/(\D)/', '', $project_Asset_Cost)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($project_Asset_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $project_Asset_Cost))), __LINE__);
        }
        $this->Project_Asset_Cost = $project_Asset_Cost;
        return $this;
    }
    /**
     * Get Capitalization_Date value
     * @return string|null
     */
    public function getCapitalization_Date()
    {
        return $this->Capitalization_Date;
    }
    /**
     * Set Capitalization_Date value
     * @param string $capitalization_Date
     * @return \StructType\Project_Asset_DataType
     */
    public function setCapitalization_Date($capitalization_Date = null)
    {
        // validation for constraint: string
        if (!is_null($capitalization_Date) && !is_string($capitalization_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($capitalization_Date, true), gettype($capitalization_Date)), __LINE__);
        }
        $this->Capitalization_Date = $capitalization_Date;
        return $this;
    }
    /**
     * Get Business_Assets_Detail value
     * @return \StructType\Business_Assets_Detail_WWS_DataType[]|null
     */
    public function getBusiness_Assets_Detail()
    {
        return $this->Business_Assets_Detail;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Assets_Detail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Assets_Detail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Assets_DetailForArrayConstraintsFromSetBusiness_Assets_Detail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Asset_DataTypeBusiness_Assets_DetailItem) {
            // validation for constraint: itemType
            if (!$project_Asset_DataTypeBusiness_Assets_DetailItem instanceof \StructType\Business_Assets_Detail_WWS_DataType) {
                $invalidValues[] = is_object($project_Asset_DataTypeBusiness_Assets_DetailItem) ? get_class($project_Asset_DataTypeBusiness_Assets_DetailItem) : sprintf('%s(%s)', gettype($project_Asset_DataTypeBusiness_Assets_DetailItem), var_export($project_Asset_DataTypeBusiness_Assets_DetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Assets_Detail property can only contain items of type \StructType\Business_Assets_Detail_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Assets_Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Assets_Detail_WWS_DataType[] $business_Assets_Detail
     * @return \StructType\Project_Asset_DataType
     */
    public function setBusiness_Assets_Detail(array $business_Assets_Detail = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Assets_DetailArrayErrorMessage = self::validateBusiness_Assets_DetailForArrayConstraintsFromSetBusiness_Assets_Detail($business_Assets_Detail))) {
            throw new \InvalidArgumentException($business_Assets_DetailArrayErrorMessage, __LINE__);
        }
        $this->Business_Assets_Detail = $business_Assets_Detail;
        return $this;
    }
    /**
     * Add item to Business_Assets_Detail value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Assets_Detail_WWS_DataType $item
     * @return \StructType\Project_Asset_DataType
     */
    public function addToBusiness_Assets_Detail(\StructType\Business_Assets_Detail_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Assets_Detail_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Assets_Detail property can only contain items of type \StructType\Business_Assets_Detail_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Assets_Detail[] = $item;
        return $this;
    }
    /**
     * Get Acquisition_Date value
     * @return string|null
     */
    public function getAcquisition_Date()
    {
        return $this->Acquisition_Date;
    }
    /**
     * Set Acquisition_Date value
     * @param string $acquisition_Date
     * @return \StructType\Project_Asset_DataType
     */
    public function setAcquisition_Date($acquisition_Date = null)
    {
        // validation for constraint: string
        if (!is_null($acquisition_Date) && !is_string($acquisition_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquisition_Date, true), gettype($acquisition_Date)), __LINE__);
        }
        $this->Acquisition_Date = $acquisition_Date;
        return $this;
    }
}
