<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Accumulator_Balance_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing the Expense Item Accumulator Balance
 * @subpackage Structs
 */
class Expense_Item_Accumulator_Balance_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_Accumulator_Balance_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Accumulator Balance ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Item_Accumulator_Balance_ID;
    /**
     * The Expense_Item_Accumulator_Balance_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Item Accumulator Balance
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Accumulator_BalanceObjectType
     */
    public $Expense_Item_Accumulator_Balance_Reference;
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Expense Item
     * @var \StructType\Expense_ItemObjectType
     */
    public $Expense_Item_Reference;
    /**
     * The Beginning_Balance
     * Meta information extracted from the WSDL
     * - documentation: Beginning Accumulator Balance
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Beginning_Balance;
    /**
     * The Balance_Application_Date
     * Meta information extracted from the WSDL
     * - documentation: Balance Application Date
     * - maxOccurs: 1
     * @var string
     */
    public $Balance_Application_Date;
    /**
     * The Applicable_Until_Date
     * Meta information extracted from the WSDL
     * - documentation: The end date that's calculated based on the Accumulator Application Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Applicable_Until_Date;
    /**
     * Constructor method for Expense_Item_Accumulator_Balance_DataType
     * @uses Expense_Item_Accumulator_Balance_DataType::setExpense_Item_Accumulator_Balance_ID()
     * @uses Expense_Item_Accumulator_Balance_DataType::setExpense_Item_Accumulator_Balance_Reference()
     * @uses Expense_Item_Accumulator_Balance_DataType::setExpense_Item_Reference()
     * @uses Expense_Item_Accumulator_Balance_DataType::setBeginning_Balance()
     * @uses Expense_Item_Accumulator_Balance_DataType::setBalance_Application_Date()
     * @uses Expense_Item_Accumulator_Balance_DataType::setApplicable_Until_Date()
     * @param string $expense_Item_Accumulator_Balance_ID
     * @param \StructType\Expense_Item_Accumulator_BalanceObjectType $expense_Item_Accumulator_Balance_Reference
     * @param \StructType\Expense_ItemObjectType $expense_Item_Reference
     * @param float $beginning_Balance
     * @param string $balance_Application_Date
     * @param string $applicable_Until_Date
     */
    public function __construct($expense_Item_Accumulator_Balance_ID = null, \StructType\Expense_Item_Accumulator_BalanceObjectType $expense_Item_Accumulator_Balance_Reference = null, \StructType\Expense_ItemObjectType $expense_Item_Reference = null, $beginning_Balance = null, $balance_Application_Date = null, $applicable_Until_Date = null)
    {
        $this
            ->setExpense_Item_Accumulator_Balance_ID($expense_Item_Accumulator_Balance_ID)
            ->setExpense_Item_Accumulator_Balance_Reference($expense_Item_Accumulator_Balance_Reference)
            ->setExpense_Item_Reference($expense_Item_Reference)
            ->setBeginning_Balance($beginning_Balance)
            ->setBalance_Application_Date($balance_Application_Date)
            ->setApplicable_Until_Date($applicable_Until_Date);
    }
    /**
     * Get Expense_Item_Accumulator_Balance_ID value
     * @return string|null
     */
    public function getExpense_Item_Accumulator_Balance_ID()
    {
        return $this->Expense_Item_Accumulator_Balance_ID;
    }
    /**
     * Set Expense_Item_Accumulator_Balance_ID value
     * @param string $expense_Item_Accumulator_Balance_ID
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType
     */
    public function setExpense_Item_Accumulator_Balance_ID($expense_Item_Accumulator_Balance_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_Accumulator_Balance_ID) && !is_string($expense_Item_Accumulator_Balance_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_Accumulator_Balance_ID, true), gettype($expense_Item_Accumulator_Balance_ID)), __LINE__);
        }
        $this->Expense_Item_Accumulator_Balance_ID = $expense_Item_Accumulator_Balance_ID;
        return $this;
    }
    /**
     * Get Expense_Item_Accumulator_Balance_Reference value
     * @return \StructType\Expense_Item_Accumulator_BalanceObjectType|null
     */
    public function getExpense_Item_Accumulator_Balance_Reference()
    {
        return $this->Expense_Item_Accumulator_Balance_Reference;
    }
    /**
     * Set Expense_Item_Accumulator_Balance_Reference value
     * @param \StructType\Expense_Item_Accumulator_BalanceObjectType $expense_Item_Accumulator_Balance_Reference
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType
     */
    public function setExpense_Item_Accumulator_Balance_Reference(\StructType\Expense_Item_Accumulator_BalanceObjectType $expense_Item_Accumulator_Balance_Reference = null)
    {
        $this->Expense_Item_Accumulator_Balance_Reference = $expense_Item_Accumulator_Balance_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Expense_ItemObjectType|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * Set Expense_Item_Reference value
     * @param \StructType\Expense_ItemObjectType $expense_Item_Reference
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType
     */
    public function setExpense_Item_Reference(\StructType\Expense_ItemObjectType $expense_Item_Reference = null)
    {
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Get Beginning_Balance value
     * @return float|null
     */
    public function getBeginning_Balance()
    {
        return $this->Beginning_Balance;
    }
    /**
     * Set Beginning_Balance value
     * @param float $beginning_Balance
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType
     */
    public function setBeginning_Balance($beginning_Balance = null)
    {
        // validation for constraint: float
        if (!is_null($beginning_Balance) && !(is_float($beginning_Balance) || is_numeric($beginning_Balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beginning_Balance, true), gettype($beginning_Balance)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($beginning_Balance) && mb_strlen(mb_substr($beginning_Balance, false !== mb_strpos($beginning_Balance, '.') ? mb_strpos($beginning_Balance, '.') + 1 : mb_strlen($beginning_Balance))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($beginning_Balance, true), mb_strlen(mb_substr($beginning_Balance, mb_strpos($beginning_Balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($beginning_Balance) && $beginning_Balance < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($beginning_Balance, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($beginning_Balance) && mb_strlen(preg_replace('/(\D)/', '', $beginning_Balance)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($beginning_Balance, true), mb_strlen(preg_replace('/(\D)/', '', $beginning_Balance))), __LINE__);
        }
        $this->Beginning_Balance = $beginning_Balance;
        return $this;
    }
    /**
     * Get Balance_Application_Date value
     * @return string|null
     */
    public function getBalance_Application_Date()
    {
        return $this->Balance_Application_Date;
    }
    /**
     * Set Balance_Application_Date value
     * @param string $balance_Application_Date
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType
     */
    public function setBalance_Application_Date($balance_Application_Date = null)
    {
        // validation for constraint: string
        if (!is_null($balance_Application_Date) && !is_string($balance_Application_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($balance_Application_Date, true), gettype($balance_Application_Date)), __LINE__);
        }
        $this->Balance_Application_Date = $balance_Application_Date;
        return $this;
    }
    /**
     * Get Applicable_Until_Date value
     * @return string|null
     */
    public function getApplicable_Until_Date()
    {
        return $this->Applicable_Until_Date;
    }
    /**
     * Set Applicable_Until_Date value
     * @param string $applicable_Until_Date
     * @return \StructType\Expense_Item_Accumulator_Balance_DataType
     */
    public function setApplicable_Until_Date($applicable_Until_Date = null)
    {
        // validation for constraint: string
        if (!is_null($applicable_Until_Date) && !is_string($applicable_Until_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicable_Until_Date, true), gettype($applicable_Until_Date)), __LINE__);
        }
        $this->Applicable_Until_Date = $applicable_Until_Date;
        return $this;
    }
}
