<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for External_Transaction_Source_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for External Transaction Source
 * @subpackage Structs
 */
class External_Transaction_Source_DataType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the External Transaction Source.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the External Transaction Source.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: The External Transaction Source activation status.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The External_Transaction_Source_Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Transaction Source Usages
     * - maxOccurs: unbounded
     * @var \StructType\External_Transaction_Source_UsageObjectType[]
     */
    public $External_Transaction_Source_Usage_Reference;
    /**
     * Constructor method for External_Transaction_Source_DataType
     * @uses External_Transaction_Source_DataType::setName()
     * @uses External_Transaction_Source_DataType::setDescription()
     * @uses External_Transaction_Source_DataType::setInactive()
     * @uses External_Transaction_Source_DataType::setExternal_Transaction_Source_Usage_Reference()
     * @param string $name
     * @param string $description
     * @param bool $inactive
     * @param \StructType\External_Transaction_Source_UsageObjectType[] $external_Transaction_Source_Usage_Reference
     */
    public function __construct($name = null, $description = null, $inactive = null, array $external_Transaction_Source_Usage_Reference = array())
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setInactive($inactive)
            ->setExternal_Transaction_Source_Usage_Reference($external_Transaction_Source_Usage_Reference);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\External_Transaction_Source_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\External_Transaction_Source_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\External_Transaction_Source_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get External_Transaction_Source_Usage_Reference value
     * @return \StructType\External_Transaction_Source_UsageObjectType[]|null
     */
    public function getExternal_Transaction_Source_Usage_Reference()
    {
        return $this->External_Transaction_Source_Usage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_Transaction_Source_Usage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_Transaction_Source_Usage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_Transaction_Source_Usage_ReferenceForArrayConstraintsFromSetExternal_Transaction_Source_Usage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $external_Transaction_Source_DataTypeExternal_Transaction_Source_Usage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$external_Transaction_Source_DataTypeExternal_Transaction_Source_Usage_ReferenceItem instanceof \StructType\External_Transaction_Source_UsageObjectType) {
                $invalidValues[] = is_object($external_Transaction_Source_DataTypeExternal_Transaction_Source_Usage_ReferenceItem) ? get_class($external_Transaction_Source_DataTypeExternal_Transaction_Source_Usage_ReferenceItem) : sprintf('%s(%s)', gettype($external_Transaction_Source_DataTypeExternal_Transaction_Source_Usage_ReferenceItem), var_export($external_Transaction_Source_DataTypeExternal_Transaction_Source_Usage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_Transaction_Source_Usage_Reference property can only contain items of type \StructType\External_Transaction_Source_UsageObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_Transaction_Source_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source_UsageObjectType[] $external_Transaction_Source_Usage_Reference
     * @return \StructType\External_Transaction_Source_DataType
     */
    public function setExternal_Transaction_Source_Usage_Reference(array $external_Transaction_Source_Usage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($external_Transaction_Source_Usage_ReferenceArrayErrorMessage = self::validateExternal_Transaction_Source_Usage_ReferenceForArrayConstraintsFromSetExternal_Transaction_Source_Usage_Reference($external_Transaction_Source_Usage_Reference))) {
            throw new \InvalidArgumentException($external_Transaction_Source_Usage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->External_Transaction_Source_Usage_Reference = $external_Transaction_Source_Usage_Reference;
        return $this;
    }
    /**
     * Add item to External_Transaction_Source_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source_UsageObjectType $item
     * @return \StructType\External_Transaction_Source_DataType
     */
    public function addToExternal_Transaction_Source_Usage_Reference(\StructType\External_Transaction_Source_UsageObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Transaction_Source_UsageObjectType) {
            throw new \InvalidArgumentException(sprintf('The External_Transaction_Source_Usage_Reference property can only contain items of type \StructType\External_Transaction_Source_UsageObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_Transaction_Source_Usage_Reference[] = $item;
        return $this;
    }
}
