<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carriers_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use this element to retrieve the specific details of the carrier responses to requests.
 * @subpackage Structs
 */
class Carriers_Response_DataType extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: Custom Carrier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CarriersType[]
     */
    public $Carrier;
    /**
     * Constructor method for Carriers_Response_DataType
     * @uses Carriers_Response_DataType::setCarrier()
     * @param \StructType\CarriersType[] $carrier
     */
    public function __construct(array $carrier = array())
    {
        $this
            ->setCarrier($carrier);
    }
    /**
     * Get Carrier value
     * @return \StructType\CarriersType[]|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierForArrayConstraintsFromSetCarrier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carriers_Response_DataTypeCarrierItem) {
            // validation for constraint: itemType
            if (!$carriers_Response_DataTypeCarrierItem instanceof \StructType\CarriersType) {
                $invalidValues[] = is_object($carriers_Response_DataTypeCarrierItem) ? get_class($carriers_Response_DataTypeCarrierItem) : sprintf('%s(%s)', gettype($carriers_Response_DataTypeCarrierItem), var_export($carriers_Response_DataTypeCarrierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Carrier property can only contain items of type \StructType\CarriersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Carrier value
     * @throws \InvalidArgumentException
     * @param \StructType\CarriersType[] $carrier
     * @return \StructType\Carriers_Response_DataType
     */
    public function setCarrier(array $carrier = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierArrayErrorMessage = self::validateCarrierForArrayConstraintsFromSetCarrier($carrier))) {
            throw new \InvalidArgumentException($carrierArrayErrorMessage, __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Add item to Carrier value
     * @throws \InvalidArgumentException
     * @param \StructType\CarriersType $item
     * @return \StructType\Carriers_Response_DataType
     */
    public function addToCarrier(\StructType\CarriersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarriersType) {
            throw new \InvalidArgumentException(sprintf('The Carrier property can only contain items of type \StructType\CarriersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Carrier[] = $item;
        return $this;
    }
}
