<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * Change_Depreciation_Accounting_Status
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service is used to override the Depreciation status to Accounted for Asset Schedules for which there is no Posted Depreciation.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Change_Depreciation_Accounting_Status_RequestType $body
     * @return \StructType\Change_Depreciation_Accounting_Status_ResponseType|bool
     */
    public function Change_Depreciation_Accounting_Status(\StructType\Change_Depreciation_Accounting_Status_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Change_Depreciation_Accounting_Status($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Change_Prepaid_Amortization_Type
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This changes the Prepaid Amortization Type on the supplier invoice.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Change_Prepaid_Amortization_Type_RequestType $body
     * @return \StructType\Change_Prepaid_Amortization_Type_ResponseType|bool
     */
    public function Change_Prepaid_Amortization_Type(\StructType\Change_Prepaid_Amortization_Type_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Change_Prepaid_Amortization_Type($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Change_Supplier_Invoice_On_Hold_Status
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service changes the On Hold status of Supplier Invoices and Supplier Invoice AdjustmentsNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Change_Supplier_Invoice_On_Hold_Status_RequestType $body
     * @return \StructType\Change_Supplier_Invoice_On_Hold_Status_ResponseType|bool
     */
    public function Change_Supplier_Invoice_On_Hold_Status(\StructType\Change_Supplier_Invoice_On_Hold_Status_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Change_Supplier_Invoice_On_Hold_Status($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Change_Depreciation_Accounting_Status_ResponseType|\StructType\Change_Prepaid_Amortization_Type_ResponseType|\StructType\Change_Supplier_Invoice_On_Hold_Status_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
