<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Utilization_Target_Snapshot_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Container for Worker Utilization Target Snapshot Data
 * @subpackage Structs
 */
class Worker_Utilization_Target_Snapshot_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * - maxOccurs: unbounded
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date
     * - maxOccurs: 1
     * @var string
     */
    public $Effective_Date;
    /**
     * The Utilization_Target_1st_Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Sheet 1st Priority
     * @var \StructType\Utilization_Target_PriorityObjectType
     */
    public $Utilization_Target_1st_Priority_Reference;
    /**
     * The Utilization_Target_2nd_Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Sheet 2nd Priority
     * - minOccurs: 0
     * @var \StructType\Utilization_Target_PriorityObjectType
     */
    public $Utilization_Target_2nd_Priority_Reference;
    /**
     * The Worker_Utilization_Target_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worker_Utilization_Target_Details_DataType[]
     */
    public $Worker_Utilization_Target_Data;
    /**
     * The Worker_Utilization_Target_Rule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worker_Utilization_Target_Rule_Details_DataType[]
     */
    public $Worker_Utilization_Target_Rule_Data;
    /**
     * Constructor method for Worker_Utilization_Target_Snapshot_DataType
     * @uses Worker_Utilization_Target_Snapshot_DataType::setCompany_Reference()
     * @uses Worker_Utilization_Target_Snapshot_DataType::setEffective_Date()
     * @uses Worker_Utilization_Target_Snapshot_DataType::setUtilization_Target_1st_Priority_Reference()
     * @uses Worker_Utilization_Target_Snapshot_DataType::setUtilization_Target_2nd_Priority_Reference()
     * @uses Worker_Utilization_Target_Snapshot_DataType::setWorker_Utilization_Target_Data()
     * @uses Worker_Utilization_Target_Snapshot_DataType::setWorker_Utilization_Target_Rule_Data()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param string $effective_Date
     * @param \StructType\Utilization_Target_PriorityObjectType $utilization_Target_1st_Priority_Reference
     * @param \StructType\Utilization_Target_PriorityObjectType $utilization_Target_2nd_Priority_Reference
     * @param \StructType\Worker_Utilization_Target_Details_DataType[] $worker_Utilization_Target_Data
     * @param \StructType\Worker_Utilization_Target_Rule_Details_DataType[] $worker_Utilization_Target_Rule_Data
     */
    public function __construct(array $company_Reference = array(), $effective_Date = null, \StructType\Utilization_Target_PriorityObjectType $utilization_Target_1st_Priority_Reference = null, \StructType\Utilization_Target_PriorityObjectType $utilization_Target_2nd_Priority_Reference = null, array $worker_Utilization_Target_Data = array(), array $worker_Utilization_Target_Rule_Data = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setEffective_Date($effective_Date)
            ->setUtilization_Target_1st_Priority_Reference($utilization_Target_1st_Priority_Reference)
            ->setUtilization_Target_2nd_Priority_Reference($utilization_Target_2nd_Priority_Reference)
            ->setWorker_Utilization_Target_Data($worker_Utilization_Target_Data)
            ->setWorker_Utilization_Target_Rule_Data($worker_Utilization_Target_Rule_Data);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Utilization_Target_Snapshot_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worker_Utilization_Target_Snapshot_DataTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($worker_Utilization_Target_Snapshot_DataTypeCompany_ReferenceItem) ? get_class($worker_Utilization_Target_Snapshot_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($worker_Utilization_Target_Snapshot_DataTypeCompany_ReferenceItem), var_export($worker_Utilization_Target_Snapshot_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get utilization_Targetst_Priority_Reference value
     * @return utilization_Targetst_Priority_Reference
     */
    public function getUtilization_Target_1st_Priority_Reference()
    {
        return $this->Utilization_Target_1st_Priority_Reference;
    }
    /**
     * Set utilization_Targetst_Priority_Reference value
     * @param utilization_Targetst_Priority_Reference $utilization_Targetst_Priority_Reference
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function setUtilization_Target_1st_Priority_Reference(\StructType\Utilization_Target_PriorityObjectType $utilization_Target_1st_Priority_Reference = null)
    {
        $this->Utilization_Target_1st_Priority_Reference = $utilization_Target_1st_Priority_Reference;
        return $this;
    }
    /**
     * Get utilization_Targetnd_Priority_Reference value
     * @return utilization_Targetnd_Priority_Reference
     */
    public function getUtilization_Target_2nd_Priority_Reference()
    {
        return $this->Utilization_Target_2nd_Priority_Reference;
    }
    /**
     * Set utilization_Targetnd_Priority_Reference value
     * @param utilization_Targetnd_Priority_Reference $utilization_Targetnd_Priority_Reference
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function setUtilization_Target_2nd_Priority_Reference(\StructType\Utilization_Target_PriorityObjectType $utilization_Target_2nd_Priority_Reference = null)
    {
        $this->Utilization_Target_2nd_Priority_Reference = $utilization_Target_2nd_Priority_Reference;
        return $this;
    }
    /**
     * Get Worker_Utilization_Target_Data value
     * @return \StructType\Worker_Utilization_Target_Details_DataType[]|null
     */
    public function getWorker_Utilization_Target_Data()
    {
        return $this->Worker_Utilization_Target_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Utilization_Target_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Utilization_Target_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_Utilization_Target_DataForArrayConstraintsFromSetWorker_Utilization_Target_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_DataItem) {
            // validation for constraint: itemType
            if (!$worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_DataItem instanceof \StructType\Worker_Utilization_Target_Details_DataType) {
                $invalidValues[] = is_object($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_DataItem) ? get_class($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_DataItem) : sprintf('%s(%s)', gettype($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_DataItem), var_export($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Utilization_Target_Data property can only contain items of type \StructType\Worker_Utilization_Target_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Utilization_Target_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Utilization_Target_Details_DataType[] $worker_Utilization_Target_Data
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function setWorker_Utilization_Target_Data(array $worker_Utilization_Target_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_Utilization_Target_DataArrayErrorMessage = self::validateWorker_Utilization_Target_DataForArrayConstraintsFromSetWorker_Utilization_Target_Data($worker_Utilization_Target_Data))) {
            throw new \InvalidArgumentException($worker_Utilization_Target_DataArrayErrorMessage, __LINE__);
        }
        $this->Worker_Utilization_Target_Data = $worker_Utilization_Target_Data;
        return $this;
    }
    /**
     * Add item to Worker_Utilization_Target_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Utilization_Target_Details_DataType $item
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function addToWorker_Utilization_Target_Data(\StructType\Worker_Utilization_Target_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_Utilization_Target_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Utilization_Target_Data property can only contain items of type \StructType\Worker_Utilization_Target_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Utilization_Target_Data[] = $item;
        return $this;
    }
    /**
     * Get Worker_Utilization_Target_Rule_Data value
     * @return \StructType\Worker_Utilization_Target_Rule_Details_DataType[]|null
     */
    public function getWorker_Utilization_Target_Rule_Data()
    {
        return $this->Worker_Utilization_Target_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Utilization_Target_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Utilization_Target_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_Utilization_Target_Rule_DataForArrayConstraintsFromSetWorker_Utilization_Target_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_Rule_DataItem instanceof \StructType\Worker_Utilization_Target_Rule_Details_DataType) {
                $invalidValues[] = is_object($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_Rule_DataItem) ? get_class($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_Rule_DataItem) : sprintf('%s(%s)', gettype($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_Rule_DataItem), var_export($worker_Utilization_Target_Snapshot_DataTypeWorker_Utilization_Target_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Utilization_Target_Rule_Data property can only contain items of type \StructType\Worker_Utilization_Target_Rule_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Utilization_Target_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Utilization_Target_Rule_Details_DataType[] $worker_Utilization_Target_Rule_Data
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function setWorker_Utilization_Target_Rule_Data(array $worker_Utilization_Target_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_Utilization_Target_Rule_DataArrayErrorMessage = self::validateWorker_Utilization_Target_Rule_DataForArrayConstraintsFromSetWorker_Utilization_Target_Rule_Data($worker_Utilization_Target_Rule_Data))) {
            throw new \InvalidArgumentException($worker_Utilization_Target_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Worker_Utilization_Target_Rule_Data = $worker_Utilization_Target_Rule_Data;
        return $this;
    }
    /**
     * Add item to Worker_Utilization_Target_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Utilization_Target_Rule_Details_DataType $item
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType
     */
    public function addToWorker_Utilization_Target_Rule_Data(\StructType\Worker_Utilization_Target_Rule_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_Utilization_Target_Rule_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Utilization_Target_Rule_Data property can only contain items of type \StructType\Worker_Utilization_Target_Rule_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Utilization_Target_Rule_Data[] = $item;
        return $this;
    }
}
