<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trip_Leg_Details_Name_Match_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Trip Leg Details Name Match Data
 * @subpackage Structs
 */
class Trip_Leg_Details_Name_Match_DataType extends AbstractStructBase
{
    /**
     * The Confidence_Percentage
     * Meta information extracted from the WSDL
     * - documentation: Confidence level percentage of merchant, or travel city names matching Workday's persisted data. | Confidence level percentage must between 0 and 100.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Confidence_Percentage;
    /**
     * The Carrier_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: If a Merchant Reference is provided, it must be a Merchant, or an Alternate Name linked to a Merchant.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Carrier_Code_Reference;
    /**
     * Constructor method for Trip_Leg_Details_Name_Match_DataType
     * @uses Trip_Leg_Details_Name_Match_DataType::setConfidence_Percentage()
     * @uses Trip_Leg_Details_Name_Match_DataType::setCarrier_Code_Reference()
     * @param float $confidence_Percentage
     * @param \StructType\Abstract_Spend_Data_NameObjectType $carrier_Code_Reference
     */
    public function __construct($confidence_Percentage = null, \StructType\Abstract_Spend_Data_NameObjectType $carrier_Code_Reference = null)
    {
        $this
            ->setConfidence_Percentage($confidence_Percentage)
            ->setCarrier_Code_Reference($carrier_Code_Reference);
    }
    /**
     * Get Confidence_Percentage value
     * @return float|null
     */
    public function getConfidence_Percentage()
    {
        return $this->Confidence_Percentage;
    }
    /**
     * Set Confidence_Percentage value
     * @param float $confidence_Percentage
     * @return \StructType\Trip_Leg_Details_Name_Match_DataType
     */
    public function setConfidence_Percentage($confidence_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($confidence_Percentage) && !(is_float($confidence_Percentage) || is_numeric($confidence_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($confidence_Percentage, true), gettype($confidence_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($confidence_Percentage) && mb_strlen(mb_substr($confidence_Percentage, false !== mb_strpos($confidence_Percentage, '.') ? mb_strpos($confidence_Percentage, '.') + 1 : mb_strlen($confidence_Percentage))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($confidence_Percentage, true), mb_strlen(mb_substr($confidence_Percentage, mb_strpos($confidence_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($confidence_Percentage) && $confidence_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($confidence_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($confidence_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $confidence_Percentage)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($confidence_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $confidence_Percentage))), __LINE__);
        }
        $this->Confidence_Percentage = $confidence_Percentage;
        return $this;
    }
    /**
     * Get Carrier_Code_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getCarrier_Code_Reference()
    {
        return $this->Carrier_Code_Reference;
    }
    /**
     * Set Carrier_Code_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $carrier_Code_Reference
     * @return \StructType\Trip_Leg_Details_Name_Match_DataType
     */
    public function setCarrier_Code_Reference(\StructType\Abstract_Spend_Data_NameObjectType $carrier_Code_Reference = null)
    {
        $this->Carrier_Code_Reference = $carrier_Code_Reference;
        return $this;
    }
}
