<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Return_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Return is not in Draft Status so it cannot be submitted. | The Web Service is set to Add Only; documents cannot be resubmitted. | Submit Return Request. Deliverable Service Lines cannot be Returned only Goods Lines.
 * @subpackage Structs
 */
class Submit_Return_RequestType extends AbstractStructBase
{
    /**
     * The Return_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Return.
     * - minOccurs: 0
     * @var \StructType\Return_to_SupplierObjectType
     */
    public $Return_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Submit_Return_Data
     * Meta information extracted from the WSDL
     * - documentation: Return Data
     * @var \StructType\Submit_Return_DataType
     */
    public $Submit_Return_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Return_RequestType
     * @uses Submit_Return_RequestType::setReturn_Reference()
     * @uses Submit_Return_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Return_RequestType::setSubmit_Return_Data()
     * @uses Submit_Return_RequestType::setAdd_Only()
     * @uses Submit_Return_RequestType::setVersion()
     * @param \StructType\Return_to_SupplierObjectType $return_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Submit_Return_DataType $submit_Return_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Return_to_SupplierObjectType $return_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Submit_Return_DataType $submit_Return_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setReturn_Reference($return_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSubmit_Return_Data($submit_Return_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Return_Reference value
     * @return \StructType\Return_to_SupplierObjectType|null
     */
    public function getReturn_Reference()
    {
        return $this->Return_Reference;
    }
    /**
     * Set Return_Reference value
     * @param \StructType\Return_to_SupplierObjectType $return_Reference
     * @return \StructType\Submit_Return_RequestType
     */
    public function setReturn_Reference(\StructType\Return_to_SupplierObjectType $return_Reference = null)
    {
        $this->Return_Reference = $return_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Return_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Submit_Return_Data value
     * @return \StructType\Submit_Return_DataType|null
     */
    public function getSubmit_Return_Data()
    {
        return $this->Submit_Return_Data;
    }
    /**
     * Set Submit_Return_Data value
     * @param \StructType\Submit_Return_DataType $submit_Return_Data
     * @return \StructType\Submit_Return_RequestType
     */
    public function setSubmit_Return_Data(\StructType\Submit_Return_DataType $submit_Return_Data = null)
    {
        $this->Submit_Return_Data = $submit_Return_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Return_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Return_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
