<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Carriers_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use this element to add or edit carrier information.
 * @subpackage Structs
 */
class Put_Carriers_RequestType extends AbstractStructBase
{
    /**
     * The Carrier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Carrier Reference
     * - minOccurs: 0
     * @var \StructType\Dock_Carrier__Audited_ObjectType
     */
    public $Carrier_Reference;
    /**
     * The Carrier_Data
     * Meta information extracted from the WSDL
     * - documentation: Custom Carrier Data
     * @var \StructType\Carriers_DataType
     */
    public $Carrier_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Carriers_RequestType
     * @uses Put_Carriers_RequestType::setCarrier_Reference()
     * @uses Put_Carriers_RequestType::setCarrier_Data()
     * @uses Put_Carriers_RequestType::setAdd_Only()
     * @uses Put_Carriers_RequestType::setVersion()
     * @param \StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference
     * @param \StructType\Carriers_DataType $carrier_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference = null, \StructType\Carriers_DataType $carrier_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setCarrier_Reference($carrier_Reference)
            ->setCarrier_Data($carrier_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Carrier_Reference value
     * @return \StructType\Dock_Carrier__Audited_ObjectType|null
     */
    public function getCarrier_Reference()
    {
        return $this->Carrier_Reference;
    }
    /**
     * Set Carrier_Reference value
     * @param \StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference
     * @return \StructType\Put_Carriers_RequestType
     */
    public function setCarrier_Reference(\StructType\Dock_Carrier__Audited_ObjectType $carrier_Reference = null)
    {
        $this->Carrier_Reference = $carrier_Reference;
        return $this;
    }
    /**
     * Get Carrier_Data value
     * @return \StructType\Carriers_DataType|null
     */
    public function getCarrier_Data()
    {
        return $this->Carrier_Data;
    }
    /**
     * Set Carrier_Data value
     * @param \StructType\Carriers_DataType $carrier_Data
     * @return \StructType\Put_Carriers_RequestType
     */
    public function setCarrier_Data(\StructType\Carriers_DataType $carrier_Data = null)
    {
        $this->Carrier_Data = $carrier_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Carriers_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Carriers_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
