<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Airport_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the Airport Reference and Data that is sent in the response
 * @subpackage Structs
 */
class Put_Airport_ResponseType extends AbstractStructBase
{
    /**
     * The Airport_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airport Reference
     * - minOccurs: 0
     * @var \StructType\AirportObjectType
     */
    public $Airport_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Airport_ResponseType
     * @uses Put_Airport_ResponseType::setAirport_Reference()
     * @uses Put_Airport_ResponseType::setVersion()
     * @param \StructType\AirportObjectType $airport_Reference
     * @param string $version
     */
    public function __construct(\StructType\AirportObjectType $airport_Reference = null, $version = null)
    {
        $this
            ->setAirport_Reference($airport_Reference)
            ->setVersion($version);
    }
    /**
     * Get Airport_Reference value
     * @return \StructType\AirportObjectType|null
     */
    public function getAirport_Reference()
    {
        return $this->Airport_Reference;
    }
    /**
     * Set Airport_Reference value
     * @param \StructType\AirportObjectType $airport_Reference
     * @return \StructType\Put_Airport_ResponseType
     */
    public function setAirport_Reference(\StructType\AirportObjectType $airport_Reference = null)
    {
        $this->Airport_Reference = $airport_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Airport_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
