<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Template_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the request references to retrieve a specific instance(s) of project plan template and its associated data.
 * @subpackage Structs
 */
class Project_Plan_Template_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Project_Plan_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the request references to retrieve a specific instance(s) of project plan template and its associated data.
     * - maxOccurs: unbounded
     * @var \StructType\Project_Plan_TemplateObjectType[]
     */
    public $Project_Plan_Template_Reference;
    /**
     * Constructor method for Project_Plan_Template_Request_ReferencesType
     * @uses Project_Plan_Template_Request_ReferencesType::setProject_Plan_Template_Reference()
     * @param \StructType\Project_Plan_TemplateObjectType[] $project_Plan_Template_Reference
     */
    public function __construct(array $project_Plan_Template_Reference = array())
    {
        $this
            ->setProject_Plan_Template_Reference($project_Plan_Template_Reference);
    }
    /**
     * Get Project_Plan_Template_Reference value
     * @return \StructType\Project_Plan_TemplateObjectType[]|null
     */
    public function getProject_Plan_Template_Reference()
    {
        return $this->Project_Plan_Template_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan_Template_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan_Template_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Plan_Template_ReferenceForArrayConstraintsFromSetProject_Plan_Template_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Template_Request_ReferencesTypeProject_Plan_Template_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Template_Request_ReferencesTypeProject_Plan_Template_ReferenceItem instanceof \StructType\Project_Plan_TemplateObjectType) {
                $invalidValues[] = is_object($project_Plan_Template_Request_ReferencesTypeProject_Plan_Template_ReferenceItem) ? get_class($project_Plan_Template_Request_ReferencesTypeProject_Plan_Template_ReferenceItem) : sprintf('%s(%s)', gettype($project_Plan_Template_Request_ReferencesTypeProject_Plan_Template_ReferenceItem), var_export($project_Plan_Template_Request_ReferencesTypeProject_Plan_Template_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan_Template_Reference property can only contain items of type \StructType\Project_Plan_TemplateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_TemplateObjectType[] $project_Plan_Template_Reference
     * @return \StructType\Project_Plan_Template_Request_ReferencesType
     */
    public function setProject_Plan_Template_Reference(array $project_Plan_Template_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Plan_Template_ReferenceArrayErrorMessage = self::validateProject_Plan_Template_ReferenceForArrayConstraintsFromSetProject_Plan_Template_Reference($project_Plan_Template_Reference))) {
            throw new \InvalidArgumentException($project_Plan_Template_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan_Template_Reference = $project_Plan_Template_Reference;
        return $this;
    }
    /**
     * Add item to Project_Plan_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_TemplateObjectType $item
     * @return \StructType\Project_Plan_Template_Request_ReferencesType
     */
    public function addToProject_Plan_Template_Reference(\StructType\Project_Plan_TemplateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_TemplateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan_Template_Reference property can only contain items of type \StructType\Project_Plan_TemplateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan_Template_Reference[] = $item;
        return $this;
    }
}
