<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import_Supplier_Invoice_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't change this supplier invoice because it is included in an active netting transaction. | You can't resubmit the supplier invoice because lines or line splits are in progress on a project transaction adjustment event. | You
 * cannot modify or cancel your supplier invoice or lines with an intercompany status of Billed. Cancel any billed intercompany invoices to update the supplier invoice. | You can't resubmit or cancel the supplier invoice because 1 or more supplier
 * invoice lines are associated with a capital project and have been capitalized or reclassified to expense. | Select the same company for both the header and line(s) or select a different supplier that isn't a company. | You can't change this supplier
 * invoice because it has a payment status of paid or in payment in progress. | The Supplier Invoice is canceled and cannot be resubmitted. | The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing Supplier Invoice
 * Business Processing Options, Supplier Invoice reference for update. Flag to indicate if this operation is add only, and all Supplier Invoice data items required to create a complete Supplier Invoice
 * @subpackage Structs
 */
class Import_Supplier_Invoice_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice for update only purposes
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Invoice_Data
     * @var \StructType\Supplier_Invoice__HV__DataType
     */
    public $Supplier_Invoice_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Import_Supplier_Invoice_RequestType
     * @uses Import_Supplier_Invoice_RequestType::setSupplier_Invoice_Reference()
     * @uses Import_Supplier_Invoice_RequestType::setBusiness_Process_Parameters()
     * @uses Import_Supplier_Invoice_RequestType::setSupplier_Invoice_Data()
     * @uses Import_Supplier_Invoice_RequestType::setAdd_Only()
     * @uses Import_Supplier_Invoice_RequestType::setVersion()
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_Invoice__HV__DataType $supplier_Invoice_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_Invoice__HV__DataType $supplier_Invoice_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Invoice_Data($supplier_Invoice_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Import_Supplier_Invoice_RequestType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Import_Supplier_Invoice_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Data value
     * @return \StructType\Supplier_Invoice__HV__DataType|null
     */
    public function getSupplier_Invoice_Data()
    {
        return $this->Supplier_Invoice_Data;
    }
    /**
     * Set Supplier_Invoice_Data value
     * @param \StructType\Supplier_Invoice__HV__DataType $supplier_Invoice_Data
     * @return \StructType\Import_Supplier_Invoice_RequestType
     */
    public function setSupplier_Invoice_Data(\StructType\Supplier_Invoice__HV__DataType $supplier_Invoice_Data = null)
    {
        $this->Supplier_Invoice_Data = $supplier_Invoice_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Import_Supplier_Invoice_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Import_Supplier_Invoice_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
