<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Hotel Reference and Hotel Data
 * @subpackage Structs
 */
class HotelType extends AbstractStructBase
{
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hotel Reference
     * - minOccurs: 0
     * @var \StructType\HotelObjectType
     */
    public $Hotel_Reference;
    /**
     * The Hotel_Data
     * Meta information extracted from the WSDL
     * - documentation: Hotel Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Hotel_DataType[]
     */
    public $Hotel_Data;
    /**
     * Constructor method for HotelType
     * @uses HotelType::setHotel_Reference()
     * @uses HotelType::setHotel_Data()
     * @param \StructType\HotelObjectType $hotel_Reference
     * @param \StructType\Hotel_DataType[] $hotel_Data
     */
    public function __construct(\StructType\HotelObjectType $hotel_Reference = null, array $hotel_Data = array())
    {
        $this
            ->setHotel_Reference($hotel_Reference)
            ->setHotel_Data($hotel_Data);
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * Set Hotel_Reference value
     * @param \StructType\HotelObjectType $hotel_Reference
     * @return \StructType\HotelType
     */
    public function setHotel_Reference(\StructType\HotelObjectType $hotel_Reference = null)
    {
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Get Hotel_Data value
     * @return \StructType\Hotel_DataType[]|null
     */
    public function getHotel_Data()
    {
        return $this->Hotel_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotel_DataForArrayConstraintsFromSetHotel_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelTypeHotel_DataItem) {
            // validation for constraint: itemType
            if (!$hotelTypeHotel_DataItem instanceof \StructType\Hotel_DataType) {
                $invalidValues[] = is_object($hotelTypeHotel_DataItem) ? get_class($hotelTypeHotel_DataItem) : sprintf('%s(%s)', gettype($hotelTypeHotel_DataItem), var_export($hotelTypeHotel_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel_Data property can only contain items of type \StructType\Hotel_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_DataType[] $hotel_Data
     * @return \StructType\HotelType
     */
    public function setHotel_Data(array $hotel_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($hotel_DataArrayErrorMessage = self::validateHotel_DataForArrayConstraintsFromSetHotel_Data($hotel_Data))) {
            throw new \InvalidArgumentException($hotel_DataArrayErrorMessage, __LINE__);
        }
        $this->Hotel_Data = $hotel_Data;
        return $this;
    }
    /**
     * Add item to Hotel_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_DataType $item
     * @return \StructType\HotelType
     */
    public function addToHotel_Data(\StructType\Hotel_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel_DataType) {
            throw new \InvalidArgumentException(sprintf('The Hotel_Data property can only contain items of type \StructType\Hotel_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel_Data[] = $item;
        return $this;
    }
}
