<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Adjustment_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier reference is for a supplier that can be used as a basic worktag only. | Invoice Due Date On or After must be earlier than Invoice Due Date On or Before. | Invoice Date On or After must be before Invoice Date On or Before. |
 * Element containing Supplier Invoice Adjustment request criteria
 * @subpackage Structs
 */
class Supplier_Invoice_Adjustment_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing instance of Business Entity Status Value
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Status_ValueObjectType[]
     */
    public $Supplier_Status_Reference;
    /**
     * The Invoice_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date_On_or_After;
    /**
     * The Invoice_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Invoice Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date_On_or_Before;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Supplier_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing supplier that has child suppliers
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Hierarchy_Reference;
    /**
     * The Invoice_On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Boolean that indicates that the invoice is on hold
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Invoice_On_Hold;
    /**
     * The Intercompany_Invoice
     * Meta information extracted from the WSDL
     * - documentation: Boolean that indicates that the invoice is an intercompany invoice
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Intercompany_Invoice;
    /**
     * The Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Payment Status. Examples of Payment Status are Draft, In Progress, Approved
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType[]
     */
    public $Payment_Status_Reference;
    /**
     * The Adjustment_Reasons_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Adjustment Reason
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Invoice_Adjustment_ReasonObjectType[]
     */
    public $Adjustment_Reasons_Reference;
    /**
     * The Invoice_Due_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Invoice Due Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Due_Date_On_or_After;
    /**
     * The Invoice_Due_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Invoice Due Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Due_Date_On_or_Before;
    /**
     * The Created_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker who created the transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Created_By_Worker_Reference;
    /**
     * The Approving_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker who approved the invoice
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Approving_Worker_Reference;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: All or part of an External PO Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing invoice Document Status. Examples of Document Status are Approved, Canceled, Denied
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Invoice_Status_Reference;
    /**
     * Constructor method for Supplier_Invoice_Adjustment_Request_CriteriaType
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setSupplier_Status_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setInvoice_Date_On_or_After()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setInvoice_Date_On_or_Before()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setSupplier_Hierarchy_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setInvoice_On_Hold()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setIntercompany_Invoice()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setPayment_Status_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setAdjustment_Reasons_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setInvoice_Due_Date_On_or_After()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setInvoice_Due_Date_On_or_Before()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setCreated_By_Worker_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setApproving_Worker_Reference()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setExternal_PO_Number()
     * @uses Supplier_Invoice_Adjustment_Request_CriteriaType::setInvoice_Status_Reference()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Business_Entity_Status_ValueObjectType[] $supplier_Status_Reference
     * @param string $invoice_Date_On_or_After
     * @param string $invoice_Date_On_or_Before
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\SupplierObjectType[] $supplier_Hierarchy_Reference
     * @param bool $invoice_On_Hold
     * @param bool $intercompany_Invoice
     * @param \StructType\Document_Payment_StatusObjectType[] $payment_Status_Reference
     * @param \StructType\Invoice_Adjustment_ReasonObjectType[] $adjustment_Reasons_Reference
     * @param string $invoice_Due_Date_On_or_After
     * @param string $invoice_Due_Date_On_or_Before
     * @param \StructType\WorkerObjectType[] $created_By_Worker_Reference
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @param string $external_PO_Number
     * @param \StructType\Document_StatusObjectType[] $invoice_Status_Reference
     */
    public function __construct(array $company_Reference = array(), array $supplier_Reference = array(), array $supplier_Status_Reference = array(), $invoice_Date_On_or_After = null, $invoice_Date_On_or_Before = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, array $supplier_Hierarchy_Reference = array(), $invoice_On_Hold = null, $intercompany_Invoice = null, array $payment_Status_Reference = array(), array $adjustment_Reasons_Reference = array(), $invoice_Due_Date_On_or_After = null, $invoice_Due_Date_On_or_Before = null, array $created_By_Worker_Reference = array(), array $approving_Worker_Reference = array(), $external_PO_Number = null, array $invoice_Status_Reference = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Status_Reference($supplier_Status_Reference)
            ->setInvoice_Date_On_or_After($invoice_Date_On_or_After)
            ->setInvoice_Date_On_or_Before($invoice_Date_On_or_Before)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setSupplier_Hierarchy_Reference($supplier_Hierarchy_Reference)
            ->setInvoice_On_Hold($invoice_On_Hold)
            ->setIntercompany_Invoice($intercompany_Invoice)
            ->setPayment_Status_Reference($payment_Status_Reference)
            ->setAdjustment_Reasons_Reference($adjustment_Reasons_Reference)
            ->setInvoice_Due_Date_On_or_After($invoice_Due_Date_On_or_After)
            ->setInvoice_Due_Date_On_or_Before($invoice_Due_Date_On_or_Before)
            ->setCreated_By_Worker_Reference($created_By_Worker_Reference)
            ->setApproving_Worker_Reference($approving_Worker_Reference)
            ->setExternal_PO_Number($external_PO_Number)
            ->setInvoice_Status_Reference($invoice_Status_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Status_Reference value
     * @return \StructType\Business_Entity_Status_ValueObjectType[]|null
     */
    public function getSupplier_Status_Reference()
    {
        return $this->Supplier_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Status_ReferenceForArrayConstraintsFromSetSupplier_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Status_ReferenceItem instanceof \StructType\Business_Entity_Status_ValueObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Status_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Status_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Status_Reference property can only contain items of type \StructType\Business_Entity_Status_ValueObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Status_ValueObjectType[] $supplier_Status_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setSupplier_Status_Reference(array $supplier_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Status_ReferenceArrayErrorMessage = self::validateSupplier_Status_ReferenceForArrayConstraintsFromSetSupplier_Status_Reference($supplier_Status_Reference))) {
            throw new \InvalidArgumentException($supplier_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Status_Reference = $supplier_Status_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Status_ValueObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToSupplier_Status_Reference(\StructType\Business_Entity_Status_ValueObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Entity_Status_ValueObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Status_Reference property can only contain items of type \StructType\Business_Entity_Status_ValueObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Date_On_or_After value
     * @return string|null
     */
    public function getInvoice_Date_On_or_After()
    {
        return $this->Invoice_Date_On_or_After;
    }
    /**
     * Set Invoice_Date_On_or_After value
     * @param string $invoice_Date_On_or_After
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setInvoice_Date_On_or_After($invoice_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date_On_or_After) && !is_string($invoice_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date_On_or_After, true), gettype($invoice_Date_On_or_After)), __LINE__);
        }
        $this->Invoice_Date_On_or_After = $invoice_Date_On_or_After;
        return $this;
    }
    /**
     * Get Invoice_Date_On_or_Before value
     * @return string|null
     */
    public function getInvoice_Date_On_or_Before()
    {
        return $this->Invoice_Date_On_or_Before;
    }
    /**
     * Set Invoice_Date_On_or_Before value
     * @param string $invoice_Date_On_or_Before
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setInvoice_Date_On_or_Before($invoice_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date_On_or_Before) && !is_string($invoice_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date_On_or_Before, true), gettype($invoice_Date_On_or_Before)), __LINE__);
        }
        $this->Invoice_Date_On_or_Before = $invoice_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Supplier_Hierarchy_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Hierarchy_Reference()
    {
        return $this->Supplier_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Hierarchy_ReferenceForArrayConstraintsFromSetSupplier_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Hierarchy_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Hierarchy_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Hierarchy_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeSupplier_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Hierarchy_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Hierarchy_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setSupplier_Hierarchy_Reference(array $supplier_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Hierarchy_ReferenceArrayErrorMessage = self::validateSupplier_Hierarchy_ReferenceForArrayConstraintsFromSetSupplier_Hierarchy_Reference($supplier_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($supplier_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Hierarchy_Reference = $supplier_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToSupplier_Hierarchy_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Hierarchy_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_On_Hold value
     * @return bool|null
     */
    public function getInvoice_On_Hold()
    {
        return $this->Invoice_On_Hold;
    }
    /**
     * Set Invoice_On_Hold value
     * @param bool $invoice_On_Hold
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setInvoice_On_Hold($invoice_On_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoice_On_Hold) && !is_bool($invoice_On_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoice_On_Hold, true), gettype($invoice_On_Hold)), __LINE__);
        }
        $this->Invoice_On_Hold = $invoice_On_Hold;
        return $this;
    }
    /**
     * Get Intercompany_Invoice value
     * @return bool|null
     */
    public function getIntercompany_Invoice()
    {
        return $this->Intercompany_Invoice;
    }
    /**
     * Set Intercompany_Invoice value
     * @param bool $intercompany_Invoice
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setIntercompany_Invoice($intercompany_Invoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($intercompany_Invoice) && !is_bool($intercompany_Invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($intercompany_Invoice, true), gettype($intercompany_Invoice)), __LINE__);
        }
        $this->Intercompany_Invoice = $intercompany_Invoice;
        return $this;
    }
    /**
     * Get Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType[]|null
     */
    public function getPayment_Status_Reference()
    {
        return $this->Payment_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayment_Status_ReferenceForArrayConstraintsFromSetPayment_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypePayment_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypePayment_Status_ReferenceItem instanceof \StructType\Document_Payment_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypePayment_Status_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypePayment_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypePayment_Status_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypePayment_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment_Status_Reference property can only contain items of type \StructType\Document_Payment_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Payment_StatusObjectType[] $payment_Status_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setPayment_Status_Reference(array $payment_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($payment_Status_ReferenceArrayErrorMessage = self::validatePayment_Status_ReferenceForArrayConstraintsFromSetPayment_Status_Reference($payment_Status_Reference))) {
            throw new \InvalidArgumentException($payment_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Payment_Status_Reference = $payment_Status_Reference;
        return $this;
    }
    /**
     * Add item to Payment_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Payment_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToPayment_Status_Reference(\StructType\Document_Payment_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_Payment_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Payment_Status_Reference property can only contain items of type \StructType\Document_Payment_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Adjustment_Reasons_Reference value
     * @return \StructType\Invoice_Adjustment_ReasonObjectType[]|null
     */
    public function getAdjustment_Reasons_Reference()
    {
        return $this->Adjustment_Reasons_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdjustment_Reasons_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdjustment_Reasons_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdjustment_Reasons_ReferenceForArrayConstraintsFromSetAdjustment_Reasons_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeAdjustment_Reasons_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeAdjustment_Reasons_ReferenceItem instanceof \StructType\Invoice_Adjustment_ReasonObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeAdjustment_Reasons_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeAdjustment_Reasons_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeAdjustment_Reasons_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeAdjustment_Reasons_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Adjustment_Reasons_Reference property can only contain items of type \StructType\Invoice_Adjustment_ReasonObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Adjustment_Reasons_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_Adjustment_ReasonObjectType[] $adjustment_Reasons_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setAdjustment_Reasons_Reference(array $adjustment_Reasons_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($adjustment_Reasons_ReferenceArrayErrorMessage = self::validateAdjustment_Reasons_ReferenceForArrayConstraintsFromSetAdjustment_Reasons_Reference($adjustment_Reasons_Reference))) {
            throw new \InvalidArgumentException($adjustment_Reasons_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Adjustment_Reasons_Reference = $adjustment_Reasons_Reference;
        return $this;
    }
    /**
     * Add item to Adjustment_Reasons_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_Adjustment_ReasonObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToAdjustment_Reasons_Reference(\StructType\Invoice_Adjustment_ReasonObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Invoice_Adjustment_ReasonObjectType) {
            throw new \InvalidArgumentException(sprintf('The Adjustment_Reasons_Reference property can only contain items of type \StructType\Invoice_Adjustment_ReasonObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Adjustment_Reasons_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Due_Date_On_or_After value
     * @return string|null
     */
    public function getInvoice_Due_Date_On_or_After()
    {
        return $this->Invoice_Due_Date_On_or_After;
    }
    /**
     * Set Invoice_Due_Date_On_or_After value
     * @param string $invoice_Due_Date_On_or_After
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setInvoice_Due_Date_On_or_After($invoice_Due_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Due_Date_On_or_After) && !is_string($invoice_Due_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Due_Date_On_or_After, true), gettype($invoice_Due_Date_On_or_After)), __LINE__);
        }
        $this->Invoice_Due_Date_On_or_After = $invoice_Due_Date_On_or_After;
        return $this;
    }
    /**
     * Get Invoice_Due_Date_On_or_Before value
     * @return string|null
     */
    public function getInvoice_Due_Date_On_or_Before()
    {
        return $this->Invoice_Due_Date_On_or_Before;
    }
    /**
     * Set Invoice_Due_Date_On_or_Before value
     * @param string $invoice_Due_Date_On_or_Before
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setInvoice_Due_Date_On_or_Before($invoice_Due_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Due_Date_On_or_Before) && !is_string($invoice_Due_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Due_Date_On_or_Before, true), gettype($invoice_Due_Date_On_or_Before)), __LINE__);
        }
        $this->Invoice_Due_Date_On_or_Before = $invoice_Due_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Created_By_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreated_By_Worker_Reference()
    {
        return $this->Created_By_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreated_By_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreated_By_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreated_By_Worker_ReferenceForArrayConstraintsFromSetCreated_By_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeCreated_By_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeCreated_By_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeCreated_By_Worker_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeCreated_By_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeCreated_By_Worker_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeCreated_By_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Created_By_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Created_By_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $created_By_Worker_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setCreated_By_Worker_Reference(array $created_By_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($created_By_Worker_ReferenceArrayErrorMessage = self::validateCreated_By_Worker_ReferenceForArrayConstraintsFromSetCreated_By_Worker_Reference($created_By_Worker_Reference))) {
            throw new \InvalidArgumentException($created_By_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Created_By_Worker_Reference = $created_By_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Created_By_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToCreated_By_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Created_By_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Created_By_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approving_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getApproving_Worker_Reference()
    {
        return $this->Approving_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApproving_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproving_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeApproving_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeApproving_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeApproving_Worker_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeApproving_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeApproving_Worker_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeApproving_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setApproving_Worker_Reference(array $approving_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($approving_Worker_ReferenceArrayErrorMessage = self::validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference($approving_Worker_Reference))) {
            throw new \InvalidArgumentException($approving_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Approving_Worker_Reference = $approving_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToApproving_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approving_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_Status_ReferenceForArrayConstraintsFromSetInvoice_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Adjustment_Request_CriteriaTypeInvoice_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Adjustment_Request_CriteriaTypeInvoice_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Adjustment_Request_CriteriaTypeInvoice_Status_ReferenceItem) ? get_class($supplier_Invoice_Adjustment_Request_CriteriaTypeInvoice_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Adjustment_Request_CriteriaTypeInvoice_Status_ReferenceItem), var_export($supplier_Invoice_Adjustment_Request_CriteriaTypeInvoice_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $invoice_Status_Reference
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function setInvoice_Status_Reference(array $invoice_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_Status_ReferenceArrayErrorMessage = self::validateInvoice_Status_ReferenceForArrayConstraintsFromSetInvoice_Status_Reference($invoice_Status_Reference))) {
            throw new \InvalidArgumentException($invoice_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Add item to Invoice_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Supplier_Invoice_Adjustment_Request_CriteriaType
     */
    public function addToInvoice_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Status_Reference[] = $item;
        return $this;
    }
}
