<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Lease_Amendment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Contract Amendment Data
 * @subpackage Structs
 */
class Supplier_Contract_Lease_Amendment_DataType extends AbstractStructBase
{
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Supplier_Contract_To_Amend_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference for Amendment
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_To_Amend_Reference;
    /**
     * The Supplier_Contract_Lease_Amendment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Amendment Type for Lease Contract Amendment
     * @var \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType
     */
    public $Supplier_Contract_Lease_Amendment_Type_Reference;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Lease Contract.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Name;
    /**
     * The Amendment_Signed_Date
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Signed Date
     * - maxOccurs: 1
     * @var string
     */
    public $Amendment_Signed_Date;
    /**
     * The Lease_Liability_Reassessment_Date
     * Meta information extracted from the WSDL
     * - documentation: Lease Liability Reassessment Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lease_Liability_Reassessment_Date;
    /**
     * The Payment_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Amendment Payment Effective Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Effective_Date;
    /**
     * The Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date;
    /**
     * The Amendment_Description
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amendment_Description;
    /**
     * The Amendment_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Amendment_Number;
    /**
     * The Total_Contract_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Contract Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Contract_Amount;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The payment type to use if it differs from the default payment type from the Supplier. This is used for all contract types except ones that have scheduled invoices
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Lease_Details_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that contains details specific to Lease Contract Amendment
     * - minOccurs: 0
     * @var \StructType\Lease_Details_Amendment_DataType
     */
    public $Lease_Details_Data;
    /**
     * The Lease_Payment_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Lease_Payment_Line_Replacement_DataType[]
     */
    public $Lease_Payment_Line_Replacement_Data;
    /**
     * The Alternate_Contract_Interest_Rate_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Contract_Interest_Rate_DataType[]
     */
    public $Alternate_Contract_Interest_Rate_Data;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for Transaction Selected
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Supplier_Contract_Lease_Amendment_DataType
     * @uses Supplier_Contract_Lease_Amendment_DataType::setSubmit()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setSupplier_Contract_To_Amend_Reference()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setSupplier_Contract_Lease_Amendment_Type_Reference()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setContract_Name()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setAmendment_Signed_Date()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setLease_Liability_Reassessment_Date()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setPayment_Effective_Date()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setContract_End_Date()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setAmendment_Description()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setAmendment_Number()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setTotal_Contract_Amount()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setOverride_Payment_Type_Reference()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setLease_Details_Data()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setLease_Payment_Line_Replacement_Data()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setAlternate_Contract_Interest_Rate_Data()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setCurrency_Reference()
     * @uses Supplier_Contract_Lease_Amendment_DataType::setAttachment_Data()
     * @param bool $submit
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference
     * @param \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference
     * @param string $contract_Name
     * @param string $amendment_Signed_Date
     * @param string $lease_Liability_Reassessment_Date
     * @param string $payment_Effective_Date
     * @param string $contract_End_Date
     * @param string $amendment_Description
     * @param string $amendment_Number
     * @param float $total_Contract_Amount
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param \StructType\Lease_Details_Amendment_DataType $lease_Details_Data
     * @param \StructType\Lease_Payment_Line_Replacement_DataType[] $lease_Payment_Line_Replacement_Data
     * @param \StructType\Alternate_Contract_Interest_Rate_DataType[] $alternate_Contract_Interest_Rate_Data
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct($submit = null, \StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference = null, \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference = null, $contract_Name = null, $amendment_Signed_Date = null, $lease_Liability_Reassessment_Date = null, $payment_Effective_Date = null, $contract_End_Date = null, $amendment_Description = null, $amendment_Number = null, $total_Contract_Amount = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, \StructType\Lease_Details_Amendment_DataType $lease_Details_Data = null, array $lease_Payment_Line_Replacement_Data = array(), array $alternate_Contract_Interest_Rate_Data = array(), \StructType\CurrencyObjectType $currency_Reference = null, array $attachment_Data = array())
    {
        $this
            ->setSubmit($submit)
            ->setSupplier_Contract_To_Amend_Reference($supplier_Contract_To_Amend_Reference)
            ->setSupplier_Contract_Lease_Amendment_Type_Reference($supplier_Contract_Lease_Amendment_Type_Reference)
            ->setContract_Name($contract_Name)
            ->setAmendment_Signed_Date($amendment_Signed_Date)
            ->setLease_Liability_Reassessment_Date($lease_Liability_Reassessment_Date)
            ->setPayment_Effective_Date($payment_Effective_Date)
            ->setContract_End_Date($contract_End_Date)
            ->setAmendment_Description($amendment_Description)
            ->setAmendment_Number($amendment_Number)
            ->setTotal_Contract_Amount($total_Contract_Amount)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setLease_Details_Data($lease_Details_Data)
            ->setLease_Payment_Line_Replacement_Data($lease_Payment_Line_Replacement_Data)
            ->setAlternate_Contract_Interest_Rate_Data($alternate_Contract_Interest_Rate_Data)
            ->setCurrency_Reference($currency_Reference)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Supplier_Contract_To_Amend_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_To_Amend_Reference()
    {
        return $this->Supplier_Contract_To_Amend_Reference;
    }
    /**
     * Set Supplier_Contract_To_Amend_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setSupplier_Contract_To_Amend_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_To_Amend_Reference = null)
    {
        $this->Supplier_Contract_To_Amend_Reference = $supplier_Contract_To_Amend_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Lease_Amendment_Type_Reference value
     * @return \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType|null
     */
    public function getSupplier_Contract_Lease_Amendment_Type_Reference()
    {
        return $this->Supplier_Contract_Lease_Amendment_Type_Reference;
    }
    /**
     * Set Supplier_Contract_Lease_Amendment_Type_Reference value
     * @param \StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setSupplier_Contract_Lease_Amendment_Type_Reference(\StructType\Supplier_Contract_Lease_Amendment_TypeObjectType $supplier_Contract_Lease_Amendment_Type_Reference = null)
    {
        $this->Supplier_Contract_Lease_Amendment_Type_Reference = $supplier_Contract_Lease_Amendment_Type_Reference;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Amendment_Signed_Date value
     * @return string|null
     */
    public function getAmendment_Signed_Date()
    {
        return $this->Amendment_Signed_Date;
    }
    /**
     * Set Amendment_Signed_Date value
     * @param string $amendment_Signed_Date
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setAmendment_Signed_Date($amendment_Signed_Date = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Signed_Date) && !is_string($amendment_Signed_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Signed_Date, true), gettype($amendment_Signed_Date)), __LINE__);
        }
        $this->Amendment_Signed_Date = $amendment_Signed_Date;
        return $this;
    }
    /**
     * Get Lease_Liability_Reassessment_Date value
     * @return string|null
     */
    public function getLease_Liability_Reassessment_Date()
    {
        return $this->Lease_Liability_Reassessment_Date;
    }
    /**
     * Set Lease_Liability_Reassessment_Date value
     * @param string $lease_Liability_Reassessment_Date
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setLease_Liability_Reassessment_Date($lease_Liability_Reassessment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($lease_Liability_Reassessment_Date) && !is_string($lease_Liability_Reassessment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lease_Liability_Reassessment_Date, true), gettype($lease_Liability_Reassessment_Date)), __LINE__);
        }
        $this->Lease_Liability_Reassessment_Date = $lease_Liability_Reassessment_Date;
        return $this;
    }
    /**
     * Get Payment_Effective_Date value
     * @return string|null
     */
    public function getPayment_Effective_Date()
    {
        return $this->Payment_Effective_Date;
    }
    /**
     * Set Payment_Effective_Date value
     * @param string $payment_Effective_Date
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setPayment_Effective_Date($payment_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Effective_Date) && !is_string($payment_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Effective_Date, true), gettype($payment_Effective_Date)), __LINE__);
        }
        $this->Payment_Effective_Date = $payment_Effective_Date;
        return $this;
    }
    /**
     * Get Contract_End_Date value
     * @return string|null
     */
    public function getContract_End_Date()
    {
        return $this->Contract_End_Date;
    }
    /**
     * Set Contract_End_Date value
     * @param string $contract_End_Date
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setContract_End_Date($contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date) && !is_string($contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date, true), gettype($contract_End_Date)), __LINE__);
        }
        $this->Contract_End_Date = $contract_End_Date;
        return $this;
    }
    /**
     * Get Amendment_Description value
     * @return string|null
     */
    public function getAmendment_Description()
    {
        return $this->Amendment_Description;
    }
    /**
     * Set Amendment_Description value
     * @param string $amendment_Description
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setAmendment_Description($amendment_Description = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Description) && !is_string($amendment_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Description, true), gettype($amendment_Description)), __LINE__);
        }
        $this->Amendment_Description = $amendment_Description;
        return $this;
    }
    /**
     * Get Amendment_Number value
     * @return string|null
     */
    public function getAmendment_Number()
    {
        return $this->Amendment_Number;
    }
    /**
     * Set Amendment_Number value
     * @param string $amendment_Number
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setAmendment_Number($amendment_Number = null)
    {
        // validation for constraint: string
        if (!is_null($amendment_Number) && !is_string($amendment_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendment_Number, true), gettype($amendment_Number)), __LINE__);
        }
        $this->Amendment_Number = $amendment_Number;
        return $this;
    }
    /**
     * Get Total_Contract_Amount value
     * @return float|null
     */
    public function getTotal_Contract_Amount()
    {
        return $this->Total_Contract_Amount;
    }
    /**
     * Set Total_Contract_Amount value
     * @param float $total_Contract_Amount
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setTotal_Contract_Amount($total_Contract_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Contract_Amount) && !(is_float($total_Contract_Amount) || is_numeric($total_Contract_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Contract_Amount, true), gettype($total_Contract_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Contract_Amount) && mb_strlen(mb_substr($total_Contract_Amount, false !== mb_strpos($total_Contract_Amount, '.') ? mb_strpos($total_Contract_Amount, '.') + 1 : mb_strlen($total_Contract_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Contract_Amount, true), mb_strlen(mb_substr($total_Contract_Amount, mb_strpos($total_Contract_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($total_Contract_Amount) && $total_Contract_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($total_Contract_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Contract_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Contract_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount))), __LINE__);
        }
        $this->Total_Contract_Amount = $total_Contract_Amount;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Lease_Details_Data value
     * @return \StructType\Lease_Details_Amendment_DataType|null
     */
    public function getLease_Details_Data()
    {
        return $this->Lease_Details_Data;
    }
    /**
     * Set Lease_Details_Data value
     * @param \StructType\Lease_Details_Amendment_DataType $lease_Details_Data
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setLease_Details_Data(\StructType\Lease_Details_Amendment_DataType $lease_Details_Data = null)
    {
        $this->Lease_Details_Data = $lease_Details_Data;
        return $this;
    }
    /**
     * Get Lease_Payment_Line_Replacement_Data value
     * @return \StructType\Lease_Payment_Line_Replacement_DataType[]|null
     */
    public function getLease_Payment_Line_Replacement_Data()
    {
        return $this->Lease_Payment_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLease_Payment_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLease_Payment_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLease_Payment_Line_Replacement_DataForArrayConstraintsFromSetLease_Payment_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Lease_Amendment_DataTypeLease_Payment_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Lease_Amendment_DataTypeLease_Payment_Line_Replacement_DataItem instanceof \StructType\Lease_Payment_Line_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Contract_Lease_Amendment_DataTypeLease_Payment_Line_Replacement_DataItem) ? get_class($supplier_Contract_Lease_Amendment_DataTypeLease_Payment_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_Lease_Amendment_DataTypeLease_Payment_Line_Replacement_DataItem), var_export($supplier_Contract_Lease_Amendment_DataTypeLease_Payment_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lease_Payment_Line_Replacement_Data property can only contain items of type \StructType\Lease_Payment_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lease_Payment_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Lease_Payment_Line_Replacement_DataType[] $lease_Payment_Line_Replacement_Data
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setLease_Payment_Line_Replacement_Data(array $lease_Payment_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($lease_Payment_Line_Replacement_DataArrayErrorMessage = self::validateLease_Payment_Line_Replacement_DataForArrayConstraintsFromSetLease_Payment_Line_Replacement_Data($lease_Payment_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($lease_Payment_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Lease_Payment_Line_Replacement_Data = $lease_Payment_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Lease_Payment_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Lease_Payment_Line_Replacement_DataType $item
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function addToLease_Payment_Line_Replacement_Data(\StructType\Lease_Payment_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Lease_Payment_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Lease_Payment_Line_Replacement_Data property can only contain items of type \StructType\Lease_Payment_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lease_Payment_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Alternate_Contract_Interest_Rate_Data value
     * @return \StructType\Alternate_Contract_Interest_Rate_DataType[]|null
     */
    public function getAlternate_Contract_Interest_Rate_Data()
    {
        return $this->Alternate_Contract_Interest_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Contract_Interest_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Contract_Interest_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Contract_Interest_Rate_DataForArrayConstraintsFromSetAlternate_Contract_Interest_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Lease_Amendment_DataTypeAlternate_Contract_Interest_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Lease_Amendment_DataTypeAlternate_Contract_Interest_Rate_DataItem instanceof \StructType\Alternate_Contract_Interest_Rate_DataType) {
                $invalidValues[] = is_object($supplier_Contract_Lease_Amendment_DataTypeAlternate_Contract_Interest_Rate_DataItem) ? get_class($supplier_Contract_Lease_Amendment_DataTypeAlternate_Contract_Interest_Rate_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_Lease_Amendment_DataTypeAlternate_Contract_Interest_Rate_DataItem), var_export($supplier_Contract_Lease_Amendment_DataTypeAlternate_Contract_Interest_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Contract_Interest_Rate_Data property can only contain items of type \StructType\Alternate_Contract_Interest_Rate_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Contract_Interest_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Contract_Interest_Rate_DataType[] $alternate_Contract_Interest_Rate_Data
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setAlternate_Contract_Interest_Rate_Data(array $alternate_Contract_Interest_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Contract_Interest_Rate_DataArrayErrorMessage = self::validateAlternate_Contract_Interest_Rate_DataForArrayConstraintsFromSetAlternate_Contract_Interest_Rate_Data($alternate_Contract_Interest_Rate_Data))) {
            throw new \InvalidArgumentException($alternate_Contract_Interest_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Contract_Interest_Rate_Data = $alternate_Contract_Interest_Rate_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Contract_Interest_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Contract_Interest_Rate_DataType $item
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function addToAlternate_Contract_Interest_Rate_Data(\StructType\Alternate_Contract_Interest_Rate_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Contract_Interest_Rate_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Contract_Interest_Rate_Data property can only contain items of type \StructType\Alternate_Contract_Interest_Rate_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Contract_Interest_Rate_Data[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Lease_Amendment_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Lease_Amendment_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($supplier_Contract_Lease_Amendment_DataTypeAttachment_DataItem) ? get_class($supplier_Contract_Lease_Amendment_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_Lease_Amendment_DataTypeAttachment_DataItem), var_export($supplier_Contract_Lease_Amendment_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Supplier_Contract_Lease_Amendment_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
