<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Return_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Return Date On or After must be earlier than Return Date On or Before | Utilize the following element to find returns in the Workday system.
 * @subpackage Structs
 */
class Return_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Return_Number
     * Meta information extracted from the WSDL
     * - documentation: Requisition Number
     * - base: xsd:string
     * - maxLength: 513
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Return_Number;
    /**
     * The Return_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Return Status. Examples of Document Status are Approved, Denied, Draft, In Progress
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Return_Status_Reference;
    /**
     * The Return_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Return Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Return_Date_On_or_After;
    /**
     * The Return_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Return Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Return_Date_On_or_Before;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Return_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Return Reason
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Return_to_Supplier_ReasonObjectType[]
     */
    public $Return_Reason_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - choice: Purchase_Order_Reference | Supplier_Contract_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract
     * - choice: Purchase_Order_Reference | Supplier_Contract_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an Item on the Return
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType[]
     */
    public $Item_Reference;
    /**
     * The Supplier_RMA
     * Meta information extracted from the WSDL
     * - documentation: Supplier RMA on the Return
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_RMA;
    /**
     * The Created_by_Person_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Person who created the Return
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Created_by_Person_Reference;
    /**
     * The Approving_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker who approved the Return
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Approving_Worker_Reference;
    /**
     * Constructor method for Return_Request_CriteriaType
     * @uses Return_Request_CriteriaType::setCompany_Reference()
     * @uses Return_Request_CriteriaType::setReturn_Number()
     * @uses Return_Request_CriteriaType::setReturn_Status_Reference()
     * @uses Return_Request_CriteriaType::setReturn_Date_On_or_After()
     * @uses Return_Request_CriteriaType::setReturn_Date_On_or_Before()
     * @uses Return_Request_CriteriaType::setSupplier_Reference()
     * @uses Return_Request_CriteriaType::setReturn_Reason_Reference()
     * @uses Return_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Return_Request_CriteriaType::setSupplier_Contract_Reference()
     * @uses Return_Request_CriteriaType::setSpend_Category_Reference()
     * @uses Return_Request_CriteriaType::setItem_Reference()
     * @uses Return_Request_CriteriaType::setSupplier_RMA()
     * @uses Return_Request_CriteriaType::setCreated_by_Person_Reference()
     * @uses Return_Request_CriteriaType::setApproving_Worker_Reference()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param string $return_Number
     * @param \StructType\Document_StatusObjectType[] $return_Status_Reference
     * @param string $return_Date_On_or_After
     * @param string $return_Date_On_or_Before
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Return_to_Supplier_ReasonObjectType[] $return_Reason_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @param \StructType\Procurement_ItemObjectType[] $item_Reference
     * @param string $supplier_RMA
     * @param \StructType\Unique_IdentifierObjectType[] $created_by_Person_Reference
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     */
    public function __construct(array $company_Reference = array(), $return_Number = null, array $return_Status_Reference = array(), $return_Date_On_or_After = null, $return_Date_On_or_Before = null, array $supplier_Reference = array(), array $return_Reason_Reference = array(), \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $spend_Category_Reference = array(), array $item_Reference = array(), $supplier_RMA = null, array $created_by_Person_Reference = array(), array $approving_Worker_Reference = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setReturn_Number($return_Number)
            ->setReturn_Status_Reference($return_Status_Reference)
            ->setReturn_Date_On_or_After($return_Date_On_or_After)
            ->setReturn_Date_On_or_Before($return_Date_On_or_Before)
            ->setSupplier_Reference($supplier_Reference)
            ->setReturn_Reason_Reference($return_Reason_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setItem_Reference($item_Reference)
            ->setSupplier_RMA($supplier_RMA)
            ->setCreated_by_Person_Reference($created_by_Person_Reference)
            ->setApproving_Worker_Reference($approving_Worker_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($return_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeCompany_ReferenceItem), var_export($return_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Return_Number value
     * @return string|null
     */
    public function getReturn_Number()
    {
        return $this->Return_Number;
    }
    /**
     * Set Return_Number value
     * @param string $return_Number
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setReturn_Number($return_Number = null)
    {
        // validation for constraint: string
        if (!is_null($return_Number) && !is_string($return_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Number, true), gettype($return_Number)), __LINE__);
        }
        // validation for constraint: maxLength(513)
        if (!is_null($return_Number) && mb_strlen($return_Number) > 513) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 513', mb_strlen($return_Number)), __LINE__);
        }
        $this->Return_Number = $return_Number;
        return $this;
    }
    /**
     * Get Return_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getReturn_Status_Reference()
    {
        return $this->Return_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturn_Status_ReferenceForArrayConstraintsFromSetReturn_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeReturn_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeReturn_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeReturn_Status_ReferenceItem) ? get_class($return_Request_CriteriaTypeReturn_Status_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeReturn_Status_ReferenceItem), var_export($return_Request_CriteriaTypeReturn_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $return_Status_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setReturn_Status_Reference(array $return_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($return_Status_ReferenceArrayErrorMessage = self::validateReturn_Status_ReferenceForArrayConstraintsFromSetReturn_Status_Reference($return_Status_Reference))) {
            throw new \InvalidArgumentException($return_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Return_Status_Reference = $return_Status_Reference;
        return $this;
    }
    /**
     * Add item to Return_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToReturn_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Return_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Return_Date_On_or_After value
     * @return string|null
     */
    public function getReturn_Date_On_or_After()
    {
        return $this->Return_Date_On_or_After;
    }
    /**
     * Set Return_Date_On_or_After value
     * @param string $return_Date_On_or_After
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setReturn_Date_On_or_After($return_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($return_Date_On_or_After) && !is_string($return_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Date_On_or_After, true), gettype($return_Date_On_or_After)), __LINE__);
        }
        $this->Return_Date_On_or_After = $return_Date_On_or_After;
        return $this;
    }
    /**
     * Get Return_Date_On_or_Before value
     * @return string|null
     */
    public function getReturn_Date_On_or_Before()
    {
        return $this->Return_Date_On_or_Before;
    }
    /**
     * Set Return_Date_On_or_Before value
     * @param string $return_Date_On_or_Before
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setReturn_Date_On_or_Before($return_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($return_Date_On_or_Before) && !is_string($return_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Date_On_or_Before, true), gettype($return_Date_On_or_Before)), __LINE__);
        }
        $this->Return_Date_On_or_Before = $return_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($return_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeSupplier_ReferenceItem), var_export($return_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Return_Reason_Reference value
     * @return \StructType\Return_to_Supplier_ReasonObjectType[]|null
     */
    public function getReturn_Reason_Reference()
    {
        return $this->Return_Reason_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn_Reason_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn_Reason_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturn_Reason_ReferenceForArrayConstraintsFromSetReturn_Reason_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeReturn_Reason_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeReturn_Reason_ReferenceItem instanceof \StructType\Return_to_Supplier_ReasonObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeReturn_Reason_ReferenceItem) ? get_class($return_Request_CriteriaTypeReturn_Reason_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeReturn_Reason_ReferenceItem), var_export($return_Request_CriteriaTypeReturn_Reason_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return_Reason_Reference property can only contain items of type \StructType\Return_to_Supplier_ReasonObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return_Reason_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_ReasonObjectType[] $return_Reason_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setReturn_Reason_Reference(array $return_Reason_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($return_Reason_ReferenceArrayErrorMessage = self::validateReturn_Reason_ReferenceForArrayConstraintsFromSetReturn_Reason_Reference($return_Reason_Reference))) {
            throw new \InvalidArgumentException($return_Reason_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Return_Reason_Reference = $return_Reason_Reference;
        return $this;
    }
    /**
     * Add item to Return_Reason_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_ReasonObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToReturn_Reason_Reference(\StructType\Return_to_Supplier_ReasonObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Return_to_Supplier_ReasonObjectType) {
            throw new \InvalidArgumentException(sprintf('The Return_Reason_Reference property can only contain items of type \StructType\Return_to_Supplier_ReasonObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return_Reason_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return isset($this->Purchase_Order_Reference) ? $this->Purchase_Order_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPurchase_Order_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePurchase_Order_ReferenceForChoiceConstraintsFromSetPurchase_Order_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Contract_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Purchase_Order_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Purchase_Order_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Purchase_Order_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        // validation for constraint: choice(Purchase_Order_Reference, Supplier_Contract_Reference)
        if ('' !== ($purchase_Order_ReferenceChoiceErrorMessage = self::validatePurchase_Order_ReferenceForChoiceConstraintsFromSetPurchase_Order_Reference($purchase_Order_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($purchase_Order_Reference) || (is_array($purchase_Order_Reference) && empty($purchase_Order_Reference))) {
            unset($this->Purchase_Order_Reference);
        } else {
            $this->Purchase_Order_Reference = $purchase_Order_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return isset($this->Supplier_Contract_Reference) ? $this->Supplier_Contract_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Contract_ReferenceForChoiceConstraintsFromSetSupplier_Contract_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Purchase_Order_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Contract_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Contract_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Contract_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        // validation for constraint: choice(Purchase_Order_Reference, Supplier_Contract_Reference)
        if ('' !== ($supplier_Contract_ReferenceChoiceErrorMessage = self::validateSupplier_Contract_ReferenceForChoiceConstraintsFromSetSupplier_Contract_Reference($supplier_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Contract_Reference) || (is_array($supplier_Contract_Reference) && empty($supplier_Contract_Reference))) {
            unset($this->Supplier_Contract_Reference);
        } else {
            $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        }
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeSpend_Category_ReferenceItem) ? get_class($return_Request_CriteriaTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeSpend_Category_ReferenceItem), var_export($return_Request_CriteriaTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType[]|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_ReferenceForArrayConstraintsFromSetItem_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeItem_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeItem_ReferenceItem instanceof \StructType\Procurement_ItemObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeItem_ReferenceItem) ? get_class($return_Request_CriteriaTypeItem_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeItem_ReferenceItem), var_export($return_Request_CriteriaTypeItem_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Reference property can only contain items of type \StructType\Procurement_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_ItemObjectType[] $item_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setItem_Reference(array $item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_ReferenceArrayErrorMessage = self::validateItem_ReferenceForArrayConstraintsFromSetItem_Reference($item_Reference))) {
            throw new \InvalidArgumentException($item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Add item to Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_ItemObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToItem_Reference(\StructType\Procurement_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Reference property can only contain items of type \StructType\Procurement_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_RMA value
     * @return string|null
     */
    public function getSupplier_RMA()
    {
        return $this->Supplier_RMA;
    }
    /**
     * Set Supplier_RMA value
     * @param string $supplier_RMA
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setSupplier_RMA($supplier_RMA = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_RMA) && !is_string($supplier_RMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_RMA, true), gettype($supplier_RMA)), __LINE__);
        }
        $this->Supplier_RMA = $supplier_RMA;
        return $this;
    }
    /**
     * Get Created_by_Person_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getCreated_by_Person_Reference()
    {
        return $this->Created_by_Person_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreated_by_Person_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreated_by_Person_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreated_by_Person_ReferenceForArrayConstraintsFromSetCreated_by_Person_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeCreated_by_Person_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeCreated_by_Person_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeCreated_by_Person_ReferenceItem) ? get_class($return_Request_CriteriaTypeCreated_by_Person_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeCreated_by_Person_ReferenceItem), var_export($return_Request_CriteriaTypeCreated_by_Person_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Created_by_Person_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Created_by_Person_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $created_by_Person_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setCreated_by_Person_Reference(array $created_by_Person_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($created_by_Person_ReferenceArrayErrorMessage = self::validateCreated_by_Person_ReferenceForArrayConstraintsFromSetCreated_by_Person_Reference($created_by_Person_Reference))) {
            throw new \InvalidArgumentException($created_by_Person_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Created_by_Person_Reference = $created_by_Person_Reference;
        return $this;
    }
    /**
     * Add item to Created_by_Person_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToCreated_by_Person_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Created_by_Person_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Created_by_Person_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approving_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getApproving_Worker_Reference()
    {
        return $this->Approving_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApproving_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproving_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_CriteriaTypeApproving_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_CriteriaTypeApproving_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($return_Request_CriteriaTypeApproving_Worker_ReferenceItem) ? get_class($return_Request_CriteriaTypeApproving_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_CriteriaTypeApproving_Worker_ReferenceItem), var_export($return_Request_CriteriaTypeApproving_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @return \StructType\Return_Request_CriteriaType
     */
    public function setApproving_Worker_Reference(array $approving_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($approving_Worker_ReferenceArrayErrorMessage = self::validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference($approving_Worker_Reference))) {
            throw new \InvalidArgumentException($approving_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Approving_Worker_Reference = $approving_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Return_Request_CriteriaType
     */
    public function addToApproving_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approving_Worker_Reference[] = $item;
        return $this;
    }
}
