<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_External_Business_Entity_Contact_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Triggers the validation if the request is set to Add Only and the External Business Entity Contact already exists. | Primary Work Email is already in use. | Creates or updates an External Business Entity Contact. Does not use an
 * event.
 * @subpackage Structs
 */
class Put_External_Business_Entity_Contact_RequestType extends AbstractStructBase
{
    /**
     * The External_Business_Entity_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Entity Contact for update only purposes
     * - minOccurs: 0
     * @var \StructType\Business_Entity_ContactObjectType
     */
    public $External_Business_Entity_Contact_Reference;
    /**
     * The External_Business_Entity_Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: External Business Entity Contact Data
     * @var \StructType\External_Business_Entity_Contact_DataType
     */
    public $External_Business_Entity_Contact_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_External_Business_Entity_Contact_RequestType
     * @uses Put_External_Business_Entity_Contact_RequestType::setExternal_Business_Entity_Contact_Reference()
     * @uses Put_External_Business_Entity_Contact_RequestType::setExternal_Business_Entity_Contact_Data()
     * @uses Put_External_Business_Entity_Contact_RequestType::setAdd_Only()
     * @uses Put_External_Business_Entity_Contact_RequestType::setVersion()
     * @param \StructType\Business_Entity_ContactObjectType $external_Business_Entity_Contact_Reference
     * @param \StructType\External_Business_Entity_Contact_DataType $external_Business_Entity_Contact_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Business_Entity_ContactObjectType $external_Business_Entity_Contact_Reference = null, \StructType\External_Business_Entity_Contact_DataType $external_Business_Entity_Contact_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExternal_Business_Entity_Contact_Reference($external_Business_Entity_Contact_Reference)
            ->setExternal_Business_Entity_Contact_Data($external_Business_Entity_Contact_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get External_Business_Entity_Contact_Reference value
     * @return \StructType\Business_Entity_ContactObjectType|null
     */
    public function getExternal_Business_Entity_Contact_Reference()
    {
        return $this->External_Business_Entity_Contact_Reference;
    }
    /**
     * Set External_Business_Entity_Contact_Reference value
     * @param \StructType\Business_Entity_ContactObjectType $external_Business_Entity_Contact_Reference
     * @return \StructType\Put_External_Business_Entity_Contact_RequestType
     */
    public function setExternal_Business_Entity_Contact_Reference(\StructType\Business_Entity_ContactObjectType $external_Business_Entity_Contact_Reference = null)
    {
        $this->External_Business_Entity_Contact_Reference = $external_Business_Entity_Contact_Reference;
        return $this;
    }
    /**
     * Get External_Business_Entity_Contact_Data value
     * @return \StructType\External_Business_Entity_Contact_DataType|null
     */
    public function getExternal_Business_Entity_Contact_Data()
    {
        return $this->External_Business_Entity_Contact_Data;
    }
    /**
     * Set External_Business_Entity_Contact_Data value
     * @param \StructType\External_Business_Entity_Contact_DataType $external_Business_Entity_Contact_Data
     * @return \StructType\Put_External_Business_Entity_Contact_RequestType
     */
    public function setExternal_Business_Entity_Contact_Data(\StructType\External_Business_Entity_Contact_DataType $external_Business_Entity_Contact_Data = null)
    {
        $this->External_Business_Entity_Contact_Data = $external_Business_Entity_Contact_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_External_Business_Entity_Contact_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_External_Business_Entity_Contact_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
