<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Oder_Line_Worktags_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Worktags on Purchase Order line
 * @subpackage Structs
 */
class Purchase_Oder_Line_Worktags_DataType extends AbstractStructBase
{
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag on Purchase Order line
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType
     */
    public $Worktag_Reference;
    /**
     * The Accounting_Worktag_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Type on Purchase Order line.
     * - minOccurs: 0
     * @var \StructType\Accounting_Worktag_TypeObjectType
     */
    public $Accounting_Worktag_Type_Reference;
    /**
     * The Worktag_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of Worktag Type
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worktag_Name;
    /**
     * Constructor method for Purchase_Oder_Line_Worktags_DataType
     * @uses Purchase_Oder_Line_Worktags_DataType::setWorktag_Reference()
     * @uses Purchase_Oder_Line_Worktags_DataType::setAccounting_Worktag_Type_Reference()
     * @uses Purchase_Oder_Line_Worktags_DataType::setWorktag_Name()
     * @param \StructType\Accounting_WorktagObjectType $worktag_Reference
     * @param \StructType\Accounting_Worktag_TypeObjectType $accounting_Worktag_Type_Reference
     * @param string $worktag_Name
     */
    public function __construct(\StructType\Accounting_WorktagObjectType $worktag_Reference = null, \StructType\Accounting_Worktag_TypeObjectType $accounting_Worktag_Type_Reference = null, $worktag_Name = null)
    {
        $this
            ->setWorktag_Reference($worktag_Reference)
            ->setAccounting_Worktag_Type_Reference($accounting_Worktag_Type_Reference)
            ->setWorktag_Name($worktag_Name);
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * Set Worktag_Reference value
     * @param \StructType\Accounting_WorktagObjectType $worktag_Reference
     * @return \StructType\Purchase_Oder_Line_Worktags_DataType
     */
    public function setWorktag_Reference(\StructType\Accounting_WorktagObjectType $worktag_Reference = null)
    {
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Get Accounting_Worktag_Type_Reference value
     * @return \StructType\Accounting_Worktag_TypeObjectType|null
     */
    public function getAccounting_Worktag_Type_Reference()
    {
        return $this->Accounting_Worktag_Type_Reference;
    }
    /**
     * Set Accounting_Worktag_Type_Reference value
     * @param \StructType\Accounting_Worktag_TypeObjectType $accounting_Worktag_Type_Reference
     * @return \StructType\Purchase_Oder_Line_Worktags_DataType
     */
    public function setAccounting_Worktag_Type_Reference(\StructType\Accounting_Worktag_TypeObjectType $accounting_Worktag_Type_Reference = null)
    {
        $this->Accounting_Worktag_Type_Reference = $accounting_Worktag_Type_Reference;
        return $this;
    }
    /**
     * Get Worktag_Name value
     * @return string|null
     */
    public function getWorktag_Name()
    {
        return $this->Worktag_Name;
    }
    /**
     * Set Worktag_Name value
     * @param string $worktag_Name
     * @return \StructType\Purchase_Oder_Line_Worktags_DataType
     */
    public function setWorktag_Name($worktag_Name = null)
    {
        // validation for constraint: string
        if (!is_null($worktag_Name) && !is_string($worktag_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worktag_Name, true), gettype($worktag_Name)), __LINE__);
        }
        $this->Worktag_Name = $worktag_Name;
        return $this;
    }
}
