<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Projects_Hierarchy_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Projects Hierarchy Response Data from WS.
 * @subpackage Structs
 */
class Projects_Hierarchy_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Hierarchy
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchy Element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Projects_HierarchyType[]
     */
    public $Project_Hierarchy;
    /**
     * Constructor method for Projects_Hierarchy_Response_DataType
     * @uses Projects_Hierarchy_Response_DataType::setProject_Hierarchy()
     * @param \StructType\Projects_HierarchyType[] $project_Hierarchy
     */
    public function __construct(array $project_Hierarchy = array())
    {
        $this
            ->setProject_Hierarchy($project_Hierarchy);
    }
    /**
     * Get Project_Hierarchy value
     * @return \StructType\Projects_HierarchyType[]|null
     */
    public function getProject_Hierarchy()
    {
        return $this->Project_Hierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Hierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Hierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_HierarchyForArrayConstraintsFromSetProject_Hierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $projects_Hierarchy_Response_DataTypeProject_HierarchyItem) {
            // validation for constraint: itemType
            if (!$projects_Hierarchy_Response_DataTypeProject_HierarchyItem instanceof \StructType\Projects_HierarchyType) {
                $invalidValues[] = is_object($projects_Hierarchy_Response_DataTypeProject_HierarchyItem) ? get_class($projects_Hierarchy_Response_DataTypeProject_HierarchyItem) : sprintf('%s(%s)', gettype($projects_Hierarchy_Response_DataTypeProject_HierarchyItem), var_export($projects_Hierarchy_Response_DataTypeProject_HierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Hierarchy property can only contain items of type \StructType\Projects_HierarchyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Hierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\Projects_HierarchyType[] $project_Hierarchy
     * @return \StructType\Projects_Hierarchy_Response_DataType
     */
    public function setProject_Hierarchy(array $project_Hierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($project_HierarchyArrayErrorMessage = self::validateProject_HierarchyForArrayConstraintsFromSetProject_Hierarchy($project_Hierarchy))) {
            throw new \InvalidArgumentException($project_HierarchyArrayErrorMessage, __LINE__);
        }
        $this->Project_Hierarchy = $project_Hierarchy;
        return $this;
    }
    /**
     * Add item to Project_Hierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\Projects_HierarchyType $item
     * @return \StructType\Projects_Hierarchy_Response_DataType
     */
    public function addToProject_Hierarchy(\StructType\Projects_HierarchyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Projects_HierarchyType) {
            throw new \InvalidArgumentException(sprintf('The Project_Hierarchy property can only contain items of type \StructType\Projects_HierarchyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Hierarchy[] = $item;
        return $this;
    }
}
